﻿using Ace.Wpf.Mvvm;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MalwarePatch.Models
{
    sealed class CertificateAdapter : NotificationObject
    {
        private readonly Certificates certificates;
        public CertificateAdapter(Certificates certificates)
        {
            this.certificates = certificates;
            UpdateState();
        }

        public string Name => certificates.DisplayName;

        private bool isAllowed;
        public bool IsAllowed
        {
            get => isAllowed;
            set
            {
                isAllowed = value;
                OnPropertyChanged(nameof(IsAllowed));
            }
        }
        public void UpdateState() => IsAllowed = !certificates.IsDisallowed;

        public void Allow()
        {
            if (IsAllowed && certificates.IsDisallowed)
            {
                certificates.Allow();
            }
        }

        public void Disallow()
        {
            if (!IsAllowed && !certificates.IsDisallowed)
            {
                certificates.Disallow();
            }
        }
    }
}
