﻿using Ace.Wpf.Mvvm;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MalwarePatch.Languages
{
    sealed class UserCertificateLanguage : Language<UserCertificateLanguage.Keys>
    {
        public enum Keys
        {
            Error,
            Tip,
            Complete,
            TipMessage,
            FileNotFound,
            FileNotSigned,
            Allowed,
            Disallowed,
            UnknownPublisher,
        }
        public UserCertificateLanguage()
        {
            translations.Add(new Translation
            {
                Culture = new System.Globalization.CultureInfo("en-US"),
                Texts = new List<string>
                {
                    "Error",
                    "Tip",
                    "Complete",
                    "Usage: --allow/--disallow=<filename>",
                    "Input file \"{0}\" not found.",
                    "Input file \"{0}\" is not signed.",
                    "Allowed programs from \"{0}\".",
                    "Disallowed programs from \"{0}\".",
                    "Unknown Publisher",
                }
            });
            translations.Add(new Translation
            {
                Culture = new System.Globalization.CultureInfo("zh-CN"),
                Texts = new List<string>
                {
                    "错误",
                    "提示",
                    "完成",
                    "用法: --allow/--disallow=<文件名>",
                    "输入的文件 \"{0}\" 不存在.",
                    "输入的文件 \"{0}\" 未签名.",
                    "已允许来自 \"{0}\" 的程序.",
                    "已屏蔽来自 \"{0}\" 的程序.",
                    "未知发布者",
                }
            });
        }
    }
}
