﻿using Ace.Wpf.Mvvm;
using MalwarePatch.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MalwarePatch.Languages
{
    sealed class UpdateLanguage : Language<UpdateLanguage.Keys>
    {
        public enum Keys
        {
            WindowTitle,
            ButtonDownload,
            ButtonRetry,
            ButtonRestart,
            TextProxyLabel,
            NewVerisonTitle,
            NewVerisonStatus,
            CheckingNewVersion,
            NoNewVerisonTitle,
            NoNewVerisonStatus,
            DownloadingStatus,
            DownloadCompleteStatus,
            CheckFailedStatus,
            CheckFailedTitle,
            DownloadFailedStatus,
            DownloadFailedTitle,
            UpdateFromPreupdateFile,
            Unknown,
            TextProxyPlaceholder,
        }
        public UpdateLanguage()
        {
            translations.Add(new Translation
            {
                Culture = new System.Globalization.CultureInfo("en-US"),
                Texts = new List<string>
                {
                    "Check for updates",
                    "Download",
                    "Check Again",
                    "Restart App",
                    "Proxy:",
                    "New Verison Available",
                    "Found new verison ({0}), click Download to update.",
                    "Checking updates...",
                    "Up to date",
                    "You are on latest verison.",
                    "Downloading...",
                    "Download complete. Exit app to run update, or click \"Restart App\" to restart app after updating.",
                    "Check update failed: {0}",
                    "Check update failed",
                    "Download failed: {0}",
                    "Download failed",
                    $"You cannot download update using a pre-update file ({Updater.UpdateFileName}).",
                    "Unknown error.",
                    "Default"
                }
            });
            translations.Add(new Translation
            {
                Culture = new System.Globalization.CultureInfo("zh-CN"),
                Texts = new List<string>
                {
                    "检查更新",
                    "下载更新",
                    "重新检查",
                    "重启程序",
                    "代理:",
                    "新版本可用",
                    "已发现新版本({0})，点击下载以开始更新。",
                    "正在检查新版本...",
                    "已是最新版本",
                    "没有发现更新的版本。",
                    "正在下载...",
                    "下载完成。关闭程序后将进行更新，或点击\"重启程序\"以在更新完成后再次启动。",
                    "检查更新失败: {0}",
                    "检查更新失败",
                    "下载失败: {0}",
                    "下载失败",
                    $"你不能在预更新文件({Updater.UpdateFileName})上下载更新。",
                    "未知错误。",
                    "默认",
                }
            });
        }
    }
}
