﻿using Ace;
using Ace.Files.Json;
using Ace.Wpf.Mvvm;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace MalwarePatch.Languages
{
  sealed class MainLanguage : Language<MainLanguage.Keys>
  {
    public enum Keys
    {
      Title,
      TextAvailablePatches,
      ButtonSave,
      ToggleUncheckedHelp,
      ToggleCheckedHelp,
      ButtonAdd,
      ButtonRemove,
      ButtonCheckAll,
      ButtonUncheckAll,
      ButtonUpdate,
      ButtonGetUpdate,
      TextSaved,
      TextNewVersion,
      DisallowProgram,
      AllowProgram,
      DisallowProgramDescription,
      AllowProgramDescription,
    }
    internal static DateTime LastModifiedTime => File.GetLastWriteTime(Process.GetCurrentProcess().MainModule.FileName);
    internal const int UpdateMonth = 10;
    internal static string UpdateTime
    {
      get
      {
        var now = new DateTime();
        return new DateTime(now.Year, UpdateMonth, now.Day).ToString("MMMM");
      }
    }
    public MainLanguage()
    {
      translations.Add(new Translation
      {
        Culture = new System.Globalization.CultureInfo("en-US"),
        Texts = new List<string>
          {
            $"{UpdateTime} Update - v{Assembly.GetExecutingAssembly().GetName().Version}",
            "Malware Patch",
            "Save",
            "Uncheck to disallow",
            "Check to allow",
            "Add",
            "Remove",
            "Allow All",
            "Disallow All",
            "Update",
            "Get Update",
            "Saved",
            "New Version Available",
            "Disallow program",
            "Allow program",
            "Select and disallow program.",
            "Select and Allow program.",
          }
      });
      translations.Add(new Translation
      {
        Culture = new System.Globalization.CultureInfo("zh-CN"),
        Texts = new List<string>
          {
            $"{UpdateTime}更新 - v{Assembly.GetExecutingAssembly().GetName().Version}",
            "软件屏蔽器",
            "保存更改",
            "打叉以屏蔽",
            "打勾以允许",
            "添加",
            "移除",
            "全部允许",
            "全部屏蔽",
            "检查更新",
            "查看更新",
            "已保存",
            "新版本可用",
            "屏蔽选定程序",
            "允许选定程序",
            "选择并屏蔽一个程序.",
            "选择并允许一个程序.",
          }
      });
    }
  }
}
