﻿using Ace;
using Ace.Wpf.Mvvm;
using MalwarePatch.Models;
using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace MalwarePatch.Commands
{
    class UserCertificateCommand : Ace.Wpf.Mvvm.Command
    {
        private readonly bool allow = true;
        private readonly IEnumerable<CertificateAdapter> certificates;
        public UserCertificateCommand(bool allow, IEnumerable<CertificateAdapter> certificates)
        {
            this.allow = allow;
            this.certificates = certificates;
        }

        protected override void ExecuteCommand(object parameter)
        {
            var dialog = new OpenFileDialog
            {
                AddExtension = true,
                DefaultExt = ".exe",
                Multiselect = false,
            };
            if (dialog.ShowDialog() ?? false)
            {
                var filename = dialog.FileName;
                var certificate = new UserCertificate(filename);
                if (allow)
                {
                    certificate.Allow();
                }
                else
                {
                    certificate.Disallow();
                }
                certificates?.ForEach(c => c.UpdateState());
            }
        }
    }
}
