using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Input;
using Ace;
using MalwarePatch.Models;

namespace MalwarePatch.Commands
{
    sealed class SaveChangesCommand : ICommand
    {
        public event EventHandler CanExecuteChanged;
        private void invokeCanExecuteChanged() => CanExecuteChanged?.Invoke(this, EventArgs.Empty);
        private readonly IEnumerable<CertificateAdapter> certificates;

        public Action BeforeExecute { get; set; }
        public Action AfterExecute { get; set; }
        public SaveChangesCommand(IEnumerable<CertificateAdapter> certificates)
        {
            this.certificates = certificates;
        }
        public bool CanExecute(object parameter)
        {
            return Utils.IsAdministratorProcess;
        }
        public async void Execute(object parameter)
        {
            BeforeExecute?.Invoke();
            await Task.Run(() =>
            {
                foreach (var certificate in certificates)
                {
                    if (certificate.IsAllowed)
                    {
                        certificate.Allow();
                    }
                    else
                    {
                        certificate.Disallow();
                    }
                }
            });
            AfterExecute?.Invoke();
        }
    }
}
