using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace MalwarePatch.Commands
{
    class DirectCommand : ICommand
    {
        public event EventHandler CanExecuteChanged;
        private void onCanExecuteChanged() => CanExecuteChanged?.Invoke(this, EventArgs.Empty);
        public Func<object, bool> CanExecuteFunc { get; set; }
        public bool CanExecute(object parameter) => CanExecuteFunc?.Invoke(parameter) ?? true;
        public Action<object> ExcuteAction { get; set; }
        public void Execute(object parameter) => ExcuteAction?.Invoke(parameter);
    }
}
