using MalwarePatch.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Input;

namespace MalwarePatch.Commands
{
    sealed class BatchCheckCommand : ICommand
    {
        private readonly bool checkValue;
        private readonly IEnumerable<CertificateAdapter> certificates;
        public BatchCheckCommand(bool checkValue, IEnumerable<CertificateAdapter> certificates)
        {
            this.checkValue = checkValue;
            this.certificates = certificates;
        }

        public event EventHandler CanExecuteChanged;
        private void invokeCanExecuteChanged() => CanExecuteChanged?.Invoke(this, EventArgs.Empty);

        public bool CanExecute(object parameter) => certificates.Count() != 0;
        public void Execute(object parameter)
        {
            foreach (var certificate in certificates)
            {
                certificate.IsAllowed = checkValue;
            }
        }
    }
}
