﻿using Ace;
using Ace.Files;
using MalwarePatch.Commands;
using MalwarePatch.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace MalwarePatch.CliTools
{
    static class UserCertificateCli
    {
        private const string disallowKey = "--disallow", allowKey = "--allow";
        public static bool TryParse(string[] args)
        {
            if (args.Length == 0)
            {
                return false;
            }
            var dict = string.Join(",", args).ToLowerInvariant().SplitToDictionary(",", "=", true);
            if (dict.ContainsKey(disallowKey))
            {
                var filename = dict[disallowKey]?.NoQuotes();
                if (filename is null)
                {
                    new UserCertificateCommand(allow: false, null).Execute();
                }
                else
                {
                    new UserCertificate(filename).Disallow();
                }
                return true;
            }
            if (dict.ContainsKey(allowKey))
            {
                var filename = dict[allowKey]?.NoQuotes();
                if (filename is null)
                {
                    new UserCertificateCommand(allow: true, null).Execute();
                }
                else
                {
                    new UserCertificate(filename).Allow();
                }
                return true;
            }
            return false;
        }
    }
}
