<?php
ini_set('date.timezone', 'PRC');
ini_set('default_charset', 'gbk');
define('IN_CHARSET', 'gbk');
define('IN_API', '');
define('IN_SECRET', '');
function destroyDir($dir){
        $ds = DIRECTORY_SEPARATOR;
        $dir = substr($dir, -1) == $ds ? substr($dir, 0, -1) : $dir;
        if(is_dir($dir) && $handle = opendir($dir)){
                while($file = readdir($handle)){
                        if($file == '.' || $file == '..'){
                                continue;
                        }elseif(is_dir($dir.$ds.$file)){
                                destroyDir($dir.$ds.$file);
                        }else{
                                unlink($dir.$ds.$file);
                        }
                }
                closedir($handle);
                rmdir($dir);
        }
}
function callback($resource){
        $info = curl_getinfo($resource);
        echo '<script type="text/javascript">setupload('.$info['size_upload'].', '.$info['upload_content_length'].');</script>';
        ob_flush();
        flush();
}
function convert_charset($str){
	return IN_CHARSET == 'gbk' ? iconv('GBK', 'UTF-8//IGNORE', $str) : $str;
}
function auth_codes($str, $mode='en', $key=''){
	if(empty($key)){
		return $mode == 'de' ? base64_decode($str) : base64_encode($str);
	}else{
		return $mode == 'de' ? base64_decode(str_replace(md5($key), '', $str)) : md5($key).base64_encode($str);
	}
}
function convert_utf8($str, $charset){
	if($charset !== IN_CHARSET){
		return IN_CHARSET == 'gbk' ? iconv('UTF-8', 'GBK//IGNORE', auth_codes(preg_replace('/\s/', '+', $str), 'de')) : iconv('GBK', 'UTF-8//IGNORE', auth_codes($str, 'de'));
	}else{
		return $charset == 'gbk' ? auth_codes($str, 'de') : auth_codes(preg_replace('/\s/', '+', $str), 'de');
	}
}
function image_crop($width, $height, $src, $path){
	list($s_width, $s_height, $s_type) = getimagesize($src);
	switch($s_type){
		case IMAGETYPE_GIF:
			$simage = imagecreatefromgif($src);
			break;
		case IMAGETYPE_JPEG:
			$simage = imagecreatefromjpeg($src);
			break;
		default:
			$simage = imagecreatefrompng($src);
			break;
	}
	$pimage = imagecreatetruecolor($width, $height);
	$bg = imagecolorallocatealpha($pimage, 255, 255, 255, 0);
	imagefill($pimage, 0, 0, $bg);
	imagecolortransparent($pimage, $bg);
	$ratio_w = 1.0 * $width / $s_width;
	$ratio_h = 1.0 * $height / $s_height;
	$ratio = $ratio_w < $ratio_h ? $ratio_h : $ratio_w;
	$tmp_w = (int)($width / $ratio);
	$tmp_h = (int)($height / $ratio);
	$tmp_img = imagecreatetruecolor($tmp_w, $tmp_h);
	$color = imagecolorallocate($tmp_img, 255, 255, 255);
	imagecolortransparent($tmp_img, $color);
	imagefill($tmp_img, 0, 0, $color);
	$s_x = (int)(($s_width - $tmp_w) / 2);
	$s_y = (int)(($s_height - $tmp_h) / 2);
	imagecopy($tmp_img, $simage, 0, 0, $s_x, $s_y, $tmp_w, $tmp_h);
	imagecopyresampled($pimage, $tmp_img, 0, 0, 0, 0, $width, $height, $tmp_w, $tmp_h);
	imagedestroy($tmp_img);
	imagesavealpha($pimage, true);
	imagepng($pimage, $path);
	imagedestroy($simage);
	imagedestroy($pimage);
}
?>