import { useRouter } from "next/router";
import { type DocsThemeConfig, useConfig } from "nextra-theme-docs";
import "nextra-theme-docs/style.css";
import faviconFormats from "./favicon-formats";
import styles from "./global.module.css";

const NO_INDEX_FOLLOW = process.env.CF_PAGES_BRANCH !== "main";

const config: DocsThemeConfig = {
    logo: (
        <span className={styles.logo}>
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 2759.9 544.87" width={200}>
                <title>hyperglass</title>
                <g fill="currentColor">
                    <g>
                        <path
                            d="M931.39,683.15q20.28,21.23,20.28,62.74l0,134.13c0,3.35-.85,5.94-2.51,7.76a10.52,10.52,0,0,1-14.15,0c-1.67-1.82-2.51-4.4-2.5-7.75l0-131.86q0-35.58-14.12-51.79t-45.62-16.21q-35.13,0-56.35,21.65t-21.24,57.71l0,120.44q0,5-2.51,7.76a9.12,9.12,0,0,1-7.07,2.74,9,9,0,0,1-6.84-3A10.66,10.66,0,0,1,776,880l.12-305.23q0-5,2.51-7.76a10.52,10.52,0,0,1,14.15,0c1.66,1.83,2.5,4.41,2.5,7.76l0,131.39a71.74,71.74,0,0,1,30.13-32.83q20.07-11.4,46.08-11.39Q911.09,661.93,931.39,683.15Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M1201.26,663a9.19,9.19,0,0,1,6.39,2.51,8.56,8.56,0,0,1,2.73,6.62,14.35,14.35,0,0,1-.91,4.1l-131,290.12q-2.75,5.48-8.22,5.47a8.83,8.83,0,0,1-6.16-2.28,7.66,7.66,0,0,1-2.5-5.93l.91-3.65,32.88-72.08L999.6,676.1a14.33,14.33,0,0,1-.91-4.11,8.65,8.65,0,0,1,3.19-6.84,10.93,10.93,0,0,1,7.3-2.73q5,0,7.76,5.48l88,198.49.91-2.28,86.76-194.78C1194.42,665.08,1197.31,662.94,1201.26,663Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M1406.57,676.48q22.34,14.38,34.66,40.39t12.29,60.69q0,34.22-12.34,60t-34.69,39.91q-22.37,14.13-51.56,14.12-27.84,0-47.67-12.33t-29.88-35.6l0,118.62c0,3.35-.84,5.93-2.51,7.76a9.15,9.15,0,0,1-7.07,2.73q-9.59,0-9.58-10.5l.11-289.25a10.34,10.34,0,0,1,2.51-7.3,10.49,10.49,0,0,1,14.14,0,10.42,10.42,0,0,1,2.51,7.3v36q10-22.81,29.89-34.9T1355,662.09Q1384.21,662.11,1406.57,676.48ZM1412,848q20.54-24.85,20.55-70.48T1412,706.37q-20.52-25.56-57-25.57-37.41,0-57.5,24.84t-20.1,70.94q0,46.09,20,71.18t57,25.12Q1391.44,872.9,1412,848Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M1688.91,847.68a8.28,8.28,0,0,1,2.28,5.71,14.17,14.17,0,0,1-3.43,8.89q-3.42,4.35-12.09,9.81-32.85,19.6-68,19.59-49.73,0-78.23-30.6t-28.49-84q0-34.22,12.8-60.22t36.06-40.36q23.28-14.37,53.39-14.35,42,0,66.14,27.4t24.15,74.83q0,8.21-3.19,11.86t-11.41,3.65l-157-.06q.43,44.71,22.56,68.9t62.27,24.2q21.9,0,36.27-5.91a146.07,146.07,0,0,0,28.07-15.51q9.57-6.37,12.32-6.38A7.16,7.16,0,0,1,1688.91,847.68Zm-141.61-146q-21.22,21.68-24.89,60.44l152.85.06q-.91-39.69-19.6-60.91T1603.2,680Q1568.52,680,1547.3,701.63Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M1855.05,663.19c3.65,0,6.16.69,7.52,2.06s2.06,3.42,2.06,6.16q0,7.77-9.59,9.12l-13.69,1.37q-33.3,3.18-50.19,24.61a77.43,77.43,0,0,0-16.9,49.27l0,124.56q0,5-2.51,7.75a10.5,10.5,0,0,1-14.15,0c-1.67-1.83-2.5-4.41-2.5-7.76l.08-206.68q0-10.49,9.58-10.49a9.25,9.25,0,0,1,6.84,2.74c1.83,1.83,2.74,4.41,2.74,7.76v32.85q19.62-39.22,71.19-42.86l6.38-.46Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M2078.6,666a9.84,9.84,0,0,1,2.74,7.3l-.08,204.85q0,47.45-22.38,71.62T1992.26,974q-24.65,0-43.34-4.58a127.8,127.8,0,0,1-36-15.07q-8.67-5.47-12.32-9.81a13.79,13.79,0,0,1-3.64-8.9,7.82,7.82,0,0,1,8.21-8.21q2.28,0,11.86,5.48a204.67,204.67,0,0,0,32.85,16q16.86,6.39,43.34,6.4,33.75,0,51.56-18.91t17.81-55.43l0-47.9q-9.59,23.71-29.9,36.26t-49.05,12.53q-29.2,0-51.78-13.71t-35.11-38.8q-12.54-25.08-12.53-57.49t12.57-57.25q12.56-24.85,35.15-38.54t51.79-13.67q28.27,0,48.35,12.34t30.1,35.14l0-36q0-10.5,9.58-10.49A9.25,9.25,0,0,1,2078.6,666Zm-37.25,172.67q20.78-24.39,20.79-66.83t-20.73-66.62q-20.76-24.18-57.71-24.2-36.51,0-57.72,24.16t-21.25,66.6q0,42.88,21.19,67.08t57.71,24.2Q2020.59,863.1,2041.35,838.69Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M2161.32,888.24c-1.67-1.83-2.51-4.41-2.5-7.76l.11-305.22q0-5,2.51-7.76a9.09,9.09,0,0,1,7.08-2.73,9,9,0,0,1,6.84,3,10.73,10.73,0,0,1,2.73,7.53L2178,880.49a10.75,10.75,0,0,1-2.74,7.53,9,9,0,0,1-6.85,3A9.09,9.09,0,0,1,2161.32,888.24Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M2416.64,744.16l0,136q0,5-2.51,7.76a9.12,9.12,0,0,1-7.08,2.73,9.45,9.45,0,0,1-7.29-3,10.66,10.66,0,0,1-2.74-7.53V848.18q-10,21-29,32.38T2324.88,892a84.41,84.41,0,0,1-38.32-8.68,71.93,71.93,0,0,1-27.6-23.51,59.47,59.47,0,0,1-10.71-33.08q-.43-25.08,12.34-38.78t42.89-19.6q30.12-5.91,84.41-5.9H2397V743.24q0-32.38-13-47.22t-40.83-14.85q-21.9,0-39,5.69t-27.15,13q-1.83,1.38-7.53,5.25c-3.81,2.59-6.93,3.87-9.36,3.87a7.82,7.82,0,0,1-5.7-2.51,8.37,8.37,0,0,1-2.51-6.16q0-8.65,16-18.24a134.23,134.23,0,0,1,34.91-14.59,146.13,146.13,0,0,1,37.64-5Q2416.67,662.5,2416.64,744.16ZM2361.85,863a69.15,69.15,0,0,0,25.78-27.13q9.36-17.34,9.37-39.24V780.2h-8.67q-47.91,0-73,3.85t-35.14,13.21q-10,9.36-10,27.6,0,21,15.49,34.46t39.24,13.47Q2345.41,872.79,2361.85,863Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M2526.54,886.78a122.09,122.09,0,0,1-31.93-14.38q-9.14-5.92-12.32-9.82a13.55,13.55,0,0,1-3.19-8.89,8.24,8.24,0,0,1,2.29-5.71,7.17,7.17,0,0,1,5.47-2.5q2.28,0,6.16,2.51c2.58,1.67,4.33,2.82,5.25,3.42a142.87,142.87,0,0,0,27.59,15.75q14.37,6.17,36.27,6.18,29.65,0,45.63-10.94t16-31q0-11.85-5.7-19.62t-18.7-13.46q-13-5.7-37.17-11.19Q2522,778,2504.69,763.82t-17.33-37.42q0-28.29,22.15-46.08t57.26-17.77a114.74,114.74,0,0,1,32.4,4.58,95.21,95.21,0,0,1,27.37,12.78q8.65,6.4,12.54,11.19a15.49,15.49,0,0,1,3.87,9.81,8.24,8.24,0,0,1-2.28,5.7,7.18,7.18,0,0,1-5.48,2.51c-2.44,0-6.38-2.29-11.86-6.85a127.56,127.56,0,0,0-24.86-15.07q-13-5.93-32.62-5.94-25.54,0-41.29,12.07T2508.81,725q0,11.87,5,19.39t17.1,13q12.09,5.47,34.45,10.5,31.47,7.78,48.35,15.76t24,19.18q7.07,11.18,7.06,28.51,0,27.38-22.6,44t-60,16.63A125.17,125.17,0,0,1,2526.54,886.78Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M2743.71,886.86a121.76,121.76,0,0,1-31.93-14.38q-9.14-5.93-12.32-9.81a13.6,13.6,0,0,1-3.19-8.9,8.25,8.25,0,0,1,2.29-5.7,7.14,7.14,0,0,1,5.47-2.51q2.28,0,6.16,2.51l5.25,3.42a143.22,143.22,0,0,0,27.6,15.76q14.36,6.16,36.26,6.17,29.65,0,45.63-10.93t16-31q0-11.87-5.69-19.62t-18.7-13.47q-13-5.7-37.18-11.19-40.15-9.13-57.48-23.29t-17.32-37.42q0-28.29,22.14-46.07T2784,662.64a114.31,114.31,0,0,1,32.39,4.57A94.83,94.83,0,0,1,2843.71,680q8.65,6.39,12.54,11.18a15.51,15.51,0,0,1,3.87,9.81,8.24,8.24,0,0,1-2.28,5.7,7.12,7.12,0,0,1-5.47,2.51q-3.66,0-11.86-6.85a128.65,128.65,0,0,0-24.86-15.07q-13-5.92-32.62-5.94-25.56,0-41.3,12.08T2726,725.12q0,11.86,5,19.39t17.1,13q12.09,5.47,34.45,10.51,31.47,7.77,48.35,15.76t24,19.17q7.07,11.19,7.06,28.51,0,27.38-22.6,44t-60,16.62A125.19,125.19,0,0,1,2743.71,886.86Z"
                            transform="translate(-102 -476.45)"
                        />
                    </g>
                    <g>
                        <path
                            d="M629,748.94A254.5,254.5,0,0,1,177.8,910.5a253.51,253.51,0,0,1-57-141.26A254.75,254.75,0,0,1,269.49,517c48.18-22.05,103.68-28.13,155.56-17.55a253.76,253.76,0,0,1,204,249.5c0,11.58,18,11.6,18,0-.15-56.09-17.45-111.67-50.07-157.4A275.77,275.77,0,0,0,468,492.94c-53.4-19.67-113.16-21.73-167.89-6.22A272.65,272.65,0,0,0,141.23,889.87c28.26,46.62,70.66,84.65,120.38,107.11a275.73,275.73,0,0,0,167.55,18.95,272.71,272.71,0,0,0,142.15-78.52c38.14-39.87,64-91.3,72.33-145.91A287.4,287.4,0,0,0,647,748.94C647,737.36,629,737.34,629,748.94Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M276.33,926.44a203,203,0,0,0,98.67,26c7.72,0,7.73-12,0-12a190.29,190.29,0,0,1-92.62-24.36c-6.74-3.79-12.79,6.58-6.05,10.36Z"
                            transform="translate(-102 -476.45)"
                        />
                        <path
                            d="M233.58,611c-28.56,28.78-48.31,65.84-55.4,105.83a199.79,199.79,0,0,0,55.4,177c5.45,5.49,13.93-3,8.48-8.48C186.68,829.56,171,742.65,205.27,671.45a191.94,191.94,0,0,1,36.79-52c5.45-5.48-3-14-8.48-8.48Z"
                            transform="translate(-102 -476.45)"
                        />
                    </g>
                </g>
            </svg>
        </span>
    ),
    head: () => {
        const { asPath, locale, defaultLocale } = useRouter();
        const { frontMatter } = useConfig();
        const url = `https://hyperglass.dev${
            defaultLocale === locale ? asPath : `/${locale}${asPath}`
        }`;
        let title = frontMatter.title || "hyperglass";
        if (title !== "hyperglass") {
            title = `${title} | hyperglass`;
        }
        const description = frontMatter.description || "hyperglass Documentation";
        const index = NO_INDEX_FOLLOW ? "noindex, nofollow" : "index, follow";
        const favicons = faviconFormats.map((fmt) => {
            const { image_format, dimensions, prefix, rel } = fmt;
            const [w, h] = dimensions;
            const href = `/img/${prefix}-${w}x${h}.${image_format}`;
            return { rel: rel ?? "", href, type: `image/${image_format}` };
        });

        return (
            <head>
                <title>{title}</title>
                <meta property="og:url" content={url} />
                <meta property="og:title" content={title} />
                <meta property="og:description" content={description} />
                <meta property="og:type" content="website" />
                <meta property="og:image" content="https://hyperglass.dev/opengraph.jpg" />
                <meta name="twitter:card" content="summary_large_image" />
                <meta name="twitter:domain" content="hyperglass.dev" />
                <meta name="twitter:url" content="https://hyperglass.dev" />
                <meta name="twitter:title" content={title} />
                <meta name="twitter:description" content={description} />
                <meta name="twitter:image" content="https://hyperglass.dev/opengraph.jpg" />
                <meta name="robots" content={index} />
                <link rel="manifest" href="/img/manifest.json" />
                {favicons.map((props) => (
                    <link key={props.href} {...props} />
                ))}
            </head>
        );
    },
    docsRepositoryBase: "https://github.com/thatmattlove/hyperglass/tree/main/docs",
    banner: {
        dismissible: true,
        content: "🎉 hyperglass 2.0 is here! This documentation is still in development, though.",
    },
    feedback: { content: null },
    footer: { content: `© ${new Date().getFullYear()} hyperglass` },
    editLink: { component: null },
    chat: {
        link: "https://netdev.chat/",
        icon: (
            <svg
                xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 448 512"
                width="24"
                height="24"
                fill="currentColor"
            >
                <title>NetDev Chat</title>
                <path d="M94.12 315.1c0 25.9-21.16 47.06-47.06 47.06S0 341 0 315.1c0-25.9 21.16-47.06 47.06-47.06h47.06v47.06zm23.72 0c0-25.9 21.16-47.06 47.06-47.06s47.06 21.16 47.06 47.06v117.84c0 25.9-21.16 47.06-47.06 47.06s-47.06-21.16-47.06-47.06V315.1zm47.06-188.98c-25.9 0-47.06-21.16-47.06-47.06S139 32 164.9 32s47.06 21.16 47.06 47.06v47.06H164.9zm0 23.72c25.9 0 47.06 21.16 47.06 47.06s-21.16 47.06-47.06 47.06H47.06C21.16 243.96 0 222.8 0 196.9s21.16-47.06 47.06-47.06H164.9zm188.98 47.06c0-25.9 21.16-47.06 47.06-47.06 25.9 0 47.06 21.16 47.06 47.06s-21.16 47.06-47.06 47.06h-47.06V196.9zm-23.72 0c0 25.9-21.16 47.06-47.06 47.06-25.9 0-47.06-21.16-47.06-47.06V79.06c0-25.9 21.16-47.06 47.06-47.06 25.9 0 47.06 21.16 47.06 47.06V196.9zM283.1 385.88c25.9 0 47.06 21.16 47.06 47.06 0 25.9-21.16 47.06-47.06 47.06-25.9 0-47.06-21.16-47.06-47.06v-47.06h47.06zm0-23.72c-25.9 0-47.06-21.16-47.06-47.06 0-25.9 21.16-47.06 47.06-47.06h117.84c25.9 0 47.06 21.16 47.06 47.06 0 25.9-21.16 47.06-47.06 47.06H283.1z" />
            </svg>
        ),
    },
    project: {
        link: "https://github.com/thatmattlove/hyperglass",
    },
};

export default config;
