---
title: 名词解释
description: 本文介绍了Telegram上的常用术语，包括：UID、用户名、注册时间；好友、联系人；私聊、群组、频道；封禁、拉黑、禁言等，帮助小白快速入门Telegram。访问TGwiki - Telegram知识库，了解更多Telegram使用技巧。
head:
  - - meta
    - name: keywords
      content: Telegram名词解释,Telegram术语,Telegram UID,Telegram用户名,Telegram注册时间,Telegram好友,Telegram联系人,Telegram私聊,Telegram群组,Telegram频道,Telegram封禁,Telegram拉黑,Telegram禁言,TG名词解释,TG术语,TG UID,TG用户名,TG注册时间,TG好友,TG联系人,TG私聊,TG群组,TG频道,TG封禁,TG拉黑,TG禁言,电报名词解释,电报术语,电报UID,电报用户名,电报注册时间,电报好友,电报联系人,电报私聊,电报群组,电报频道,电报封禁,电报拉黑,电报禁言,Telegram入门,TGwiki,Telegram知识库
---

# Telegram名词解释

## UID

唯一标识，每一个用户/群组/频道/机器人都有一个独一无二的数字标识，**无法更改**，注销重新注册新的账号，UID就会生成新的了。

### 如何知道自己的UID？

1. TG 官方客户端上是不会显示UID的。

2. 可以使用机器人查看，比如: [@getidsbot](https://t.me/getidsbot) [@Sean_Bot](https://t.me/Sean_Bot) [@userinfobot](https://t.me/userinfobot)[ @username_to_id_bot](https://t.me/username_to_id_bot)

    ::: details 操作演示

    ![A-id.jpg](https://cdn.jsdelivr.net/gh/tgwiki/images/A/id.jpg)

    :::

3. 使用第三方客户端查看。

   ::: tip

   关于第三方客户端的说明请参阅 [此处](/tgwiki/thirdparty) 。

   :::

### UID有何作用？

1. 不能直接使用UID搜索到人，不过某些客户端可以使用链接形式找到人：`tg://user?id=UID`
2. 某些机器人或userbot可以使用UID禁言或封禁用户。

## 用户名

英文标识，独一无二的，每个人、群组、频道、机器人的用户名都是不重复的。格式: `@username` 或 `https://t.me/username`。

可以为空，可以不设置用户名，设置后方便其他人在Telegram全局搜索中找到你。

## 注册时间

TG默认不会显示账号的注册时间，可以通过以下方式查看大致的时间，不一定准确：

- 机器人查看，比如：[@creationdatebot](https://t.me/creationdatebot) [@getidsbot](https://t.me/getidsbot)
- 第三方客户端查看。关于第三方客户端的说明请参阅 [此处](/tgwiki/thirdparty) 。

## 好友、联系人

::: tip

Telegram没有"好友"的概念和功能，所以也就不存在"加好友"的说法，Telegram 有"群组/频道/联系人"

:::

Telegram 有"联系人"，有单向联系人和双向联系人

* 点击对方的个人信息->添加联系人，此时添加的为单向联系人

* 如果对方也添加你到他的联系人列表，这样才会成为双向联系人

* 添加联系人时，务必记得取消勾选"分享我的手机号码（Share My Phone Number）"，如果不取消勾选，那对方就能看到你的电话号码

  ::: danger

  不要乱加别人为联系人

  :::

* 如果已经添加了对方为联系人并且勾选了`分享我的手机号码（Share My Phone Number）`，可以在`设置`->`隐私`->`手机号码`中取消分享手机号码，请参阅 [Telegram隐私设置](/tgwiki/privacy) 。
* 为了方便以后找人，可以添加一些常联系的人为联系人，添加联系人也可以修改对方的名称或加备注。
* 你添加对方为联系人后, 对方不会有任何提示和通知你已添加了的, 对方也不会知道你已添加对方为联系人了

## 私聊、群组、频道

Telegram有几种方式: 私聊、群组、频道、机器人

1. 私聊：和某个账号一对一的聊天，私聊分为：普通私聊和加密对话。

   * 可以直接给对方发送私聊和加密对话功能的，不需要添加联系人也可以发送私聊(暂时还没禁止别人给你发起私聊的功能)
   * 点击对方的个人信息->发送消息，就可以直接发送私聊了
   * 如果提示"目前您只能给双向联系人发送消息"，那可能是你被官方限制了
   * 可以直接用别人的链接和搜索用户名发送私聊

   参阅 [Telegram加密对话](/tgwiki/encrypt) 。

2. 群组：也就是多人同时聊天，群主创建一个群组后，用户可以加进去，大家都可以发言聊天。曾经有"普通群"和"超级群"，不过现在创建的都是超级群，大家加入的绝大部分都是超级群，超级群最多20W人。群组分为：私有群和公开群、群组创建时候可以选择群组的类型（公开群组、私有群组）。

   - 公开群：必须自定义设置一个公开的用户名作为群组的链接（格式: `@username` 或 `https://t.me/username` ），可以用此链接查看和加入群组，会直接在群简介界面显示公开链接，公开群的主要特点: 点击链接不加入群组也能看到群组内的消息和群组的成员列表
   - 私有群: 不能自定义设置公开链接，只能由群主和管理员创建私有的群分享链接（格式：`https://t.me/+xxxx` ），私有群就必须加入群才能看到群组内的消息和群组的成员列表。公开群也可以创建这种格式私有的分享链接。

   ::: tip

   如何区分公开群和私有群：

   - 群主可以在群设置中查看

   - 查看群简介界面是否有公开链接

   :::

   参阅 [Telegram创建群组](/tgwiki/creategroup) 。

3. 频道：相当于微信的公众号，只能关注和取消关注频道，只有频道主和频道管理才能在频道发布内容，成员只能查看和转发频道的内容，频道主也可设置禁止转发和复制频道内容。频道也分为：私有频道和公开频道，和群组类似，但成员无法查看频道的成员列表，只有频道主和管理员才可查看。

   参阅 [Telegram创建频道](/tgwiki/createchannel) 。

4. 频道的评论功能：是频道关联群组后的功能。

   参阅 [Telegram频道消息添加"评论"功能](/tgwiki/comment) 。

## 封禁、拉黑、禁言

1. 封禁

   封禁有2种情况：

   - 手机号和TG账号被封禁，这种就是禁止登录，就是封号了，在登录界面就会提示"is banned"

   - 被群组或频道封禁，和第2点的"ban"是一个意思

2. ban

   ban，也叫封禁，也叫拉黑

   - 群组或频道的管理员（或有管理员权限的机器人）可以ban成员。

   - 被群组或频道封禁，被群组或频道的管理员拉入群组或频道的黑名单了，也就禁止你的号再加入群组或频道了。只能管理员取消封禁（拉黑），你才能再加入群组或频道。

   - 如果你是用频道身份在群里发言的，群组管理员可以ban了你的频道，这样你在这个群就再也不能用频道发言了，其他频道频道也不行，在其他群里可以；不过这只能ban你的频道，不能ban了你的个人账号。

3. 禁言/限制

   - 群组管理员（或有管理员权限的机器人）可以禁言成员。

   - 被禁言后，你依然还在群里，也能看到大家发的消息，只是你无法发消息而已，没有被踢出群。

   - 禁言可以选时间: x小时/x天/自定义/永久；如果有时间的，可以等到时间结束了就可以自动解除禁言了，如果是永久的，就只能找群管理员取消禁言了。

4. 全员禁言

   群组管理员（或有管理员权限的机器人）可以在群组设置中关闭成员的"发送消息"权限，所有成员都不能发送消息，只有群管理员能发消息

::: tip

被封禁或被禁言或全群禁言，TG客户端界面都有相应的内容显示。

:::
