## Fragaria - From 'r's in Strawberry to Complex Problem-Solving AI
**Advanced Chain of Thought (CoT) Reasoning API with Reinforcement Learning (RL)**

![Fragaria Logo](header.png)

Fragaria is a powerful and flexible Chain of Thought (CoT) reasoning API that leverages various Language Model (LLM) providers and incorporates Reinforcement Learning (RL) techniques to solve complex problems and answer intricate questions. Named after the botanical genus of strawberries, Fragaria pays homage to the famous "How many 'r's in strawberry?" problem, symbolizing its ability to tackle both simple and complex queries with equal finesse.

## Table of Contents

- [Features](#features)
- [Installation](#installation)
- [Configuration](#configuration)
- [Usage](#usage)
- [API Documentation](#api-documentation)
- [Examples](#examples)
- [Contributing](#contributing)
- [License](#license)

## Features

- **Multi-Provider Support**: Seamlessly switch between OpenAI, Groq, and Together.ai as LLM providers.
- **Chain of Thought Reasoning**: Employ sophisticated CoT techniques to break down and solve complex problems.
- **Reinforcement Learning**: Utilize RL algorithms to continuously improve problem-solving strategies and adapt to new challenges.
- **Adaptive Learning**: Enhance performance over time through a SQLite-based scoring system integrated with RL techniques.
- **Configurable**: Easy-to-update YAML configuration file for flexible setup of both LLM and RL parameters.
- **OpenAPI Documentation**: Comprehensive API documentation with Swagger UI and ReDoc.
- **CORS Support**: Built-in Cross-Origin Resource Sharing for easy integration with web applications.

## Installation

1. Clone the repository:
   ```
   git clone https://github.com/terraprompt/fragaria.git
   cd fragaria
   ```

2. Create a virtual environment (optional but recommended):
   ```
   python -m venv venv
   source venv/bin/activate  # On Windows, use `venv\Scripts\activate`
   ```

3. Install the required dependencies:
   ```
   pip install -r requirements.txt
   ```

## Configuration

1. Copy the `config.yaml.example` file to `config.yaml`:
   ```
   cp config.yaml.example config.yaml
   ```

2. Open `config.yaml` and update the following settings:
   - Set your preferred `llm_provider` (openai, groq, or together)
   - Add your API keys for the respective providers
   - Adjust the model names if necessary
   - Modify the database path and server settings if needed

## Usage

1. Start the Fragaria API server:
   ```
   python main.py
   ```

2. The API will be available at `http://localhost:8000` (or the host/port specified in your config).

3. You can now send POST requests to `http://localhost:8000/v1/chat/completions` to use the Chain of Thought reasoning capabilities.

## API Documentation

Fragaria provides comprehensive API documentation:

- Swagger UI: `http://localhost:8000/docs`
- ReDoc: `http://localhost:8000/redoc`
- OpenAPI JSON schema: `http://localhost:8000/openapi.json`

## Examples

Here are some sample problems you can solve using Fragaria:

1. The classic strawberry problem:
   ```json
   {
     "model": "faragia-dev",
     "messages": [
       {"role": "user", "content": "How many 'r's in strawberry?"}
     ]
   }
   ```

2. A more complex age-related puzzle:
   ```json
   {
     "model": "faragia-dev",
     "messages": [
       {"role": "user", "content": "A princess is as old as the prince will be when the princess is twice as old as the prince was when the princess's age was half the sum of their present age. What is the age of prince and princess? Provide all solutions to that question."}
     ]
   }
   ```

To solve these problems, send a POST request to `/v1/chat/completions` with the above JSON payloads.

## How It Works

Fragaria employs a sophisticated Chain of Thought (CoT) reasoning process enhanced by Reinforcement Learning:

1. **Problem Classification**: Categorizes the input problem into known or new problem types.
2. **CoT Path Generation**: Creates multiple reasoning approaches for the problem type, influenced by past performance.
3. **Parallel Execution**: Applies each CoT path to the problem concurrently.
4. **Result Combination**: Synthesizes the results from different paths.
5. **Evaluation**: Scores the effectiveness of each approach.
6. **Reinforcement Learning Update**: Uses the evaluation scores as rewards to update the RL policy, influencing future path selections and generations.
7. **Adaptive Learning**: Updates the scoring database and RL model to improve future performance.

This RL-enhanced process allows Fragaria to not only tackle a wide range of problems but also to learn and adapt its strategies over time, becoming increasingly efficient at solving both familiar and novel problem types.


## Contributing

We welcome contributions to Fragaria! Please follow these steps to contribute:

1. Fork the repository.
2. Create a new branch for your feature or bug fix.
3. Make your changes and commit them with clear, descriptive messages.
4. Push your changes to your fork.
5. Submit a pull request to the main Fragaria repository.

Please ensure your code adheres to the project's coding standards and include tests for new features.

## License

Fragaria is released under the MIT License. See the [LICENSE](LICENSE) file for details.

## Citation

If you use Fragaria in your research or wish to refer to it in your publications, please use the following BibTeX entry:

```bibtex
@software{fragaria2024,
  author       = {{Dipankar Sarkar}},
  title        = {Fragaria: Advanced Chain of Thought Reasoning API with Reinforcement Learning},
  year         = 2024,
  publisher    = {GitHub},
  journal      = {GitHub repository},
  howpublished = {\url{https://github.com/terraprompt/fragaria}},
}
```

For academic papers, you can cite Fragaria as:

Dipankar Sarkar. (2024). Fragaria: Advanced Chain of Thought Reasoning API with Reinforcement Learning [Computer software]. https://github.com/terraprompt/fragaria

---

Fragaria is maintained by the [TerraPrompt](https://github.com/terraprompt) team. For any questions or support, please open an issue on the GitHub repository.
