## How to contribute

By participating in this project, you agree to abide by the [code of conduct](CODE_OF_CONDUCT.md)

### Getting Started

1. Fork, then clone the repo:

  ```bash
  git clone git@github.com:your-username/ramme.git
  ```

2. Install the project dependencies:

  ```bash
  cd ramme

  # Using yarn
  yarn install

  # OR

  # Using NPM
  npm install
  ```

3. Make your change.

4. Start the app, test your change, make sure it is working as expected.

  ```bash
  # Using yarn
  yarn dev

  # OR

  # Using NPM
  npm run dev
  ```

5. After confirming the correctness of your change, push it to your fork and [submit a pull request](https://github.com/terkelg/ramme/compare/)

6. Wait or mention someone to review your pull request.

### Additional Resources

* [How to write a good commit message](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html)
* [How to write the perfect pull request](https://github.com/blog/1943-how-to-write-the-perfect-pull-request)
* [General GitHub documentation](https://help.github.com/)
* [GitHub pull request documentation](https://help.github.com/articles/creating-a-pull-request/)
* [Github requesting a pull request review documentation](https://help.github.com/articles/requesting-a-pull-request-review/)


## Financial contributions

We also welcome financial contributions in full transparency on our [open collective](https://opencollective.com/ramme).
Anyone can file an expense. If the expense makes sense for the development of the community, it will be "merged" in the ledger of our open collective by the core contributors and the person who filed the expense will be reimbursed.


## Credits


### Contributors

Thank you to all the people who have already contributed to ramme!
<a href="graphs/contributors"><img src="https://opencollective.com/ramme/contributors.svg?width=890" /></a>


### Backers

Thank you to all our backers! [[Become a backer](https://opencollective.com/ramme#backer)]

<a href="https://opencollective.com/ramme#backers" target="_blank"><img src="https://opencollective.com/ramme/backers.svg?width=890"></a>


### Sponsors

Thank you to all our sponsors! (please ask your company to also support this open source project by [becoming a sponsor](https://opencollective.com/ramme#sponsor))

<a href="https://opencollective.com/ramme/sponsor/0/website" target="_blank"><img src="https://opencollective.com/ramme/sponsor/0/avatar.svg"></a>
<a href="https://opencollective.com/ramme/sponsor/1/website" target="_blank"><img src="https://opencollective.com/ramme/sponsor/1/avatar.svg"></a>
<a href="https://opencollective.com/ramme/sponsor/2/website" target="_blank"><img src="https://opencollective.com/ramme/sponsor/2/avatar.svg"></a>
<a href="https://opencollective.com/ramme/sponsor/3/website" target="_blank"><img src="https://opencollective.com/ramme/sponsor/3/avatar.svg"></a>
<a href="https://opencollective.com/ramme/sponsor/4/website" target="_blank"><img src="https://opencollective.com/ramme/sponsor/4/avatar.svg"></a>
<a href="https://opencollective.com/ramme/sponsor/5/website" target="_blank"><img src="https://opencollective.com/ramme/sponsor/5/avatar.svg"></a>
<a href="https://opencollective.com/ramme/sponsor/6/website" target="_blank"><img src="https://opencollective.com/ramme/sponsor/6/avatar.svg"></a>
<a href="https://opencollective.com/ramme/sponsor/7/website" target="_blank"><img src="https://opencollective.com/ramme/sponsor/7/avatar.svg"></a>
<a href="https://opencollective.com/ramme/sponsor/8/website" target="_blank"><img src="https://opencollective.com/ramme/sponsor/8/avatar.svg"></a>
<a href="https://opencollective.com/ramme/sponsor/9/website" target="_blank"><img src="https://opencollective.com/ramme/sponsor/9/avatar.svg"></a>