<?php

declare(strict_types=1);

/*
 * This file is part of the tenancy/tenancy package.
 *
 * Copyright Tenancy for Laravel
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @see https://tenancy.dev
 * @see https://github.com/tenancy
 */

namespace Tenancy\Tests\Affects\Configs;

use Tenancy\Affects\Configs\Events\ConfigureConfig;

trait ThroughConfig
{
    protected function registerAffecting()
    {
        $this->events->listen(ConfigureConfig::class, function (ConfigureConfig $event) {
            $event->config->set('testing.tenant', $event->event->tenant->getTenantKey());
        });
    }
}
