---
title: Introduction
page_title: Introduction - Kendo UI for Vue
description: "Introduction on using the Kendo UI for Vue."
position: -1
slug: introduction
canonicalLink: "https://www.telerik.com/kendo-vue-ui/components/introduction"
category: introduction
---

<WrapperBanner link="/kendo-vue-ui/components/introduction"></WrapperBanner>

# Welcome to Kendo UI for Vue Wrappers

Thank you for choosing Kendo UI for Vue Wrappers suite!

[Vue](https://vuejs.org/) is a progressive framework for building user interfaces that is designed from the ground up to be incrementally adoptable. The Kendo UI Wrappers for Vue suite facilitates the front-end development by providing you with more than 70 ready made UI components.

The Kendo UI Wrappers for Vue suite shares HTML rendering and web assets (like stylesheets) with the other Kendo UI suites, so you can reuse existing knowledge and classes. The components in the **Kendo UI Wrappers for Vue suite are wrappers of the [Kendo UI for jQuery](https://demos.telerik.com/kendo-ui/) widgets**. It is a library that has been build for years and is providing fully functional complex components like Grid, Scheduler, Charts, Gantt and many more.

In parallel with the Wrappers components we are also developing a **Kendo UI Native for Vue suite** where we develop truly native components designed specially for the Vue framework. You can read more about that here:

* [Kendo UI Native suite for Vue](slug:introduction)

<div data-component="StartFreeTrialSection"></div>

## Getting Started

If you are new to Kendo UI Wrappers for Vue suite, we recommend that you **follow the First Steps article** to add the Kendo components to your application:

* [Get Started with Kendo UI Wrappers for Vue suite](slug:getting_started)

If you are just getting started with Vue and Web development, you may find the following articles useful in getting up to speed with the core concepts:

* [What is Vue.js?](https://v3.vuejs.org/guide/introduction.html)

## List of Components

Kendo UI Wrappers for Vue is a suite with more than 70 components. We are also constantly working on adding new features and components.

Here are some of the most popular components:

* [Grid](slug:overview_grid)
* [DropDownLists](slug:overview_dropdowns)
* [Inputs](slug:overview_inputs)
* [Layout](slug:overview_layout)
* [Charts](slug:overview_charts)
* [Spreadsheet](slug:overview_spreadsheet)
* [Scheduler](slug:overview_scheduler)
* and you can check about 70 more components [here](https://www.telerik.com/kendo-vue-ui/components/)

Tell us which components you want implemented and how you intend to use them on [our feedback portal](https://feedback.telerik.com/kendo-vue-ui).

