---
title: Community &amp; Support - Kendo UI for Vue
description: Something does not work as you expect? Stuck in a complex scenario? Get the necessary help!
---

# Support
<h2 id="how-do-i" class="h3">How do I&hellip;?</h2>
<ol>
  <li>Check out the <a href="https://www.telerik.com/kendo-vue-ui/components/">Components page </a> to find sample code.</li>
  <li>Look through <a href="https://www.telerik.com/forums/kendo-ui-vue">our official Kendo UI for Vue forums</a> and search for an answer there. If you cannot find one, feel free to start your own thread.</li>
  <li>Browse the <a href="https://stackoverflow.com/questions/tagged/kendo-ui">kendo-ui </a> questions on Stack Overflow. </li>
  <li>If you don't find what you are looking for on Stack Overflow, post a question for the Stack Overflow community or use our official support channel and <a href="https://www.telerik.com/account/support-center/contact-us/technical-support">submit a support ticket</a>.</li>
</ol>

<h2 class="h3">When do you plan on releasing Feature X?</h2>
<ol>
	<li>Check the <a href="https://www.telerik.com/support/whats-new/kendo-vue-ui/roadmap">Roadmap</a> for the planned items.</li>
	<li>If the item you need is not present there, <a href="https://feedback.telerik.com/kendo-vue-ui">check our feedback portal</a>. If someone has already posted it there, you can upvote it. If nobody has requested it so far, you can post a new idea.</li>
</ol>

<h2 id="bug-found" class="h3">I think I found a bug</h2>
<ol>
	<li>Review the issues in our <a href="https://feedback.telerik.com/kendo-vue-ui?typeId=3&listMode=Recent">Feedback portal</a>. Maybe someone has already reported it and it will be fixed soon.</li>
  <li>The problem might have also been fixed. In this case, you will find the issue in <a href="https://feedback.telerik.com/kendo-vue-ui?listMode=Recent&typeId=3&statusId=2">the list of fixed bugs</a>.</li>
  <li>If you cannot find your issue, <a href="#bug-reporting">follow the reproduction steps guide below</a>. We will look into it.</li>
</ol>

<h2 id="bug-reporting" class="h3">I want to report a bug</h2>

<p>Kendo UI for Vue uses the <a href="https://feedback.telerik.com/kendo-vue-ui?typeId=3&listMode=Recent">Telerik Feedback portal</a> as an official bug trackers.</p>

<h3 class="h4">Steps</h3>
<ol>
  <li>Find an example in the <a href="https://www.telerik.com/kendo-vue-ui/components">documentation</a> that looks similar to your case.</li>
  <li>Open it in Stackblitz by using the OPEN IN STACKBLITZ button.</li>
  <li>Modify the demo, so that the issue is reproducible in it. Try to include the minimum possible amount of code.</li>
  <li>Save the demo by using the blue Save button at the top.</li>
  <li>Copy the link from the address bar of the browser.</li>
  <li><a href="https://www.telerik.com/account/support-center/contact-us/technical-support">Submit the bug</a> as a support ticket and add the Stackblitz link in the description of the issue.</li>
  <li>Provide any additional information necessary for us to reproduce the problem for example, browser version, steps to perform, etc.</li>
</ol>

<p>We might not be able to act on issues without a runnable demo.</p>

<p>If you need assistance on troubleshooting or isolating a problem, you can request a remote assistance session through our <a href="https://www.telerik.com/account/support-center/contact-us/technical-support">Support Ticket</a> system. Remote Assistance is included in the <a href="https://www.telerik.com/purchase/kendo-ui">DevCraft Ultimate</a> subscription.</p>

<h2 id="support-plans" class="h3">I need a tailor-made solution</h2>

<p>Our aim is to provide the most versatile and proven set of application building blocks. Still, depending on the functionality you desire, some assembly is required.</p>

<p>The <a href="https://www.telerik.com/services">Telerik Services</a> team is available to assist in building functional blocks or complete applications according to your specification. They will help you make the most of Kendo UI for Vue while freeing you to work on your core business problems.</p>
