---
title: SVG Icons
description: "How to use SVG icons with the Kendo UI for Vue Native components."
slug: svg_icons
position: 33
---

# SVG Icons

Kendo UI for Vue delivers more than 500 Scalable Vector Graphics (SVG) icons.

> Currently, you can use the predefined set of SVG icons with the [Kendo UI for Vue SVG Icon component](slug:overview_svgicon) only.
## What Are SVG Icons

SVG icons are vector images defined in an XML format. They are blocks of XML tags and allow vector graphics to be displayed on a webpage.

## Why Use SVG Icons

If you need to display vector graphics within a webpage, you can use [font icons](slug:icons) and `SVG` icons.

SVG icons are best suited to be used when:

* Rendering and scalability&mdash;They are treated by the browsers as images, so anti-aliasing issues are avoided. This ensures that SVG icons are sharp at all resolutions, without losing quality.
* Flexibility&mdash;You can control individual parts of an SVG icon with CSS (font-size, color, animation). Also, you can use available SVG-specific CSS filters and stroke properties. Multi-color SVG icons are supported.
* Accessibility&mdash;Using semantic elements and attributes, such as `<title>`, `<desc>`, `aria-labelledby`, and so on, makes them accessible to screen readers, search engines, and other devices.

## Basic Usage

To use the Kendo UI SVG icons, refer to the [Kendo UI for Vue Native SVG Icon component](slug:overview_svgicon).

<!-- ## List of SVG Icons
 the full list of the available predefined Kendo UI SVG icons, refer to [this section](slug:svgicon_list). -->

## Suggested Links

* [Themes and Styling in Kendo UI for Vue](slug:themesandstyles)
* [Getting Started with Kendo UI for Vue - JavaScript (Online Guide)](slug:getting_started_javascript_composition_api)
* [Getting Started with Kendo UI for Vue - TypeScript (Online Guide)](slug:getting_started_typescript_composition_api)
* [Getting Started with Kendo UI for Vue - JavaScript + Options API (Online Guide)](slug:getting_started_javascript_options_api)
* [Getting Started with Kendo UI for Vue - TypeScript + Options API (Online Guide)](slug:getting_started_typescript_options_api)
* [Getting Started with Kendo UI for Vue - Nuxt 3 (Online Guide)](slug:getting_started_nuxt_3)
* [Kendo UI for Vue Native Components](https://www.telerik.com/kendo-vue-ui/components)