---
title: Coffee Warehouse Dashboard
page_title: Vue Dashboard – Coffee Warehouse Sample App - Kendo UI for Vue
description: A Kendo UI for Vue application that implements the Native Data Grid, Scheduler, Charts, Form, Drawer and other components that are part of the library.
slug: vue-coffee-warehouse-dashboard
position: 2
---

# Coffee Warehouse Dashboard Application

The Kendo UI for Vue Native suite provides a number of components that can be combined in a way that fits the requirements of your application. The current application uses the Native Data Grid, Charts, Scheduler, Drawer, From and other Native components to show how we can build a complex Dashboard application. 


## About the App

The `Coffee Warehouse Dashboard` application is created following the best practices of building a Vue Application. The application has four main sections:

* Team - Demonstrates the usage of the Native [Grid]({% slug overview_grid %}) component with its ability to export data to Excel and PDF. 
* Dashboard - Shows the Native [Chart]({% slug overview_charts %}) components in action.
* Profile - Showcases the usage of the Native Form component in a combination with the Native [Input]({% slug overview_textbox %}), [MaskedTexBox]({% slug overview_maskedtextbox %}), [DropDownList]({% slug overview_dropdownlist %}), [Editor]({% slug overview_editor %}), [Switch]({% slug overview_switch %}) and [RadioGroup]({% slug overview_radiogroup %}) components. 
* Info - Lists the different Kendo UI for Vue Native components used to implement the final application.

>The source code of the Coffee Warehouse application can be found in [our public GitHub repository](https://github.com/telerik/kendo-vue/tree/master/examples-standalone/coffee-warehouse).

## The Coffee Warehouse Dashboard App in Action

<iframe src="https://d3fu8oi3wk1rz4.cloudfront.net/kendo-vue/coffee-warehouse/" frameborder="0" width="100%" height="800"></iframe>

> To test the above example in a separate window you can follow [this link](https://d3fu8oi3wk1rz4.cloudfront.net/kendo-vue/coffee-warehouse/).

## How to Run the Demo Locally

To to see the demo implementation and how the different Native components are configured to interact with each other, you can run the `Coffee Warehouse Dashboard application` locally, by following the below steps:

1. Clone or download the [kendo-vue GitHub repository](https://github.com/telerik/kendo-vue/).
1. In the folder that contains the `kendo-vue` repository, navigate to the `examples-standalone/coffee-warehouse` folder.
1. Run `npm install` to install all dependencies needed by the component.
1. Use `npm run serve` command to start the application.
1. Open the link that appears in the console to open the project in a browser.

## Styling the Kendo UI for Vue Native components

The Kendo UI for Vue Native components come with customizable Kendo Themes that can style your application in different ways. The Kendo Themes are shipped as a part of the Kendo UI for Vue library. Details about the usage of the different themes, you can find in our [Styling]({% slug themesandstyles %}) documentation article. 

Use the Theme Change DropDownList in the upper right corner of the application's header to switch between the main Kendo UI Themes. 

## Application for a Global Audience 

The Globalization is the process that combines the translation of components' messages (localization) with their adaptation to specific cultures (internationalization). The current project shows how easy it is to apply globalization to the Kendo UI for Vue Native components. Next to the Theme Change DropDownList, you will find the Language DropDownList that can dynamically update the applications' messages and culture specifics. 

## Suggested Links

* [Kendo UI for Vue Native Data Grid]({% slug overview_grid %})
* [Kendo UI for Vue Native Charts]({% slug overview_charts %})
* [Kendo UI for Vue Native Scheduler]({% slug overview_scheduler %})
* [Kendo UI for Vue Native Globalization]({% slug overview_globalization %})
* [Kendo UI for Vue Native Internationalization]({% slug overview_intl %})
* [Kendo UI for Vue Native Localization]({% slug localization_intl %})
