---
title: Introduction
page_title: "Kendo UI for Vue Native Components Introduction - Kendo UI for Vue Native Docs & Demos"
description: "The Kendo UI for Vue Native suite facilitates the front-end development by providing you with ready-made UI components. The suite works with both Vue 2 and Vue 3"
slug: introduction
---

# Introduction to the Kendo UI for Vue Native suite

The Kendo UI for Vue Native is a commercial UI library designed and built for developing business applications with [Vue](https://vuejs.org/). Kendo UI for Vue Native suite builds every UI component from the ground up for Vue.


## Specifics and usage

All Kendo UI for Vue Native components are distributed through npm packages. Kendo UI for Vue Native is distributed under a commercial license. To use the npm packages provided by the suite, you must either sign up for a **30-day free trial**, or be **a licensed developer**. As a bonus, the **Trial license** grants free access to our outstanding Technical support service. You can start a free trial from our [Overview page](https://www.telerik.com/kendo-vue-ui). 

> Historically, all Kendo UI for Vue Native components support both **Vue 2** and **Vue 3**, however Vue 2 is currently in its end-of-support phase till Nov 2024. After our last major release for 2024, Vue 2 will no longer be supported in the new versions of the Kendo UI for Vue components. Please check our [Vue 2 End of Support article](slug:vue2-end-of-support) for more details.

The Native Kendo UI for Vue suite shares HTML rendering and web assets (like stylesheets) with the other Kendo UI suites, so you can reuse existing knowledge and classes.

<div data-component="StartFreeTrialSection">
Kendo UI for Vue is a professionally-built commercial UI library. Simply sign up for a 30-day trial to get access to all 100+ components, high-quality learning resources and our award-winning technical support.
</div>

## What is available in Kendo UI for Vue Native suite? 

The Kendo UI for Vue Native library contains UI components that range from  **Data Grid**, **Chart** & **Form** to variety of **Date Pickers**, **DropDowns**, **Buttons** and **Inputs**. The library provides options to process(**sort**, **filter**, **group**, and **aggregate**) different types of data. Once the desired data query is ready, **export** the data to **PDF** and **Excel** format.

The different components available in the Kendo UI for Vue Native suite are separated in the following groups:


* [Animation](slug:overview_animation)
* [Buttons](slug:overview_buttons)
* [Charts](slug:overview_charts)
* [DataTools](slug:overview_datatools)
* [Data Query](slug:overview_dataquery)
* [DateInputs](slug:overview_dateinputs)
* [Date Math](slug:overview_datemath)
* [Dialogs](slug:overview_dialogs)
* [Drawing](slug:overview_drawing)
* [DropDowns](slug:overview_dropdowns)
* [Editor](slug:overview_editor)
* [Excel Export](slug:overview_excelexport_vue)
* [File Saver](slug:overview_filesaver)
* [Form](slug:overview_form)
* [Gauges](slug:overview_gauges)
* [Grid/Data Management](slug:overview_grid)
* [Icons](slug:overview_icons)
* [Indicators](slug:overview_indicators)
* [Inputs](slug:overview_inputs)
* [Labels](slug:overview_labels)
* [Layout](slug:overview_layout)
* [ListBox](slug:overview_listbox)
* [ListView](slug:overview_listview)
* [Notification](slug:overview_notification)
* [PDF Processing](slug:overview_pdf_processing)
* [Popup](slug:overview_popup)
* [Progress Bars](slug:overview_progressbars)
* [Scheduler](slug:overview_scheduler)
* [ScrollView](slug:overview_scrollview)
* [Tooltip](slug:overview_tooltip)
* [TreeList](slug:overview_treelist)
* [TreeView](slug:overview_treeview)
* [Upload](slug:overview_upload)


> The list of all Native components is available in [our components page](https://www.telerik.com/kendo-vue-ui/components). 

All components in Kendo UI for Vue Native are accessible and come with compliance for **WCAG 2.1**, **Section 508**, and **WAI-ARIA** accessibility standards.

We are constantly working to provide new features and components to the Kendo UI for Vue Native suite. To be up-to-date with the new components available in the Native suite and know what are the next components we will release, we recommend to periodically check our [What's New](https://www.telerik.com/support/whats-new/kendo-vue-ui) and [Road map](https://www.telerik.com/support/whats-new/kendo-vue-ui/roadmap) pages.  

Tell us which components you want implemented for our Native Vue suite and how you intend to use them on [our feedback portal](https://feedback.telerik.com/kendo-vue-ui).


## Getting Started

If you are new to the Components part of the Kendo UI for Vue Native suite, we recommend you to go through the following Getting started articles, based on your [Vue API](https://vuejs.org/api/) and language preferences. 

* [Kendo UI for Vue - First Steps with JavaScript + Composition API]({% slug getting_started_javascript_composition_api %})
* [Kendo UI for Vue - First Steps with JavaScript + Options API]({% slug getting_started_javascript_options_api %})
* [Kendo UI for Vue - First Steps with TypeScript]({% slug getting_started_typescript_composition_api %})
* [Kendo UI for Vue - First Steps with TypeScript + Options API]({% slug getting_started_typescript_options_api %})

If you are getting started with Vue and Web development, you may find the following articles useful in getting up to speed with the core concepts:

* [What is Vue.js?](https://v3.vuejs.org/guide/introduction.html)

If you are searching for details how to use the Kendo UI for Vue Native components with [NUXT](https://nuxtjs.org/), you can check [this Nuxt 3 Getting Started Article](slug:getting_started_nuxt_3).


## Controlled and Uncontrolled Modes

Most of the Kendo UI for Vue Native components support both **controlled** and **uncontrolled** modes. This gives you the flexibility to either go with a simpler solution where you pass data and configuration options to the components and get up and running, or move in to a more advanced scenario where you maintain everything in state yourself. 

## Tree Shaking and Server-side Rendering

Kendo UI for Vue Native works with **tree shaking** so only the aspects of Kendo UI for Vue Native that are used and imported will count towards the size of your JavaScript bundle. Kendo UI for Vue Native can also work with **server-side rendering (SSR)**. **Lazy loading** techniques are also supported to meet the performance requirements of any Vue application.

* More details about the usage of the Kendo UI for Vue Native components with Nuxt 3 you can find on our [First Steps with NUXT 3](slug:getting_started_nuxt_3) documentation article.

## TypeScript Support

The Kendo UI for Vue Native components are **written with TypeScript** and come with all  the typings and IntelliSense out of the box. The typings are included inside the packages and can directly be used in any TypeScript application without any additional steps. 

* More details about the TypeScript support you can find on our [TypeScript Integration](slug:typescript_integration) page.

## Themes and Design Languages

With the breadth of components offered by Kendo UI for Vue Native, you can rely on the suite to provide a consistent look and feel across any UX and design requirements. The Kendo UI for Vue Native library currently supports two of the most popular Design Languages: Material Design and Bootstrap v5. Kendo UI for Vue Native also comes with its own default design system. All these themes allow you to either base your design on one of the existing Kendo UI for Vue Native themes or customize a Kendo UI for Vue Native theme and integrate it into your existing Design Language. The customization of the different themes can be effortlessly achieved with the [Kendo UI for Vue Theme Builder](https://themebuilder.telerik.com/kendo-vue-ui).

## UI Kits for Designers

The focus of our products is to help you deliver your applications faster and easier. To improve the collaboration between designers and developers, Kendo UI for Vue comes with [three different UI Kits for Figma](slug:ui_kits_figma): Material, Bootstrap, and Kendo UI Default. The UI Kits provide the designers with design assets that match the Kendo UI for Vue components. Matching building blocks on both sides - design and development - enable the seamless implementation of your application's design. The designers on your team can freely modify the UI Kits and use them as the foundation of your unique design system.

## Support and Bug Reports

With both a trial and/or developer license of Kendo UI for Vue Native, you will get access to the Kendo UI for Vue Native support ticketing system. Through this system you can submit issues, bug reports, or get help around implementing the components. All tickets are handled by our support team members and the developers of Kendo UI for Vue Native. Depending on the level of support that you get along with a licensed copy of Kendo UI for Vue Native you can even get access to remote web assistance for help with tricky and critical items.

## Trial Version and Commercial License

Kendo UI for Vue Native is a commercial UI library. You are welcome to explore its full functionality and get technical support from the team when you register for a free 30-day trial. To use it commercially, you need to [purchase a license](https://www.telerik.com/purchase/kendo-ui). For more information around licensing options, please refer to our pricing page. Feel free to review the Kendo UI for Vue Native [License Agreement](https://www.telerik.com/purchase/license-agreement/kendo-ui) to get acquainted with the full terms of use.