---
title: Video Onboarding
page_title: Kendo UI for Vue Video Onboarding - Kendo UI for Vue Docs & Demos
description: "Get started with Kendo UI for Vue by following a step-by-step video tutorial that helps you develop a real-life project."
slug: virtualclassroom
brand: getting-started
heading: Video Onboarding
---

# Video Onboarding

Everyone with an active trial or commercial license has access to a [Kendo UI for Vue getting started video course](https://learn.telerik.com/learn/course/internal/view/elearning/45/kendo-ui-for-vue-with-typescript) available in [Telerik's Virtual Classroom](https://learn.telerik.com/learn).
The training course is developed to help you get started with the Kendo UI for Vue components and features. It aims to put you in the shoes of an engineer who adds new features to an existing application.

The course starts with adding basic Kendo UI for Vue components to the application and shows how to harness the power of Kendo in no time. Further, you get into more advanced components, like the Chart and the Grid, and learn how to incorporate Kendo UI for Vue components to interact with existing functionality and with each other. Finally, the course explores how to build your own theme and change it for all components at once.

> Historically, all Kendo UI for Vue Native components support both **Vue 2** and **Vue 3**, however, Vue 2 is currently in its end-of-support phase till Nov 2024. After our last major release for 2024, Vue 2 will no longer be supported in the new versions of the Kendo UI for Vue components. Please check our [Vue 2 End of Support article](https://www.telerik.com/kendo-vue-ui/components/vue2-deprecation/) for more details.

## Course Overview

The next video shares a glimpse of the format and structure of the whole training and provides a brief overview of what will be accomplished through the steps. 
<iframe width="560" height="315" src="https://www.youtube.com/embed/yNuGsVg5u-s" title="Kendo UI for Vue - Overview of the Onboarding Course" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

## Project Overview

This video explains the details around the project you will be modifying&mdash;what it is, what needs to be added, and what the accomplished state will look like.
<iframe width="560" height="315" src="https://www.youtube.com/embed/Qn0QJkh_OZE" title="Kendo UI for Vue - Project Overview" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

## Onboarding Modules

The Kendo UI for Vue technical online training has an approximate duration of 3.5 hours and is split into seven modules with the following learning path:

* **Chapter 1: Welcome** (Course Overview, About Kendo UI for Vue, Prerequisites)
* **Chapter 2: Getting Started** (What We Are Building, Sample Code, Running the API and Sample App)
* **Chapter 3: Kendo and the Vue CLI** (Vue CLI Approach, Vue App Setup, Kendo Components and Setup, Licensing)
* **Chapter 4: Basic UI Components** (Buttons, DropDowns, Slider, Inputs, Tab Layout, ComboBox, Events and Custom Rendering)
* **Chapter 5: Chart** (Chart Anatomy, Setup, Categories, Series, Attributes)
* **Chapter 5: Grid** (Grid Setup, Column Definitions and Custom Renderers, Paging, Sorting, Row Click Event)
* **Chapter 5: Styling and Themes** (Changing the Theme, Theme Builder, Icons)


If you wish to learn more and continue with the video onboarding, [enroll in the training](https://learn.telerik.com/learn/course/internal/view/elearning/45/kendo-ui-for-vue-with-typescript) from the [Virtual Classroom](https://learn.telerik.com/learn).
  