# Kendo UI for Vue Sample Projects

This repository contains examples related to [Kendo UI for Vue](https://www.telerik.com/kendo-vue-ui) that are not part of the documentation or demos. They provide scenarios and answers to common how-to questions. For most of them, a component and some classes are the core of the example.

> Vue 2 is currently in its end-of-support phase till Nov 2024. After our last major release for 2024, Vue 2 will no longer be supported in the new versions of the Kendo UI for Vue components. Please check our [Vue 2 End of Support article](slug:vue2-end-of-support) for more details.

## Projects

- [Getting Started App](https://github.com/telerik/kendo-vue-examples/tree/main/getting-started-app)
- [Getting Started App with TypeScript](https://github.com/telerik/kendo-vue-examples/tree/main/getting-started-app-typescript)
- [Getting Started App with TypeScript and Composition API](https://github.com/telerik/kendo-vue-examples/tree/main/getting-started-typescript-composition-api)
- [Kendo UI for Vue in a Vite project](https://github.com/telerik/kendo-vue-examples/tree/main/kendo-vue-vite)
- [Kendo UI for Vue Grid with ASP .NET Core binding](https://github.com/telerik/kendo-vue-examples/tree/main/kendo-vue-demo-aspnetcore-data)
- [Kendo UI for Vue Grid Performance demo - Vue 2](https://github.com/telerik/kendo-vue-examples/tree/main/vue2-grid-performance)
- [Kendo UI for Vue Grid Nuxt 2 demo](https://github.com/telerik/kendo-vue-examples/tree/main/kendo-nuxt2)

## Knowledge bases
- [Vue Grid ISO Date Format](https://www.telerik.com/kendo-vue-ui/components/knowledge-base/grid-date-format/)

## Contribution

**Issues and Pull Requests are welcome.** 

To submit a pull request, you should **first [fork](https://docs.github.com/en/free-pro-team@latest/github/getting-started-with-github/fork-a-repo) the repo**.

## Package References

The projects usually reference a commercial version of Kendo UI for Vue. 

The references (to Kendo UI for Vue, and Vue) are usually up-to-date for the time of creation. You may need to update to their latest versions and make any necessary changes. The Vuejs framework is evolving rapidly and these examples may not get their references updated all the time. Nevertheless, the general approaches should remain valid, barring breaking changes in the framework.

## See Also

This repository does not contain the actual source code of the components, or the demos application.

You can find the demos and documentation at [https://demos.telerik.com/kendo-vue-ui/](https://demos.telerik.com/kendo-vue-ui/)

You can find the tracker for bugs and feature requests at [https://feedback.telerik.com/kendo-vue-ui](https://feedback.telerik.com/kendo-vue-ui) or in our [https://github.com/telerik/kendo-vue](https://github.com/telerik/kendo-vue).

