<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace ModStart\Form; use Closure; use Illuminate\Contracts\Support\Renderable; use Illuminate\Database\Eloquent\Model; use Illuminate\Support\Collection; use Illuminate\Support\Facades\Input; use Illuminate\Support\Str; use Illuminate\Validation\Validator; use ModStart\Core\Dao\DynamicModel; use ModStart\Core\Exception\BizException; use ModStart\Core\Exception\ResultException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Type\SortDirection; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\SerializeUtil; use ModStart\Detail\Detail; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Display; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Concern\HasCascadeFields; use ModStart\Form\Type\FormEngine; use ModStart\Form\Type\FormMode; use ModStart\Grid\Concerns\HasSort; use ModStart\Repository\Filter\HasRepositoryFilter; use ModStart\Repository\Filter\HasScopeFilter; use ModStart\Repository\Repository; use ModStart\Repository\RepositoryUtil; use ModStart\Support\Concern\HasBuilder; use ModStart\Support\Concern\HasFields; use ModStart\Support\Concern\HasFluentAttribute; use ModStart\Support\Manager\FieldManager; use stdClass; class Form implements Renderable { use HasFields, HasBuilder, HasFluentAttribute, HasSort, HasCascadeFields, HasScopeFilter, HasRepositoryFilter; public $id; private $repository; private $view = 'modstart::core.form.index'; protected $fluentAttributes = array('engine', 'builder', 'mode', 'title', 'showSubmit', 'showReset', 'itemId', 'item', 'hookSubmitted', 'hookSaving', 'hookSaved', 'hookDeleting', 'hookDeleted', 'hookChanged', 'dataSubmitted', 'dataForming', 'dataAdding', 'dataEditing', 'canAdd', 'canEdit', 'canDelete', 'canSort', 'canCopy', 'sortAddPosition', 'formClass', 'treeMaxLevel', 'treeRootPid', 'formUrl', 'ajax', 'formAttr'); private $engine = 'basic'; private $mode = 'form'; private $title; private $showSubmit = true; private $showReset = true; private $itemId = null; private $item; private $hookSubmitted; private $hookSaving; private $hookSaved; private $hookDeleting; private $hookDeleted; private $hookChanged; private $dataSubmitted; private $dataForming; private $dataAdding; private $dataEditing; private $canAdd = true; private $canEdit = true; private $canDelete = true; private $canSort = false; private $canCopy = false; private $sortAddPosition = false; private $formClass = ''; private $treeMaxLevel = 99; private $treeRootPid = 0; private $formUrl = null; private $ajax = true; private $formAttr = ''; public function __construct($w7Oqz, \Closure $J2v0t = null) { goto kBLT2; I4mpW: $this->fieldDefaultRenderMode(FieldRenderMode::FORM); goto Ak7td; kBLT2: $this->id = IdUtil::generate('Grid'); goto yBsZY; zbkId: $this->setupFields(); goto I4mpW; ko3o0: $this->builder($J2v0t); goto z6lNL; Ak7td: $this->setupRepositoryFilter(); goto ko3o0; yBsZY: $this->repository = Repository::instance($w7Oqz); goto zbkId; z6lNL: } public static function make($vn_cr = null, \Closure $J2v0t = null) { if (is_object($vn_cr) || class_exists($vn_cr) && is_subclass_of($vn_cr, Model::class)) { return new Form($vn_cr, $J2v0t); } return new Form(DynamicModel::make($vn_cr), $J2v0t); } public function asTree($eAE99 = 'id', $aoubX = 'pid', $JK1jY = 'sort', $MpH1l = 'title') { goto xFFVO; G2O1K: $this->canSort(true); goto O4gC_; j4Rnu: $this->repository->setSortColumn($JK1jY); goto p5W_t; O4gC_: return $this; goto QZIq6; V31XX: $this->engine = FormEngine::TREE; goto G2O1K; p5W_t: $this->repository->setTreeTitleColumn($MpH1l); goto V31XX; P7KzP: $this->repository->setTreePidColumn($aoubX); goto j4Rnu; xFFVO: $this->repository->setKeyName($eAE99); goto P7KzP; QZIq6: } public function asTreeMass($mTunF = 0, $eAE99 = 'id', $aoubX = 'pid', $JK1jY = 'sort', $MpH1l = 'title') { goto L7rSq; V2tW5: $this->engine = FormEngine::TREE_MASS; goto J4Ssf; J4Ssf: $this->canSort(true); goto gxsBV; TCDne: $this->repository->setTreePidColumn($aoubX); goto xQEdJ; gxsBV: return $this; goto p2XX3; L7rSq: $this->repository->setKeyName($eAE99); goto TCDne; xQEdJ: $this->repository->setSortColumn($JK1jY); goto cXE47; cXE47: $this->repository->setTreeTitleColumn($MpH1l); goto V2tW5; p2XX3: } private function build() { $this->runBuilder(); if ($this->engine == FormEngine::TREE) { if ($this->treeMaxLevel > 1) { $rZfgs = FieldManager::make($this, 'select', $this->repository->getTreePidColumn(), L('Parent')); $rZfgs->optionRepositoryTreeItems($this->repository, $this->treeMaxLevel); } else { $rZfgs = FieldManager::make($this, 'hidden', $this->repository->getTreePidColumn(), L('Parent')); $rZfgs->value(0); } $this->prependField($rZfgs); } else { if ($this->engine == FormEngine::TREE_MASS) { goto Uhy9I; rrDz0: $rZfgs->addable(true)->editable(true)->listable(false); goto VFPqB; VFPqB: $rZfgs->hookRendering(function (AbstractField $rZfgs, $Esk0p, $EqYVi) { if (empty($Esk0p)) { $PzW0H = InputPackage::buildFromInput()->get('_pid', $this->treeRootPid); } else { $PzW0H = $Esk0p->{$this->repository->getTreePidColumn()}; } $this->repository()->setArgument('treePid', $PzW0H); $OtozK = $this->repository->getTreeAncestorItems(); $pbwAU = array(); $pbwAU[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . L('Root'); foreach ($OtozK as $UmGt8) { $pbwAU[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . htmlspecialchars($UmGt8->{$this->repository->getTreeTitleColumn()}); } $pbwAU[] = '<input type="hidden" name="' . $this->repository->getTreePidColumn() . '" value="' . htmlspecialchars($PzW0H) . '" />'; return AutoRenderedFieldValue::make(join('', $pbwAU)); }); goto OBqqE; OBqqE: $this->prependField($rZfgs); goto ECVdK; Uhy9I: $rZfgs = FieldManager::make($this, 'display', $this->repository->getTreePidColumn(), L('Parent')); goto rrDz0; ECVdK: } } } public function repository() { return $this->repository; } private function fieldValidateMessages($Bhd90, $vrSVj) { goto wS1I2; kuyys: if (empty($xsLSP)) { return false; } goto ysyz_; mPnhr: foreach ($Bhd90 as $rZfgs) { if (!($w4_Mg = $rZfgs->getValidator($vrSVj))) { continue; } if ($w4_Mg instanceof Validator) { try { if (!$w4_Mg->passes()) { $Bw9_0[] = $w4_Mg; } } catch (\Exception $Xlb8r) { BizException::throws('Form.fieldValidateMessages.Error - ' . SerializeUtil::jsonEncode($w4_Mg->getRules())); } } } goto XmWio; XmWio: $xsLSP = array(); goto osfeI; osfeI: foreach ($Bw9_0 as $w4_Mg) { foreach ($w4_Mg->messages()->getMessages() as $t_tdX => $eWrpT) { $xsLSP[$t_tdX] = $eWrpT; } } goto kuyys; ysyz_: return $xsLSP; goto ekZeo; wS1I2: $Bw9_0 = array(); goto mPnhr; ekZeo: } private function convertBizExceptionToResponse($ZvA6A) { goto lHRFP; lHRFP: $x5t3J = $ZvA6A->getMessage(); goto BosbQ; BosbQ: $vKZUM = array(array('FieldTooLong:', 'Field %s Too Long'), array('FieldFormatError:', 'Field %s Format Error')); goto RhOrF; RhOrF: foreach ($vKZUM as $Xo2Ly) { if (Str::startsWith($x5t3J, $Xo2Ly[0])) { goto pUPfc; jAFaH: $rZfgs = $this->getFieldByColumn($u_jpy); goto X0j0F; pUPfc: list($UMqQ0, $u_jpy) = explode(':', $x5t3J); goto jAFaH; X0j0F: if ($rZfgs) { return Response::jsonError(L($Xo2Ly[1], $rZfgs->label())); } goto HQxWq; HQxWq: } } goto uU6sF; uU6sF: return Response::jsonError($x5t3J); goto Zp5Mn; Zp5Mn: } private function validateFields($Bhd90, $zvN10) { goto cEQEh; Dup1n: return Response::generateSuccess(); goto P3DZE; cEQEh: $d38vE = array(); goto fkhkd; LOLG9: foreach ($d38vE as $t_tdX => $xsLSP) { foreach ($xsLSP as $jspW5) { return Response::generateError($jspW5); } } goto Dup1n; fkhkd: if ($mQmpx = $this->fieldValidateMessages($Bhd90, $zvN10)) { $d38vE = array_merge($d38vE, $mQmpx); } goto LOLG9; P3DZE: } private function removeReservedFields() { goto uW4d9; uW4d9: $AKM1Y = array($this->repository->getKeyName(), $this->repository->getCreatedAtColumn(), $this->repository->getUpdatedAtColumn()); goto RsoUl; YSj7X: $this->fields = $this->fields()->reject($A7T4a); goto yf6v3; RsoUl: $A7T4a = function (AbstractField $rZfgs) use(&$AKM1Y) { return in_array($rZfgs->column(), $AKM1Y, true) && $rZfgs instanceof \ModStart\Field\Display; }; goto YSj7X; yf6v3: } public function hookCall($b9NqF) { if ($b9NqF instanceof Closure) { $ZIe4d = call_user_func($b9NqF, $this); if (null !== $ZIe4d) { return $ZIe4d; } } return Response::generateSuccess(); } public function isModeForm() { return $this->mode === FormMode::FORM; } public function isModeAdd() { return $this->mode === FormMode::ADD; } public function isModeEdit() { return $this->mode === FormMode::EDIT; } public function isModeDelete() { return $this->mode === FormMode::DELETE; } public function formRequest($b9NqF, array $zvN10 = null) { goto uHGP1; CU5zo: try { goto I1F9M; m_TqV: ResultException::throwsIfFail($this->hookCall($this->hookSaving)); goto eQJS0; gWJLP: $this->removeReservedFields(); goto RzoCF; HUJ8c: if (null !== $ZIe4d) { if (Response::isError($ZIe4d)) { return Response::jsonFromGenerate($ZIe4d); } } goto AdJHm; b1RQ0: return Response::jsonSuccess(L('Save Success')); goto uI3bR; RzoCF: foreach ($this->addableFields() as $rZfgs) { goto YyiTg; y5lH5: $Mczr_ = isset($this->dataSubmitted[$rZfgs->column()]) ? $this->dataSubmitted[$rZfgs->column()] : null; goto PDC1N; PDC1N: $Mczr_ = $rZfgs->prepareInput($Mczr_, $this->dataSubmitted); goto beZn5; HrYzN: $this->dataForming[$rZfgs->column()] = $Mczr_; goto LEoVD; YyiTg: if ($rZfgs->isLayoutField()) { continue; } goto y5lH5; f3CYs: if ($rZfgs->hookValueSerialize()) { $Mczr_ = call_user_func($rZfgs->hookValueSerialize(), $Mczr_, $rZfgs); } goto HrYzN; beZn5: $Mczr_ = $rZfgs->serializeValue($Mczr_, $rZfgs); goto f3CYs; LEoVD: } goto m_TqV; FXTVg: if (null !== $ZIe4d) { return Response::jsonFromGenerate($ZIe4d); } goto TrDeP; I1F9M: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto fGq34; EAmlu: $this->dataForming = array(); goto gWJLP; AdJHm: ResultException::throwsIfFail($this->hookCall($this->hookSaved)); goto T4t_t; TrDeP: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto b1RQ0; fGq34: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto EAmlu; eQJS0: $ZIe4d = call_user_func($b9NqF, $this); goto HUJ8c; T4t_t: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto FXTVg; uI3bR: } catch (BizException $Xlb8r) { return Response::jsonError($Xlb8r->getMessage()); } catch (ResultException $Xlb8r) { return Response::jsonError($Xlb8r->getMessage()); } goto iE9A3; uHGP1: $this->mode(FormMode::FORM); goto iMnMQ; iMnMQ: $this->build(); goto r783D; r783D: $this->dataSubmitted = $zvN10 ? $zvN10 : Input::all(); goto CU5zo; iE9A3: } public function add() { goto F584r; qnL2S: $naOIS = false; goto VZ7vZ; xESsF: if ($naOIS) { $this->fillFields(); } goto EQ8nt; VZ7vZ: if ($this->canCopy()) { $oC7LD = CRUDUtil::copyId(); if ($oC7LD) { goto JncOz; F6T4a: $this->itemId(0); goto xJug0; nnDQL: $this->item($this->repository()->editing($this)); goto F6T4a; xJug0: $naOIS = true; goto Cv3Z9; JncOz: $this->itemId($oC7LD); goto nnDQL; Cv3Z9: } } goto hpuBF; F584r: $this->mode(FormMode::ADD); goto qnL2S; hpuBF: $this->build(); goto xESsF; EQ8nt: return $this; goto qPGyR; qPGyR: } public function addRequest(array $zvN10 = null) { goto mWbAS; rPO0P: $this->dataSubmitted = $zvN10 ? $zvN10 : Input::all(); goto jD5P2; jD5P2: try { goto C0GO1; J_Ni4: foreach ($this->addableFields() as $rZfgs) { goto ghT7C; ghT7C: if ($rZfgs->isLayoutField() || $rZfgs->isCustomField()) { continue; } goto ROCt_; HIB55: $this->dataAdding[$rZfgs->column()] = $Mczr_; goto uJ0Xw; a8BqM: if ($rZfgs->hookValueSerialize()) { $Mczr_ = call_user_func($rZfgs->hookValueSerialize(), $Mczr_, $rZfgs); } goto HIB55; oQbn9: $Mczr_ = $rZfgs->prepareInput($Mczr_, $this->dataSubmitted); goto c7tsQ; ROCt_: $Mczr_ = isset($this->dataSubmitted[$rZfgs->column()]) ? $this->dataSubmitted[$rZfgs->column()] : null; goto oQbn9; c7tsQ: $Mczr_ = $rZfgs->serializeValue($Mczr_, $rZfgs); goto a8BqM; uJ0Xw: } goto wZflM; vVHkv: return Response::jsonSuccess(L('Add Success')); goto uxhf_; ed_Sz: $this->dataAdding = array(); goto a9IuN; C0GO1: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto Ljrls; a9IuN: $this->removeReservedFields(); goto J_Ni4; VSjwL: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto vVHkv; Ljrls: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto ed_Sz; wZflM: $yU7nJ = $this->repository->add($this); goto fT7If; fT7If: foreach ($this->addableFields() as $rZfgs) { if ($rZfgs->hookValueSaved()) { call_user_func($rZfgs->hookValueSaved(), $yU7nJ, $rZfgs); } } goto VSjwL; uxhf_: } catch (BizException $Xlb8r) { return $this->convertBizExceptionToResponse($Xlb8r); } catch (ResultException $Xlb8r) { return Response::jsonError($Xlb8r->getMessage()); } goto TvAUs; tuCcj: $this->build(); goto rPO0P; mWbAS: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto lYlhm; lYlhm: $this->mode(FormMode::ADD); goto tuCcj; TvAUs: } public function edit($yU7nJ) { try { goto cmvm3; cmvm3: $this->mode(FormMode::EDIT); goto U59iL; U59iL: $this->itemId($yU7nJ); goto c0EDj; tCr5S: return $this; goto V87Rd; c0EDj: $this->item($this->repository()->editing($this)); goto nNa33; HIqKK: $this->build(); goto Z_O6t; nNa33: BizException::throwsIfEmpty(L('Record Not Exists'), $this->item); goto HIqKK; Z_O6t: $this->fillFields(); goto tCr5S; V87Rd: } catch (BizException $Xlb8r) { return Response::sendError($Xlb8r->getMessage()); } } public function editRequest($yU7nJ, array $zvN10 = null) { goto ABo8b; nwW5A: $this->dataSubmitted = $zvN10 ? $zvN10 : Input::all(); goto sDzLj; ABo8b: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto nwW5A; sDzLj: try { goto Qhqez; HsSzc: $CoQTC = isset($this->dataSubmitted['_action']) ? $this->dataSubmitted['_action'] : null; goto tLPHo; orV2O: $this->repository()->edit($this); goto OJZY0; TfmZl: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto N01w_; XVsjc: $this->removeReservedFields(); goto HsSzc; OJZY0: if ('itemCellEdit' == $CoQTC) { foreach ($this->editableFields() as $rZfgs) { if ($rZfgs->column() == $t_tdX && $rZfgs->hookValueSaved()) { call_user_func($rZfgs->hookValueSaved(), $this->itemId(), $rZfgs); } } } else { foreach ($this->editableFields() as $rZfgs) { if ($rZfgs->hookValueSaved()) { call_user_func($rZfgs->hookValueSaved(), $this->itemId(), $rZfgs); } } } goto TfmZl; Qhqez: $this->edit($yU7nJ); goto nZkpT; WTA5I: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto E7n7b; tLPHo: if ('itemCellEdit' == $CoQTC) { goto Wuxuc; Wuxuc: $t_tdX = isset($this->dataSubmitted['column']) ? $this->dataSubmitted['column'] : null; goto aoqE0; gUBCY: BizException::throwsIfEmpty('Data Error', $this->dataEditing); goto VX1H2; M8x4D: if ($t_tdX) { foreach ($this->editableFields() as $rZfgs) { if ($rZfgs->isLayoutField() || $rZfgs->isCustomField()) { continue; } if ($rZfgs->column() == $t_tdX) { goto N0U6c; KvED8: break; goto kpEYt; KKCCP: $Mczr_ = $rZfgs->serializeValue($Mczr_, $rZfgs); goto vnQIt; N0U6c: $Mczr_ = $rZfgs->prepareInput($Mczr_, $this->dataSubmitted); goto KKCCP; vnQIt: if ($rZfgs->hookValueSerialize()) { $Mczr_ = call_user_func($rZfgs->hookValueSerialize(), $Mczr_, $rZfgs); } goto cFwGg; cFwGg: $this->dataEditing[$rZfgs->column()] = $Mczr_; goto KvED8; kpEYt: } } } goto gUBCY; aoqE0: $Mczr_ = isset($this->dataSubmitted['value']) ? $this->dataSubmitted['value'] : null; goto M8x4D; VX1H2: } else { foreach ($this->editableFields() as $rZfgs) { goto BysR0; G7V8I: $this->dataEditing[$rZfgs->column()] = $Mczr_; goto s0lnK; WhHnx: $Mczr_ = $rZfgs->prepareInput($Mczr_, $this->dataSubmitted); goto EA12_; EA12_: $Mczr_ = $rZfgs->serializeValue($Mczr_, $rZfgs); goto nGtnE; AHVvV: $Mczr_ = isset($this->dataSubmitted[$rZfgs->column()]) ? $this->dataSubmitted[$rZfgs->column()] : null; goto WhHnx; nGtnE: if ($rZfgs->hookValueSerialize()) { $Mczr_ = call_user_func($rZfgs->hookValueSerialize(), $Mczr_, $rZfgs); } goto G7V8I; BysR0: if ($rZfgs->isLayoutField() || $rZfgs->isCustomField()) { continue; } goto AHVvV; s0lnK: } } goto orV2O; nZkpT: ResultException::throwsIfFail($this->validateFields($this->editableFields(), $this->dataSubmitted)); goto WTA5I; N01w_: return Response::jsonSuccess(L('Edit Success')); goto TJgz3; E7n7b: $this->dataEditing = array(); goto XVsjc; TJgz3: } catch (BizException $Xlb8r) { return $this->convertBizExceptionToResponse($Xlb8r); } catch (ResultException $Xlb8r) { return Response::jsonError($Xlb8r->getMessage()); } goto nHU4H; nHU4H: } public function deleteRequest($w4eFc) { goto o33bm; ac08J: $this->mode(FormMode::DELETE); goto dHIky; Tl3hC: try { goto L2Kr9; ceINt: $WqCf1 = $this->repository->delete($this, $zvN10); goto UtQuR; UtQuR: return Response::jsonSuccess(L('Delete Success')); goto r4DjX; L2Kr9: $zvN10 = $this->repository->deleting($this); goto mhLvn; mhLvn: $this->item($zvN10); goto diYXg; diYXg: $this->itemId(collect($zvN10)->map(function ($zcQlf) { return $zcQlf->{$this->repository()->getKeyName()}; })->toArray()); goto ceINt; r4DjX: } catch (BizException $Xlb8r) { return Response::jsonError($Xlb8r->getMessage()); } catch (ResultException $Xlb8r) { return Response::jsonError($Xlb8r->getMessage()); } goto GE9kW; v9Vyb: $this->build(); goto Tl3hC; dHIky: $this->itemId($w4eFc); goto v9Vyb; o33bm: if (!$this->canDelete) { return Response::pagePermissionDenied(); } goto ac08J; GE9kW: } public function sortRequest($w4eFc) { goto TRY5I; RtaJZ: try { goto bacv7; bvH7d: return Response::jsonSuccess(L('Operate Success')); goto HZ9NB; bacv7: $WqCf1 = $this->repository->sortEdit($this); goto SHozX; SHozX: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto bvH7d; HZ9NB: } catch (BizException $Xlb8r) { return Response::jsonError($Xlb8r->getMessage()); } catch (ResultException $Xlb8r) { return Response::jsonError($Xlb8r->getMessage()); } goto yeoS6; w280q: $this->mode(FormMode::SORT); goto yD7g9; xUOw5: $this->build(); goto RtaJZ; pNq5Z: $vrSVj = InputPackage::buildFromInput(); goto sFwak; yD7g9: $this->itemId($w4eFc); goto pNq5Z; sFwak: $this->repository->setArgument('direction', $vrSVj->getType('direction', SortDirection::class)); goto xUOw5; TRY5I: if (!$this->canSort) { return Response::pagePermissionDenied(); } goto w280q; yeoS6: } public function render() { goto LJNi5; aUpjD: $zvN10 = array_merge($this->fluentAttributeVariables(), $zvN10); goto vpINI; LJNi5: $zvN10 = array(); goto TW5ZZ; vpINI: return view($this->view, $zvN10)->render(); goto lkfUw; TW5ZZ: switch ($this->mode) { case FormMode::FORM: $zvN10['fields'] = $this->addableFields(true); break; case FormMode::ADD: goto AEsxT; l6YOC: $zvN10['fields'] = $this->addableFields(true); goto aUAup; AEsxT: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto l6YOC; aUAup: break; goto jXh3i; jXh3i: case FormMode::EDIT: goto sNH2p; pHBQP: $zvN10['fields'] = $this->editableFields(true); goto Kx8RW; Kx8RW: break; goto bp2gC; sNH2p: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto pHBQP; bp2gC: default: return Response::sendError('Form.render mode error : ' . $this->mode); } goto aUpjD; lkfUw: } public function __call($pK00s, $rxS2C) { goto ZQZuf; jBJvv: if ($this->isFluentAttribute($pK00s)) { switch ($pK00s) { case 'item': if (isset($rxS2C[0]) && is_array($rxS2C[0])) { $rxS2C[0] = RepositoryUtil::itemFromArray($rxS2C[0]); } break; } return $this->fluentAttribute($pK00s, $rxS2C); } goto lgWG3; lgWG3: return FieldManager::call($this, $pK00s, $rxS2C); goto s92Mb; ZQZuf: switch ($pK00s) { case 'enablePagination': case 'defaultOrder': case 'canShow': case 'canExport': case 'canImport': case 'canBatchDelete': case 'canMultiSelectItem': case 'addBlankPage': case 'editBlankPage': case 'disableCUD': case 'hookItemOperateRendering': case 'addDialogSize': case 'editDialogSize': case 'dialogSizeSmall': case 'gridFilter': case 'gridOperateAppend': case 'bodyAppend': case 'operateFixed': case 'defaultPageSize': case 'pageSizes': case 'canBatchSelect': case 'batchOperatePrepend': case 'gridToolbar': case 'pageJumpEnable': case 'textEdit': case 'gridTableTopView': case 'gridBeforeRequestScriptView': case 'gridRequestScript': return $this; } goto jBJvv; s92Mb: } public function __toString() { try { return $this->render(); } catch (\Exception $Xlb8r) { return $Xlb8r->getMessage(); } } }