<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Illuminate\Database\Schema\Grammars; use Illuminate\Support\Fluent; use Illuminate\Database\Connection; use Illuminate\Database\Schema\Blueprint; class MySqlGrammar extends Grammar { protected $modifiers = array('Unsigned', 'Charset', 'Collate', 'Nullable', 'Default', 'Increment', 'Comment', 'After', 'First'); protected $serials = array('bigInteger', 'integer', 'mediumInteger', 'smallInteger', 'tinyInteger'); public function compileTableExists() { return 'select * from information_schema.tables where table_schema = ? and table_name = ?'; } public function compileColumnExists() { return 'select column_name as `column_name` from information_schema.columns where table_schema = ? and table_name = ?'; } public function compileCreate(Blueprint $H6jze, Fluent $gYjpq, Connection $jw60N) { goto skkV9; wzEv5: $ZjqJz .= ' table ' . $this->wrapTable($H6jze) . " ({$bBHtO})"; goto p5GvL; eC183: if (isset($H6jze->engine)) { $ZjqJz .= ' engine = ' . $H6jze->engine; } goto rm_4r; skkV9: $bBHtO = implode(', ', $this->getColumns($H6jze)); goto rm_rf; rm_4r: return $ZjqJz; goto iMa9R; rm_rf: $ZjqJz = $H6jze->temporary ? 'create temporary' : 'create'; goto wzEv5; p5GvL: $ZjqJz = $this->compileCreateEncoding($ZjqJz, $jw60N, $H6jze); goto eC183; iMa9R: } protected function compileCreateEncoding($ZjqJz, Connection $jw60N, Blueprint $H6jze) { goto yKUMS; yKUMS: if (isset($H6jze->charset)) { $ZjqJz .= ' default character set ' . $H6jze->charset; } elseif (!is_null($Ti8ga = $jw60N->getConfig('charset'))) { $ZjqJz .= ' default character set ' . $Ti8ga; } goto gquTt; ZJNu1: return $ZjqJz; goto vR7mR; gquTt: if (isset($H6jze->collation)) { $ZjqJz .= ' collate ' . $H6jze->collation; } elseif (!is_null($huJrr = $jw60N->getConfig('collation'))) { $ZjqJz .= ' collate ' . $huJrr; } goto ZJNu1; vR7mR: } public function compileAdd(Blueprint $H6jze, Fluent $gYjpq) { goto wvszk; YGm4J: return 'alter table ' . $AD05J . ' ' . implode(', ', $bBHtO); goto Datq0; wvszk: $AD05J = $this->wrapTable($H6jze); goto khKVK; khKVK: $bBHtO = $this->prefixArray('add', $this->getColumns($H6jze)); goto YGm4J; Datq0: } public function compilePrimary(Blueprint $H6jze, Fluent $gYjpq) { $gYjpq->name(null); return $this->compileKey($H6jze, $gYjpq, 'primary key'); } public function compileUnique(Blueprint $H6jze, Fluent $gYjpq) { return $this->compileKey($H6jze, $gYjpq, 'unique'); } public function compileIndex(Blueprint $H6jze, Fluent $gYjpq) { return $this->compileKey($H6jze, $gYjpq, 'index'); } protected function compileKey(Blueprint $H6jze, Fluent $gYjpq, $pW0Nz) { goto JfLiy; gHE13: $AD05J = $this->wrapTable($H6jze); goto QxZEH; QxZEH: return "alter table {$AD05J} add {$pW0Nz} `{$gYjpq->index}`({$bBHtO})"; goto XBtxI; JfLiy: $bBHtO = $this->columnize($gYjpq->columns); goto gHE13; XBtxI: } public function compileDrop(Blueprint $H6jze, Fluent $gYjpq) { return 'drop table ' . $this->wrapTable($H6jze); } public function compileDropIfExists(Blueprint $H6jze, Fluent $gYjpq) { return 'drop table if exists ' . $this->wrapTable($H6jze); } public function compileDropColumn(Blueprint $H6jze, Fluent $gYjpq) { goto KAS1z; I2zH3: return 'alter table ' . $AD05J . ' ' . implode(', ', $bBHtO); goto SB35F; KAS1z: $bBHtO = $this->prefixArray('drop', $this->wrapArray($gYjpq->columns)); goto gMKAt; gMKAt: $AD05J = $this->wrapTable($H6jze); goto I2zH3; SB35F: } public function compileDropPrimary(Blueprint $H6jze, Fluent $gYjpq) { return 'alter table ' . $this->wrapTable($H6jze) . ' drop primary key'; } public function compileDropUnique(Blueprint $H6jze, Fluent $gYjpq) { $AD05J = $this->wrapTable($H6jze); return "alter table {$AD05J} drop index `{$gYjpq->index}`"; } public function compileDropIndex(Blueprint $H6jze, Fluent $gYjpq) { $AD05J = $this->wrapTable($H6jze); return "alter table {$AD05J} drop index `{$gYjpq->index}`"; } public function compileDropForeign(Blueprint $H6jze, Fluent $gYjpq) { $AD05J = $this->wrapTable($H6jze); return "alter table {$AD05J} drop foreign key `{$gYjpq->index}`"; } public function compileRename(Blueprint $H6jze, Fluent $gYjpq) { $lmF4G = $this->wrapTable($H6jze); return "rename table {$lmF4G} to " . $this->wrapTable($gYjpq->to); } protected function typeChar(Fluent $t_tdX) { return "char({$t_tdX->length})"; } protected function typeString(Fluent $t_tdX) { return "varchar({$t_tdX->length})"; } protected function typeText(Fluent $t_tdX) { return 'text'; } protected function typeMediumText(Fluent $t_tdX) { return 'mediumtext'; } protected function typeLongText(Fluent $t_tdX) { return 'longtext'; } protected function typeBigInteger(Fluent $t_tdX) { return 'bigint'; } protected function typeInteger(Fluent $t_tdX) { return 'int'; } protected function typeMediumInteger(Fluent $t_tdX) { return 'mediumint'; } protected function typeTinyInteger(Fluent $t_tdX) { return 'tinyint'; } protected function typeSmallInteger(Fluent $t_tdX) { return 'smallint'; } protected function typeFloat(Fluent $t_tdX) { return $this->typeDouble($t_tdX); } protected function typeDouble(Fluent $t_tdX) { if ($t_tdX->total && $t_tdX->places) { return "double({$t_tdX->total}, {$t_tdX->places})"; } return 'double'; } protected function typeDecimal(Fluent $t_tdX) { return "decimal({$t_tdX->total}, {$t_tdX->places})"; } protected function typeBoolean(Fluent $t_tdX) { return 'tinyint(1)'; } protected function typeEnum(Fluent $t_tdX) { return 'enum(\'' . implode('\', \'', $t_tdX->allowed) . '\')'; } protected function typeJson(Fluent $t_tdX) { return 'text'; } protected function typeJsonb(Fluent $t_tdX) { return 'text'; } protected function typeDate(Fluent $t_tdX) { return 'date'; } protected function typeDateTime(Fluent $t_tdX) { return 'datetime'; } protected function typeDateTimeTz(Fluent $t_tdX) { return 'datetime'; } protected function typeTime(Fluent $t_tdX) { return 'time'; } protected function typeTimeTz(Fluent $t_tdX) { return 'time'; } protected function typeTimestamp(Fluent $t_tdX) { goto p1DZf; OeUjF: if (!$t_tdX->nullable && $t_tdX->default === null) { return 'timestamp default 0'; } goto Ky5Y5; Ky5Y5: return 'timestamp'; goto dwnST; p1DZf: if ($t_tdX->useCurrent) { return 'timestamp default CURRENT_TIMESTAMP'; } goto OeUjF; dwnST: } protected function typeTimestampTz(Fluent $t_tdX) { goto F7bWX; o0Ym3: return 'timestamp'; goto Hg2k_; F7bWX: if ($t_tdX->useCurrent) { return 'timestamp default CURRENT_TIMESTAMP'; } goto hzlWE; hzlWE: if (!$t_tdX->nullable && $t_tdX->default === null) { return 'timestamp default 0'; } goto o0Ym3; Hg2k_: } protected function typeBinary(Fluent $t_tdX) { return 'blob'; } protected function typeUuid(Fluent $t_tdX) { return 'char(36)'; } protected function modifyUnsigned(Blueprint $H6jze, Fluent $t_tdX) { if ($t_tdX->unsigned) { return ' unsigned'; } } protected function modifyCharset(Blueprint $H6jze, Fluent $t_tdX) { if (!is_null($t_tdX->charset)) { return ' character set ' . $t_tdX->charset; } } protected function modifyCollate(Blueprint $H6jze, Fluent $t_tdX) { if (!is_null($t_tdX->collation)) { return ' collate ' . $t_tdX->collation; } } protected function modifyNullable(Blueprint $H6jze, Fluent $t_tdX) { return $t_tdX->nullable ? ' null' : ' not null'; } protected function modifyDefault(Blueprint $H6jze, Fluent $t_tdX) { if (!is_null($t_tdX->default)) { return ' default ' . $this->getDefaultValue($t_tdX->default); } } protected function modifyIncrement(Blueprint $H6jze, Fluent $t_tdX) { if (in_array($t_tdX->type, $this->serials) && $t_tdX->autoIncrement) { return ' auto_increment primary key'; } } protected function modifyFirst(Blueprint $H6jze, Fluent $t_tdX) { if (!is_null($t_tdX->first)) { return ' first'; } } protected function modifyAfter(Blueprint $H6jze, Fluent $t_tdX) { if (!is_null($t_tdX->after)) { return ' after ' . $this->wrap($t_tdX->after); } } protected function modifyComment(Blueprint $H6jze, Fluent $t_tdX) { if (!is_null($t_tdX->comment)) { return ' comment "' . $t_tdX->comment . '"'; } } protected function wrapValue($Mczr_) { if ($Mczr_ === '*') { return $Mczr_; } return '`' . str_replace('`', '``', $Mczr_) . '`'; } }