@extends($_viewFrame)

@section('pageTitle'){{modstart_config('siteName').' | '.modstart_config('siteSlogan')}}@endsection

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a class="active" href="{{modstart_web_url('photo')}}">
                <i class="iconfont icon-category"></i> 相册
            </a>
        </div>
        @if(empty($categories))
            <div class="ub-empty">
                <div class="icon">
                    <div class="iconfont icon-empty-box"></div>
                </div>
                <div class="text">暂无记录</div>
            </div>
        @endif
        <div class="row ub-list-items">
            @foreach($categories as $category)
                <div class="col-md-3 col-6">
                    <div class="tw-rounded margin-bottom">
                        <a class="ub-cover-1-1 tw-rounded tw-bg-white" href="{{modstart_web_url('photo_category/'.$category['id'])}}" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($category['cover'])}})"></a>
                        <div class="tw-flex tw-p-1">
                            <div class="tw-flex-grow tw-w-full">
                                <div class="tw-w-full tw-pr-8 tw-text-lg">
                                    @if($category['visitType']==\Module\Photo\Type\PhotoCategoryVisitType::VISIT_PASSWORD)
                                        <i class="iconfont icon-lock"></i>
                                    @endif
                                    {{$category['name']}}
                                </div>
                            </div>
                            @if($category['type']==\Module\Photo\Type\PhotoCategoryType::ALBUM)
                                <div class="tw-block tw-w-8 tw-h-8 tw-text-right ub-text-muted tw--ml-8">
                                    {{ empty($category['photoCount']) ? '0' : $category['photoCount'] }}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

    </div>

@endsection





