@extends($_viewFrame)

@section('pageTitleMain'){{$category['name']}}@endsection
@section('pageKeywords'){{$category['name']}}@endsection
@section('pageDescription'){{$category['name']}}@endsection

{!! \ModStart\ModStart::js('asset/common/photoswipe.js') !!}
{!! \ModStart\ModStart::js('asset/common/lazyLoad.js') !!}
{!! \ModStart\ModStart::style('.ub-list-items .layui-flow-more{width:100%;}') !!}
@section('bodyAppend')
    @parent
    <script>
        layui.use('flow', function() {
            var flow = layui.flow;
            var imageItemHtml = $('#imageItem').html();
            flow.load({
                elem: '#list',
                done: function (page, next) {
                    window.api.base.post("{{modstart_api_url('photo/paginate')}}",{categoryId:{{$category['id']}},page:page},function(res){
                        var html = [];
                        for(var i=0;i<res.data.records.length;i++){
                            var $item = $(imageItemHtml);
                            $item.find('[data-photoswipe-item]')
                                .attr('data-src',res.data.records[i].url)
                                .attr('data-width',res.data.records[i].width)
                                .attr('data-height',res.data.records[i].height);
                            $item.find('[data-thumb]').attr('data-thumb',res.data.records[i].thumb);
                            html.push($item.get(0).outerHTML);
                        }
                        next(html.join(''),res.data.pageSize===res.data.records.length);
                        $('[data-thumb]').lazyload({data_attribute:'thumb'});
                    });
                }
            });
            window.api.photoswipe('#list');
        });
    </script>
@endsection

@section('bodyContent')

    <script id="imageItem" type="text/html">
        <div class="col-md-3 col-6">
            <div class="tw-bg-gray-200 tw-rounded tw-p-1 tw-mb-3 tw-cursor-pointer"
                 data-photoswipe-item
                 data-src
                 data-width
                 data-height
            >
                <div class="ub-cover-1-1 contain" data-thumb></div>
            </div>
        </div>
    </script>

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('photo')}}">
                <i class="iconfont icon-category"></i> 相册
            </a>
            <a class="active" href="javascript:;">
                <i class="iconfont icon-images"></i>
                {{$category['name']}}
            </a>
        </div>

        <div class="row ub-list-items" id="list"></div>

    </div>

@endsection





