@extends('modstart::admin.frame')

@section('pageTitle')上传图片@endsection

@section('headAppend')
    @parent
@endsection

{!! \ModStart\ModStart::js('asset/common/uploadButton.js') !!}
@section('bodyAppend')
    @parent
    <script>
        $(function () {
            var html = $('#photoItem').html();
            var $uploadList = $('#uploadList');
            window.api.uploadButton('[data-file-uploader]', {
                text: '<div style="line-height:2rem;height:2rem;padding:0 1rem;font-size:12px;background:#3283fa;color:#FFF;"><span class="uk-icon-plus" style="display:inline;line-height:2rem;height:2rem;"></span> 上传图片</div>',
                server: window.__selectorDialogServer + '/image',
                extensions: {!! json_encode(join(',',config('data.upload.image.extensions'))) !!},
                sizeLimit: {!! json_encode(config('data.upload.image.maxSize')) !!},
                chunkSize: {!! json_encode(\ModStart\Core\Util\EnvUtil::env('uploadMaxSize')) !!},
                callback: function (file, me) {
                    // window.api.dialog.loadingOn('正在上传...');
                    var data = {
                        categoryId: $('[name=categoryId]').val(),
                        title: file.name,
                        width: 0,
                        height: 0,
                        size: file.size,
                        file: file.path
                    };
                    var fr = new FileReader;
                    fr.onload = function () {
                        var img = new Image();
                        img.onload = function () {
                            data.width = img.width;
                            data.height = img.height;
                            // console.log('image', data);
                            window.api.base.post("{{modstart_admin_url('photo/photo/upload')}}",data,function(res){
                                window.api.base.defaultFormCallback(res,{
                                    success:function(res){
                                        // console.log('xxx',res);
                                        var $html = $(html);
                                        $html.find('[data-thumb]').css({backgroundImage:'url('+res.data.thumb+')'});
                                        $html.find('[data-title]').text(res.data.title);
                                        $uploadList.prepend($html);
                                    }
                                })
                            });
                        };
                        img.src = fr.result;
                    };
                    fr.readAsDataURL(file.file.source.source);
                },
                start:function(){
                    window.api.dialog.loadingOn('正在上传');
                },
                finish: function () {
                    window.api.dialog.loadingOff();
                    window.api.dialog.tipSuccess('上传完成');
                }
            });
        })
    </script>
@endsection

@section($_tabSectionName)

    <script type="text/html" id="photoItem">
        <div class="col-md-2 col-3">
            <div class="item-video-cover tw-border-gray-200 tw-rounded tw-border tw-border-solid">
                <div data-thumb class="ub-cover-1-1 contain tw-bg-gray-100"></div>
                <div data-title class="title"></div>
            </div>
        </div>
    </script>

    <div class="row">
        <div class="col-md-4">
            <div class="ub-panel">
                <div class="head">
                    <div class="title">上传图片</div>
                </div>
                <div class="body">
                    <form action="?" class="ub-form" method="post" data-ajax-form onsubmit="return false;">
                        <div class="line">
                            <div class="label">选择分类：</div>
                            <div class="field">
                                <select name="categoryId" style="width:100%;">
                                    @foreach(\Module\Photo\Util\PhotoCategoryUtil::listCategories() as $option)
                                        @if($option['type']!=\Module\Photo\Type\PhotoCategoryType::VIDEO)
                                            <option value="{{$option['id']}}">{{$option['name']}}</option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="line">
                            <div class="label">选择图片：</div>
                            <div class="field">
                                <div data-file-uploader></div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="ub-panel">
                <div class="head">
                    <div class="title">已上传图片</div>
                </div>
                <div class="body ub-list-items">
                    <div class="row" id="uploadList"></div>
                </div>
            </div>
        </div>
    </div>

@endsection
