<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace ModStart\Admin\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Str; use ModStart\Admin\Auth\Admin; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminCRUD; use ModStart\Admin\Model\AdminUser; use ModStart\Admin\Provider\AdminUserConfigProvider; use ModStart\Core\Exception\BizException; use ModStart\Core\Util\ConvertUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\RenderUtil; use ModStart\Detail\Detail; use ModStart\Field\AbstractField; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\Grid; use ModStart\Grid\GridFilter; class AdminUserController extends Controller { use HasAdminCRUD; protected function grid() { goto A5CcJ; lmdUy: return $xtA75; goto aC9Bp; kJU5o: $xtA75->title(L('Admin User')); goto lmdUy; A5CcJ: $xtA75 = new Grid(AdminUser::class, function (Grid $xtA75) { $xtA75->display('id', L('ID'))->sortable(true)->width(80); $xtA75->text('username', L('Username')); if (modstart_config('AdminManagerEnhance_EnablePhone', false)) { $xtA75->text('phone', L('Phone')); } if (modstart_config('AdminManagerEnhance_EnableEmail', false)) { $xtA75->text('email', L('Email')); } $xtA75->tags('roles', L('Roles'))->hookFormatValue(function ($wvO30, AbstractField $Lgjfa) { $ZpLX1 = $Lgjfa->item(); if (AdminPermission::isFounder($ZpLX1->id)) { return array(L('Admin Founder')); } return collect($wvO30)->pluck('name')->toArray(); }); if (!AdminUserConfigProvider::isEmpty()) { $xtA75->display('config', '配置')->hookRendering(function (AbstractField $Lgjfa, $ZpLX1, $ouMWs) { return RenderUtil::view('modstart::admin.user.configGrid', array('item' => $ZpLX1)); }); } $xtA75->text('lastLoginTime', L('Last Login Time')); $xtA75->text('lastLoginIp', L('Last Login Ip')); $xtA75->gridFilter(function (GridFilter $udDBo) { $udDBo->eq('id', L('ID')); $udDBo->like('username', L('Username')); }); $xtA75->hookItemOperateRendering(function (ItemOperate $bFM7b) { if (AdminPermission::isFounder($bFM7b->item()->id)) { $bFM7b->canDelete(false); } }); }); goto XLuAw; XLuAw: if (AdminPermission::isNotPermit('AdminUserManage')) { $xtA75->canAdd(false)->canEdit(false)->canDelete(false); } goto kJU5o; aC9Bp: } protected function form() { goto xmjZs; LDuuw: return $LEyIF; goto AapNJ; yrzsl: if (AdminPermission::isNotPermit('AdminUserManage')) { $LEyIF->canAdd(false)->canEdit(false)->canDelete(false); } goto DOpu3; xmjZs: $LEyIF = new Form(AdminUser::class, function (Form $LEyIF) { $LEyIF->text('username', L('Username'))->required()->rules('unique:admin_user,username,' . CRUDUtil::id()); $LEyIF->text('password', L('Password'))->rules($LEyIF->isModeAdd() ? 'required' : '')->placeholder($LEyIF->isModeAdd() ? '' : L('Keep Old Password If Empty'))->value($LEyIF->isModeAdd() ? RandomUtil::string(6) : '')->hookFormatValue(function ($wvO30, AbstractField $Lgjfa) { return ''; }); if (modstart_config('AdminManagerEnhance_EnablePhone', false)) { $LEyIF->text('phone', L('Phone'))->ruleUnique('admin_user'); } if (modstart_config('AdminManagerEnhance_EnableEmail', false)) { $LEyIF->text('email', L('Email'))->ruleUnique('admin_user'); } $ZpLX1 = $LEyIF->item(); $YdkzK = $LEyIF->checkbox('roles', L('Roles'))->optionModel('admin_role')->hookValueUnserialize(function ($wvO30, AbstractField $Lgjfa) { return $wvO30->map(function ($m86pK) { return $m86pK['id']; }); })->hookValueSerialize(function ($wvO30, AbstractField $Lgjfa) { return ConvertUtil::toArray($wvO30); }); if ($LEyIF->isModeEdit() && AdminPermission::isFounder($ZpLX1->id)) { $YdkzK->editable(false); } if (!AdminUserConfigProvider::isEmpty()) { $LEyIF->display('config', '配置')->hookRendering(function (AbstractField $Lgjfa, $ZpLX1, $ouMWs) { return RenderUtil::view('modstart::admin.user.configForm', array('item' => $ZpLX1)); })->formShowOnly(true); } $LEyIF->display('created_at', L('Created At'))->editable(true); $LEyIF->hookSaving(function (Form $LEyIF) { if ($LEyIF->isModeAdd()) { goto QwZ79; Ygjld: $LEyIF->dataAdding($SjN8A); goto IVl4l; Jcgyi: $SjN8A['passwordSalt'] = Str::random(16); goto a_d3g; QwZ79: $SjN8A = $LEyIF->dataAdding(); goto Jcgyi; a_d3g: $SjN8A['password'] = Admin::passwordEncrypt($SjN8A['password'], $SjN8A['passwordSalt']); goto Ygjld; IVl4l: } else { if ($LEyIF->isModeEdit()) { goto CDtnF; if4ha: $LEyIF->dataEditing($SjN8A); goto T8yeY; CDtnF: $SjN8A = $LEyIF->dataEditing(); goto f9uer; f9uer: if ($SjN8A['password']) { $SjN8A['passwordSalt'] = Str::random(16); $SjN8A['password'] = Admin::passwordEncrypt($SjN8A['password'], $SjN8A['passwordSalt']); } else { unset($SjN8A['password']); } goto if4ha; T8yeY: } } }); $LEyIF->hookDeleting(function (Form $LEyIF) { $LEyIF->item()->each(function ($ZpLX1) { if (AdminPermission::isFounder($ZpLX1->id)) { BizException::throws(L('Admin Founder Delete Forbidden')); } }); }); $LEyIF->hookSaved(function (Form $LEyIF) { $ZpLX1 = $LEyIF->item(); foreach (AdminUserConfigProvider::listAll() as $RMN4M) { $RMN4M->saved($ZpLX1); } }); $LEyIF->hookDeleted(function (Form $LEyIF) { $LEyIF->item()->each(function ($ZpLX1) { foreach (AdminUserConfigProvider::listAll() as $RMN4M) { $RMN4M->deleted($ZpLX1); } }); }); }); goto yrzsl; DOpu3: $LEyIF->title(L('Admin User')); goto LDuuw; AapNJ: } protected function detail() { goto st_6S; XFD4v: return $jV5dI; goto VPBOs; YNp6G: $jV5dI->title(L('Admin User')); goto XFD4v; st_6S: $jV5dI = new Detail(AdminUser::class, function (Detail $jV5dI) { $jV5dI->display('id', L('ID')); $jV5dI->text('username', L('Username')); if (modstart_config('AdminManagerEnhance_EnablePhone', false)) { $jV5dI->text('phone', L('Phone')); } if (modstart_config('AdminManagerEnhance_EnableEmail', false)) { $jV5dI->text('email', L('Email')); } $jV5dI->tags('roles', L('Roles'))->hookFormatValue(function ($wvO30, AbstractField $Lgjfa) { $ZpLX1 = $Lgjfa->item(); if (AdminPermission::isFounder($ZpLX1->id)) { return array(L('Admin Founder')); } return collect($wvO30)->pluck('name')->toArray(); }); if (!AdminUserConfigProvider::isEmpty()) { $jV5dI->display('config', '配置')->hookRendering(function (AbstractField $Lgjfa, $ZpLX1, $ouMWs) { return RenderUtil::view('modstart::admin.user.configDetail', array('item' => $ZpLX1)); }); } $jV5dI->display('created_at', L('Created At')); $jV5dI->display('updated_at', L('Updated At')); }); goto YNp6G; VPBOs: } }