@extends($_viewFrame)

@section('pageTitleMain')结算中心@endsection
@section('pageKeywords')结算中心@endsection
@section('pageDescription')结算中心@endsection

{!! \ModStart\ModStart::js('vendor/PayCenter/entry/pay.js') !!}

@section('headAppend')
    @parent
    <style type="text/css">
        .btn-block{
            line-height: 1.5rem !important;
            height: auto !important;
        }
    </style>
@endsection

@section('bodyAppend')
    <script>
        window.__pay = {
            device: '{{\ModStart\Core\Util\AgentUtil::device()}}',
            payUrl: '{{$payUrl}}',
            onPaySuccess: function (type, param) {
                $('[data-pay-page]').hide();
                $('[data-success-page]').show();
                return true;
            }
        };
        $(function(){
            $('.btn-block').click();
        });
    </script>
@endsection

@section('body')
    <div class="ub-header-mobile shadow">
        <div class="header-container">
            <div class="body has-back">
                <div class="title" style="text-align:center;">
                    结算中心
                </div>
            </div>
        </div>
        <div class="header-container-placeholder"></div>
    </div>
    <div data-success-page style="display:none;">
        <div class="ub-container tw-bg-white ub-h-full">
            <div class="tw-p-6 tw-text-lg tw-text-center">
                <div class="tw-py-8">
                    <i class="iconfont icon-check ub-text-success"
                       style="font-size:4rem;line-height:4rem;"></i>
                </div>
                <div class="ub-text-default">
                    支付成功，请关闭当前页面
                </div>
            </div>
        </div>
    </div>
    <div data-pay-page>
        <div class="ub-container tw-bg-white ub-h-full">
            <div class="tw-p-3">
                <div class="tw-px-4 tw-py-14">
                    <div class="tw-text-lg tw-text-center margin-bottom">
                        {{$order['body']}}
                    </div>
                    <div class="tw-text-4xl tw-text-center margin-bottom-lg">
                        <span class="tw-text-lg">￥</span>{{$order['feeTotal']}}
                    </div>
                    <div class="ub-text-tertiary tw-text-center margin-bottom">
                        结算ID：{{$order['id']}}
                    </div>
                </div>
            </div>
        </div>
        <div class="tw-fixed tw-bottom-0 tw-left-0 tw-right-0 tw-bg-white tw-border-0 tw-border-t tw-border-solid tw-border-gray-200">
            <div class="tw-p-6">
                <div class="margin-bottom ub-list-pay">
                    @if(\ModStart\Core\Util\AgentUtil::isWechat())
                        <a class="btn btn-primary btn-round btn-lg btn-block"
                           data-type="{{\Module\PayCenter\Type\PayType::WECHAT_MOBILE}}"
                           href="javascript:;">
                            立即支付
                        </a>
                    @else
                        @if(\Module\PayCenter\Util\PayUtil::isAlipayEnable())
                            <a class="btn btn-primary btn-round btn-lg btn-block"
                               data-type="{{\Module\PayCenter\Type\PayType::ALIPAY}}"
                               href="javascript:;">
                                立即支付
                            </a>
                        @elseif(\Module\PayCenter\Util\PayUtil::isAlipayWebEnable())
                            <a class="btn btn-primary btn-round btn-lg btn-block"
                               data-type="{{\Module\PayCenter\Type\PayType::ALIPAY_MOBILE}}"
                               href="javascript:;">
                                立即支付
                            </a>
                        @endif
                    @endif
                </div>
                <div class="tw-text-center tw-text-sm ub-text-muted">
                    <i class="iconfont icon-shield-check"></i>
                    我们实时保障您的账户安全
                </div>
            </div>
        </div>
    </div>

@endsection
