<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\PayCenter\Util; use Carbon\Carbon; use EasyWeChat\Factory; use EasyWeChat\Kernel\Exceptions\InvalidArgumentException; use EasyWeChat\Kernel\Exceptions\InvalidConfigException; use GuzzleHttp\Exception\GuzzleException; use Illuminate\Support\Facades\Log; use Illuminate\Support\Facades\Session; use Illuminate\Support\Str; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Response; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use Module\Member\Util\MemberMoneyUtil; use Module\PayCenter\Events\OrderPayedEvent; use Module\PayCenter\Provider\PayCenterProvider; use Module\PayCenter\Type\PayOrderStatus; use Module\PayCenter\Type\PayType; use Module\Vendor\Log\Logger; use Payment\Client\Charge; use Payment\Config; class PayOrderUtil { private static function getOrGeneratePaySessionKey() { goto aE0cI; fEhV1: return $Jo7ME; goto pOXYG; uEbrS: if (empty($Jo7ME)) { $Jo7ME = RandomUtil::string(32); Session::put('paySessionKey', $Jo7ME); } goto fEhV1; aE0cI: $Jo7ME = Session::get('paySessionKey', null); goto uEbrS; pOXYG: } public static function updateFee($Dnlri, $dY0xr, $FF4cr) { goto pnOxK; pnOxK: $MZHZc = self::getByBizAndBizId($Dnlri, $dY0xr); goto jJiZX; p6yeP: if ($MZHZc['status'] == PayOrderStatus::NEW_ORDER || $MZHZc['status'] == PayOrderStatus::CREATED) { self::update($MZHZc['id'], array('feeTotal' => $FF4cr)); } goto AD0dI; jJiZX: BizException::throwsIfEmpty('订单不存在', $MZHZc); goto p6yeP; AD0dI: } public static function autoPay($Dnlri, $dY0xr, $FF4cr = null) { goto q3sXA; gOx1P: self::update($wpCAw['id'], array('status' => PayOrderStatus::CREATED, 'payType' => PayType::NONE, 'timePayCreated' => Carbon::now(), 'payOrderId' => null)); goto PjLdP; PjLdP: return PayOrderUtil::handleOrderPay(PayType::NONE, config('pay.payOrderOutTradeNoPrefix') . '_' . $wpCAw['id']); goto L2pFW; q3sXA: $wpCAw = PayOrderUtil::prepareOrder($Dnlri, $dY0xr, $FF4cr); goto gOx1P; L2pFW: } public static function prepareOrder($Dnlri, $dY0xr, $FF4cr = null, $ZI5AS = null, $uBQi3 = null, $KJ3xr = array()) { goto B0hyg; TnInk: return $MZHZc; goto jP0yZ; KIpBJ: if (empty($UuYsu)) { goto HYIU1; vn39Z: $MZHZc['payType'] = null; goto n1YCB; S6cJn: $MZHZc['redirect'] = $uBQi3; goto GjS9j; ZT7dg: $MZHZc['timePayCreated'] = null; goto R6M7t; Y6Q2x: $MZHZc['feeTotal'] = $FF4cr; goto ZT7dg; n1YCB: $MZHZc['status'] = PayOrderStatus::NEW_ORDER; goto csEe8; csEe8: $MZHZc['payOrderId'] = null; goto Y6Q2x; zkmsL: $MZHZc['param'] = json_encode($KJ3xr, JSON_UNESCAPED_UNICODE); goto pPyfB; HYIU1: $pNLgg = IdUtil::generateSN(); goto woq1n; KYF9g: $MZHZc['timeRefundCreated'] = null; goto AMBFF; pPyfB: $MZHZc['body'] = $ZI5AS; goto S6cJn; R6M7t: $MZHZc['timePay'] = null; goto iAqJR; UHzHg: $MZHZc['timeClosed'] = null; goto zkmsL; AMBFF: $MZHZc['timeRefundSuccess'] = null; goto UHzHg; woq1n: $MZHZc['id'] = $pNLgg; goto cBfuz; GjS9j: $MZHZc = ModelUtil::insert('pay_order', $MZHZc); goto eHsLp; dFdW7: $MZHZc['param'] = $KJ3xr; goto XFHG6; iAqJR: $MZHZc['feeRefund'] = null; goto KYF9g; cBfuz: $MZHZc['biz'] = $Dnlri; goto XAH3N; XAH3N: $MZHZc['bizId'] = $dY0xr; goto vn39Z; eHsLp: $MZHZc['id'] = $pNLgg; goto dFdW7; XFHG6: } else { goto WCs1Y; iBd02: if (null !== $ZI5AS) { $xo6i2['body'] = $ZI5AS; } goto bDEN6; GHrWF: if (null !== $FF4cr) { $xo6i2['feeTotal'] = $FF4cr; } goto iBd02; bDEN6: if (null !== $uBQi3) { $xo6i2['redirect'] = $uBQi3; } goto lAjQo; RhAPw: if (!empty($xo6i2)) { ModelUtil::update('pay_order', $UuYsu['id'], $xo6i2); foreach ($xo6i2 as $JdFJR => $PSYn9) { $MZHZc[$JdFJR] = $PSYn9; } } goto NZLbb; r_3Cf: $xo6i2 = array(); goto GHrWF; lAjQo: switch ($MZHZc['status']) { case PayOrderStatus::NEW_ORDER: break; case PayOrderStatus::CREATED: goto jjQ8_; lo0x1: $xo6i2['timeClosed'] = null; goto SDwlS; SDwlS: break; goto M7l6M; jjQ8_: $xo6i2['status'] = PayOrderStatus::NEW_ORDER; goto lo0x1; M7l6M: case PayOrderStatus::CLOSED: goto SWmPS; HZ5VY: break; goto J2AX4; bfSww: $xo6i2['timeClosed'] = null; goto HZ5VY; SWmPS: $xo6i2['status'] = PayOrderStatus::NEW_ORDER; goto bfSww; J2AX4: case PayOrderStatus::CLOSED_EXPIRED: goto TlNzH; TlNzH: $xo6i2['status'] = PayOrderStatus::NEW_ORDER; goto Tha0W; AwPKs: break; goto DqbMu; Tha0W: $xo6i2['timeClosed'] = null; goto AwPKs; DqbMu: default: BizException::throws('订单状态异常'); } goto vBPo3; vBPo3: if (!empty($KJ3xr)) { $xo6i2['param'] = json_encode($KJ3xr, JSON_UNESCAPED_UNICODE); } goto RhAPw; WCs1Y: $MZHZc = $UuYsu; goto r_3Cf; NZLbb: } goto TnInk; B0hyg: $UuYsu = ModelUtil::get('pay_order', array('biz' => $Dnlri, 'bizId' => $dY0xr)); goto RvaV1; RvaV1: $MZHZc = array(); goto KIpBJ; jP0yZ: } public static function getOrderSecretId($vinkQ) { return EncodeUtil::expiredDataForever($vinkQ, self::getOrGeneratePaySessionKey()); } public static function getOrder($MZHZc) { goto IQSWS; JU3Hc: if (!$pNLgg) { return null; } goto SDskK; Z6708: ModelUtil::decodeRecordJson($dE7kJ, array('param')); goto sdA30; sdA30: $dE7kJ['id'] = '' . $dE7kJ['id']; goto ekKd5; SDskK: $dE7kJ = ModelUtil::get('pay_order', $pNLgg); goto Z6708; ekKd5: return $dE7kJ; goto MkGZx; IQSWS: $pNLgg = EncodeUtil::expiredDataDecode($MZHZc, self::getOrGeneratePaySessionKey()); goto JU3Hc; MkGZx: } public static function createPay($vinkQ, $xN3qr, $It5Ki = array()) { goto ybNpF; eqz_q: if ($wpCAw['status'] == PayOrderStatus::PAYED) { return Response::generateError('订单已支付'); } else { if ($wpCAw['status'] == PayOrderStatus::CLOSED) { return Response::generateError('订单已关闭，请刷新该页面'); } } goto v90aI; ybNpF: $wpCAw = self::get($vinkQ); goto xV4xu; v90aI: switch ($xN3qr) { case PayType::ALIPAY: return self::createAlipay($wpCAw, $xN3qr, $It5Ki); case PayType::ALIPAY_WEB: return self::createAlipayWeb($wpCAw, $xN3qr, $It5Ki); case PayType::ALIPAY_MOBILE: return self::createAlipayMobile($wpCAw, $xN3qr, $It5Ki); case PayType::WECHAT: return self::createWechat($wpCAw, $xN3qr, $It5Ki); case PayType::WECHAT_MOBILE: return self::createWechatMobile($wpCAw, $xN3qr, $It5Ki); case PayType::WECHAT_APP: return self::createWechatApp($wpCAw, $xN3qr, $It5Ki); case PayType::WECHAT_MINI_PROGRAM: return self::createWechatMiniProgram($wpCAw, $xN3qr, $It5Ki); case PayType::WECHAT_H5: return self::createWechatH5($wpCAw, $xN3qr, $It5Ki); case PayType::MEMBER_MONEY: return self::createMemberMoney($wpCAw, $xN3qr, $It5Ki); default: goto r7C15; DFj8E: return Response::generate(-1, '支付方式不存在'); goto fz1Tm; r7C15: $sefXk = PayCenterProvider::get($xN3qr); goto z2JA7; z2JA7: if ($sefXk) { return $sefXk->onSubmit($wpCAw, $xN3qr, $It5Ki); } goto DFj8E; fz1Tm: } goto zCgmR; xV4xu: BizException::throwsIfEmpty('订单不存在', $wpCAw); goto eqz_q; zCgmR: } public static function update($pNLgg, $smBDO) { return ModelUtil::update('pay_order', array('id' => $pNLgg), $smBDO); } public static function total() { $LGs0v = ModelUtil::model('pay_order')->where('status', PayOrderStatus::PAYED)->sum('feeTotal'); return sprintf('%.2f', $LGs0v); } public static function totalByTimeRange($CihET, $cyH9Y) { $LGs0v = ModelUtil::model('pay_order')->where('status', PayOrderStatus::PAYED)->where('created_at', '>=', $CihET)->where('created_at', '<=', $cyH9Y)->sum('feeTotal'); return sprintf('%.2f', $LGs0v); } public static function get($pNLgg) { goto aLhF2; aLhF2: $zvlJr = ModelUtil::get('pay_order', $pNLgg); goto utn5Z; utn5Z: ModelUtil::decodeRecordJson($zvlJr, 'param'); goto Dday6; Dday6: return $zvlJr; goto YWmyV; YWmyV: } public static function getByBizAndBizId($Dnlri, $dY0xr) { goto ZRnc7; Rn_o4: ModelUtil::decodeRecordJson($zvlJr, 'param'); goto sogHw; sogHw: return $zvlJr; goto CYKBB; ZRnc7: $zvlJr = ModelUtil::get('pay_order', array('biz' => $Dnlri, 'bizId' => $dY0xr)); goto Rn_o4; CYKBB: } public static function refund($Dnlri, $dY0xr, $dhwmt = null, $KJ3xr = array()) { goto Qzacz; Qzacz: $xo6i2 = array('status' => PayOrderStatus::REFUND_SUCCESS, 'feeRefund' => $dhwmt, 'timeRefundCreated' => date('Y-m-d H:i:s'), 'timeRefundSuccess' => date('Y-m-d H:i:s')); goto CrngQ; WhIUt: return Response::generate(0, 'ok'); goto Dw9m7; CrngQ: try { goto mA4VR; OtkFV: ModelUtil::transactionCommit(); goto pdMSX; IE7W0: $MZHZc = ModelUtil::getWithLock('pay_order', array('biz' => $Dnlri, 'bizId' => $dY0xr)); goto REOgg; NmG6R: ModelUtil::update('pay_order', $MZHZc['id'], $xo6i2); goto OtkFV; mA4VR: ModelUtil::transactionBegin(); goto IE7W0; TYoY7: if (null === $xo6i2['feeRefund']) { $xo6i2['feeRefund'] = $MZHZc['feeTotal']; } goto NmG6R; tB26w: BizException::throwsIf('订单状态异常', $MZHZc['status'] != PayOrderStatus::PAYED); goto TYoY7; REOgg: BizException::throwsIfEmpty('订单不存在', $MZHZc); goto tB26w; pdMSX: } catch (BizException $hSVcc) { ModelUtil::transactionRollback(); return Response::generateError($hSVcc->getMessage()); } goto WhIUt; Dw9m7: } public static function getWechatPayment() { goto iq5IO; l_tS7: $XhVgh = array('app_id' => $XhVgh->getWithEnv('payWechatAppId'), 'mch_id' => $XhVgh->getWithEnv('payWechatMerchantId'), 'key' => $XhVgh->getWithEnv('payWechatKey'), 'cert_path' => '', 'key_path' => '', 'log' => array('default' => 'debug', 'channels' => array('debug' => array('driver' => 'single', 'path' => Logger::rotateLog('PayCenter_Wechat'), 'level' => 'debug')))); goto n29QA; n29QA: return Factory::payment($XhVgh); goto wFz4Y; iq5IO: $XhVgh = modstart_config(); goto l_tS7; wFz4Y: } private static function createWechat($wpCAw, $xN3qr, $It5Ki) { goto OUHze; x0O_v: if (!isset($Gs3Xd['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto Lvo58; mz0yq: return Response::generate(0, null, $smBDO); goto gfETs; Lvo58: if ($Gs3Xd['result_code'] != 'SUCCESS') { $i168_ = $Gs3Xd['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $i168_ . ')'); } goto LwGd8; iEBJO: if (isset($It5Ki['limitPay'])) { switch ($It5Ki['limitPay']) { case 'no_credit': $BT0HV['limit_pay'] = $It5Ki['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto oMIKF; OUHze: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, '微信支付未开启'); } goto Vn4Ga; xE01e: if (!isset($Gs3Xd['return_code']) || $Gs3Xd['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($Gs3Xd['return_msg']) ? $Gs3Xd['return_msg'] : 'NULL')); } goto x0O_v; Vn4Ga: $E9nMK = self::getWechatPayment(); goto l_hn7; LwGd8: self::update($wpCAw['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $xN3qr, 'timePayCreated' => Carbon::now(), 'payOrderId' => $Gs3Xd['prepay_id'])); goto mAwV_; l_hn7: $BT0HV = array('trade_type' => 'NATIVE', 'body' => StrUtil::mbLimitChars($wpCAw['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $wpCAw['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($wpCAw['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT))); goto iEBJO; mAwV_: $smBDO = array('payCodeUrl' => $Gs3Xd['code_url'], 'successRedirect' => $wpCAw['redirect']); goto mz0yq; oMIKF: try { $Gs3Xd = $E9nMK->order->unify($BT0HV); } catch (\Exception $hSVcc) { goto YG5nu; YG5nu: $HMHj9 = $hSVcc->getMessage(); goto bVRS5; lUPGq: throw $hSVcc; goto TUhFb; bVRS5: if (Str::contains($HMHj9, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto lUPGq; TUhFb: } goto xE01e; gfETs: } private static function createWechatApp($wpCAw, $xN3qr, $It5Ki) { goto jsWcW; NZaq4: if ($Gs3Xd['result_code'] != 'SUCCESS') { $i168_ = $Gs3Xd['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $i168_ . ')'); } goto xMwBG; xMwBG: self::update($wpCAw['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $xN3qr, 'timePayCreated' => Carbon::now(), 'payOrderId' => $Gs3Xd['prepay_id'])); goto mWk1O; iriPw: try { $Gs3Xd = $E9nMK->order->unify($BT0HV); } catch (\Exception $hSVcc) { goto khXlp; Ecdgw: throw $hSVcc; goto UUIej; s7Jph: if (Str::contains($HMHj9, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto Ecdgw; khXlp: $HMHj9 = $hSVcc->getMessage(); goto s7Jph; UUIej: } goto gS1GS; jsWcW: $E9nMK = self::getWechatPayment(); goto D0gPn; XPAsU: if (!isset($Gs3Xd['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto NZaq4; fRwp0: return Response::generate(0, null, $smBDO); goto yUaZz; ahIXp: $smBDO = array('payJsSdkConfig' => $ksdZm, 'successRedirect' => $wpCAw['redirect']); goto fRwp0; mWk1O: $ksdZm = $E9nMK->jssdk->bridgeConfig($Gs3Xd['prepay_id'], false); goto ahIXp; gS1GS: if (!isset($Gs3Xd['return_code']) || $Gs3Xd['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($Gs3Xd['return_msg']) ? $Gs3Xd['return_msg'] : 'NULL')); } goto XPAsU; D0gPn: $BT0HV = array('trade_type' => 'APP', 'body' => StrUtil::mbLimitChars($wpCAw['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $wpCAw['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($wpCAw['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_MOBILE))); goto lO3IH; lO3IH: if (isset($It5Ki['limitPay'])) { switch ($It5Ki['limitPay']) { case 'no_credit': $BT0HV['limit_pay'] = $It5Ki['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto iriPw; yUaZz: } private static function createWechatMobile($wpCAw, $xN3qr, $It5Ki) { goto sT06M; Uc0pE: if (!isset($Gs3Xd['return_code']) || $Gs3Xd['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($Gs3Xd['return_msg']) ? $Gs3Xd['return_msg'] : 'NULL')); } goto kdBau; kdBau: if (!isset($Gs3Xd['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto qp4ho; vPYiM: if (empty($It5Ki['openId'])) { return Response::generate(-1, 'wechat mobile openId empty'); } goto cmr3_; hFnyO: try { $Gs3Xd = $E9nMK->order->unify($BT0HV); } catch (\Exception $hSVcc) { goto AO8uG; AO8uG: $HMHj9 = $hSVcc->getMessage(); goto R724V; R724V: if (Str::contains($HMHj9, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto ThPSb; ThPSb: throw $hSVcc; goto V96eu; V96eu: } goto Uc0pE; qp4ho: if ($Gs3Xd['result_code'] != 'SUCCESS') { $i168_ = $Gs3Xd['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $i168_ . ')'); } goto FnTar; FnTar: self::update($wpCAw['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $xN3qr, 'timePayCreated' => Carbon::now(), 'payOrderId' => $Gs3Xd['prepay_id'])); goto y_5Z0; MfCvi: $BT0HV = array('openid' => $It5Ki['openId'], 'trade_type' => 'JSAPI', 'body' => StrUtil::mbLimitChars($wpCAw['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $wpCAw['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($wpCAw['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_MOBILE))); goto i_iPR; sT06M: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mobile pay not enable'); } goto vPYiM; i_iPR: if (isset($It5Ki['limitPay'])) { switch ($It5Ki['limitPay']) { case 'no_credit': $BT0HV['limit_pay'] = $It5Ki['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto hFnyO; zGdDm: return Response::generate(0, null, $smBDO); goto E3cK_; cmr3_: $E9nMK = self::getWechatPayment(); goto MfCvi; y_5Z0: $ksdZm = $E9nMK->jssdk->bridgeConfig($Gs3Xd['prepay_id'], false); goto KQ2OB; KQ2OB: $smBDO = array('payJsSdkConfig' => $ksdZm, 'successRedirect' => $wpCAw['redirect']); goto zGdDm; E3cK_: } private static function createWechatH5($wpCAw, $xN3qr, $It5Ki) { goto Zcgxj; ZnM3C: if (isset($It5Ki['limitPay'])) { switch ($It5Ki['limitPay']) { case 'no_credit': $BT0HV['limit_pay'] = $It5Ki['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto o0jI9; pvx5L: $E9nMK = self::getWechatPayment(); goto xvgxI; Kr2r_: return Response::generate(0, null, $smBDO); goto NtjbM; S_8WU: self::update($wpCAw['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $xN3qr, 'timePayCreated' => Carbon::now(), 'payOrderId' => $Gs3Xd['prepay_id'])); goto uLL2n; sNHm0: if (!isset($Gs3Xd['return_code']) || $Gs3Xd['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($Gs3Xd['return_msg']) ? $Gs3Xd['return_msg'] : 'NULL')); } goto NIey1; xvgxI: $BT0HV = array('trade_type' => 'MWEB', 'body' => StrUtil::mbLimitChars($wpCAw['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $wpCAw['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($wpCAw['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_H5))); goto ZnM3C; o0jI9: try { $Gs3Xd = $E9nMK->order->unify($BT0HV); } catch (\Exception $hSVcc) { goto rzBVj; TE1hW: throw $hSVcc; goto YWNkc; y9myE: if (Str::contains($HMHj9, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto TE1hW; rzBVj: $HMHj9 = $hSVcc->getMessage(); goto y9myE; YWNkc: } goto sNHm0; uLL2n: $smBDO = array('payLink' => $Gs3Xd['mweb_url'], 'successRedirect' => $wpCAw['redirect']); goto Kr2r_; MDnkz: if ($Gs3Xd['result_code'] != 'SUCCESS') { $i168_ = $Gs3Xd['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $i168_ . ')'); } goto S_8WU; Zcgxj: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mobile pay not enable'); } goto pvx5L; NIey1: if (!isset($Gs3Xd['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto MDnkz; NtjbM: } public static function getWechatMiniProgramPayment() { goto r0yN5; V00XN: $XhVgh = array('app_id' => $XhVgh->getWithEnv('oauthWechatMiniProgramAppId'), 'mch_id' => $XhVgh->getWithEnv('payWechatMerchantId'), 'key' => $XhVgh->getWithEnv('payWechatKey'), 'cert_path' => '', 'key_path' => '', 'log' => array('default' => 'info', 'channels' => array('info' => array('driver' => 'single', 'path' => Logger::rotateLog('PayCenter_Wechat'), 'level' => 'info')))); goto ojo1O; r0yN5: $XhVgh = modstart_config(); goto V00XN; ojo1O: return Factory::payment($XhVgh); goto wfVXy; wfVXy: } private static function createWechatMiniProgram($wpCAw, $xN3qr, $It5Ki) { goto ogVJ8; TjJoG: $BT0HV = array('openid' => $It5Ki['openId'], 'trade_type' => 'JSAPI', 'body' => StrUtil::mbLimitChars($wpCAw['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $wpCAw['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($wpCAw['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_MINI_PROGRAM))); goto eAxCD; aKnQ6: $E9nMK = self::getWechatMiniProgramPayment(); goto TjJoG; L5ekE: return Response::generate(0, null, $smBDO); goto Zlywn; eAxCD: if (isset($It5Ki['limitPay'])) { switch ($It5Ki['limitPay']) { case 'no_credit': $BT0HV['limit_pay'] = $It5Ki['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto mhmVw; EeDEL: if (!isset($Gs3Xd['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto A3o6e; fQElI: $ksdZm = $E9nMK->jssdk->bridgeConfig($Gs3Xd['prepay_id'], false); goto d81og; mhmVw: try { $Gs3Xd = $E9nMK->order->unify($BT0HV); } catch (\Exception $hSVcc) { goto zDviA; Esz4E: throw $hSVcc; goto YTU_M; EF423: if (Str::contains($HMHj9, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto Esz4E; zDviA: $HMHj9 = $hSVcc->getMessage(); goto EF423; YTU_M: } goto vO4nC; KcTzJ: self::update($wpCAw['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $xN3qr, 'timePayCreated' => Carbon::now(), 'payOrderId' => $Gs3Xd['prepay_id'])); goto fQElI; A3o6e: if ($Gs3Xd['result_code'] != 'SUCCESS') { $i168_ = $Gs3Xd['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $i168_ . ')'); } goto KcTzJ; mrote: if (empty($It5Ki['openId'])) { return Response::generate(-1, 'wechat mini program openId empty'); } goto aKnQ6; ogVJ8: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mini program pay not enable'); } goto mrote; d81og: $smBDO = array('payJsSdkConfig' => $ksdZm, 'successRedirect' => $wpCAw['redirect']); goto L5ekE; vO4nC: if (!isset($Gs3Xd['return_code']) || $Gs3Xd['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($Gs3Xd['return_msg']) ? $Gs3Xd['return_msg'] : 'NULL')); } goto EeDEL; Zlywn: } public static function initAlipay() { config(array('latrell-alipay.partner_id' => config('pay.alipay.partnerId'), 'latrell-alipay.seller_id' => config('pay.alipay.sellerId'), 'latrell-alipay-web.key' => config('pay.alipay.key'), 'latrell-alipay-web.return_url' => action('\\Module\\PayCenter\\Web\\Controller\\ReturnController@index', array('payType' => PayType::ALIPAY)), 'latrell-alipay-web.notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::ALIPAY)))); } public static function alipayWebConfig($xN3qr) { return array('use_sandbox' => false, 'app_id' => modstart_config()->getWithEnv('payAlipayWebAppId'), 'sign_type' => 'RSA2', 'ali_public_key' => modstart_config()->getWithEnv('payAlipayWebAliPublicKey'), 'rsa_private_key' => modstart_config()->getWithEnv('payAlipayWebRSAPrivateKey'), 'limit_pay' => array(), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => $xN3qr)), 'return_url' => action('\\Module\\PayCenter\\Web\\Controller\\ReturnController@index', array('payType' => $xN3qr)), 'return_raw' => true); } private static function createAlipayWeb($wpCAw, $xN3qr, $It5Ki) { goto ruW35; dUcTR: return Response::generate(0, 'ok', $smBDO); goto ZKn4e; cDFLP: $smBDO = array(); goto vDxT_; LFENX: $r8z56 = array('body' => StrUtil::mbLimit(AlipayUtil::filterSpecialChars($wpCAw['body']), 200), 'subject' => StrUtil::mbLimit(AlipayUtil::filterSpecialChars($wpCAw['body']), 100), 'order_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $wpCAw['id'], 'timeout_express' => time() + 3600 * 24, 'amount' => $wpCAw['feeTotal'], 'return_param' => '', 'goods_type' => '0', 'store_id' => '', 'qr_mod' => ''); goto VNER4; SO86m: self::update($wpCAw['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $xN3qr, 'timePayCreated' => Carbon::now())); goto cDFLP; ruW35: $XhVgh = self::alipayWebConfig($xN3qr); goto LFENX; VNER4: try { $zHIxi = Charge::run(Config::ALI_CHANNEL_WEB, $XhVgh, $r8z56); } catch (\Exception $hSVcc) { return Response::generate(-1, '创建支付错误(' . $hSVcc->getMessage() . ')'); } goto SO86m; vDxT_: $smBDO['payLink'] = $zHIxi; goto uQBhS; uQBhS: $smBDO['successRedirect'] = $wpCAw['redirect']; goto dUcTR; ZKn4e: } private static function createAlipayMobile($wpCAw, $xN3qr, $It5Ki) { goto PyY7h; OGkxS: $smBDO['successRedirect'] = $wpCAw['redirect']; goto XKgL2; sSCkX: self::update($wpCAw['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $xN3qr, 'timePayCreated' => Carbon::now())); goto m3wrx; GeIE8: $smBDO['payLink'] = $zHIxi; goto OGkxS; m3wrx: $smBDO = array(); goto GeIE8; Rd11B: $r8z56 = array('body' => Str::limit(AlipayUtil::filterSpecialChars($wpCAw['body']), 200), 'subject' => Str::limit(AlipayUtil::filterSpecialChars($wpCAw['body']), 100), 'order_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $wpCAw['id'], 'timeout_express' => time() + 3600 * 24, 'amount' => $wpCAw['feeTotal'], 'return_param' => '', 'goods_type' => '0', 'store_id' => '', 'qr_mod' => ''); goto o4U2k; o4U2k: try { $zHIxi = Charge::run(Config::ALI_CHANNEL_WAP, $XhVgh, $r8z56); } catch (\Exception $hSVcc) { return Response::generate(-1, '创建支付错误(' . $hSVcc->getMessage() . ')'); } goto sSCkX; XKgL2: return Response::generate(0, 'ok', $smBDO); goto W0ulz; PyY7h: $XhVgh = self::alipayWebConfig($xN3qr); goto Rd11B; W0ulz: } private static function createMemberMoney($wpCAw, $xN3qr, $It5Ki) { goto EWQkw; PFPF4: if (Response::isError($Gs3Xd)) { return $Gs3Xd; } goto zKx1N; SrTu3: self::update($wpCAw['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $xN3qr, 'timePayCreated' => Carbon::now())); goto khSBz; v1cg3: if ($ZwIgO < $wpCAw['feeTotal']) { return Response::generateError('余额不足'); } goto SrTu3; khSBz: ModelUtil::transactionBegin(); goto dAJYU; DGX0t: $ZwIgO = MemberMoneyUtil::getTotal($q8wmq); goto v1cg3; zKx1N: return Response::generate(0, '支付成功', array('redirect' => $wpCAw['redirect'])); goto Pendh; EWQkw: $q8wmq = $It5Ki['memberUserId']; goto DGX0t; eGmCX: $Gs3Xd = PayOrderUtil::handleOrderPay(PayType::MEMBER_MONEY, config('pay.payOrderOutTradeNoPrefix') . '_' . $wpCAw['id']); goto PFPF4; dAJYU: try { MemberMoneyUtil::change($q8wmq, -$wpCAw['feeTotal'], $wpCAw['body']); ModelUtil::transactionCommit(); } catch (\Exception $hSVcc) { ModelUtil::transactionRollback(); return Response::generateError('支付失败，请重试'); } goto eGmCX; Pendh: } private static function createAlipay($wpCAw, $xN3qr, $It5Ki) { goto G9JLz; f4Txk: return Response::generate(0, 'ok', $smBDO); goto gXXIb; G9JLz: self::initAlipay(); goto VQDBI; bI0P0: self::update($wpCAw['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $xN3qr, 'timePayCreated' => Carbon::now())); goto Lnfhh; Laz6U: $ZWDyk->setBody(Str::limit($wpCAw['body'], 100)); goto bI0P0; Br8VA: $smBDO['successRedirect'] = $wpCAw['redirect']; goto f4Txk; EG_kV: $smBDO['payLink'] = $ZWDyk->getPayLink(); goto Br8VA; Lnfhh: $smBDO = array(); goto EG_kV; VQDBI: if (!config('latrell-alipay.partner_id') || !config('latrell-alipay.seller_id') || !config('latrell-alipay-web.key')) { return Response::generate(-1, '支付宝配置错误'); } goto xCiWz; yurDx: $ZWDyk->setOutTradeNo(config('pay.payOrderOutTradeNoPrefix') . '_' . $wpCAw['id']); goto mgxxg; UFRak: $ZWDyk->setSubject(Str::limit($wpCAw['body'], 200)); goto Laz6U; xCiWz: if (!empty($It5Ki['alipay_wap'])) { $ZWDyk = app('alipay.wap'); } else { $ZWDyk = app('alipay.web'); } goto yurDx; mgxxg: $ZWDyk->setTotalFee($wpCAw['feeTotal']); goto UFRak; gXXIb: } public static function getOrderByOutTradeNo($JhXYY) { goto JBFa_; i1avh: if (count($Ay3LM) != 2) { return Response::generate(-1, 'outTradeNo error'); } goto gRUwI; S1DS4: $vinkQ = $Ay3LM[1]; goto y5V5Q; Y8OYe: $MZHZc = ModelUtil::get('pay_order', array('id' => $vinkQ)); goto U0afg; y5V5Q: if ($Xtf1K != config('pay.payOrderOutTradeNoPrefix')) { return Response::generate(-1, 'outTradeNo prefix not match'); } goto Y8OYe; lYHXW: return Response::generateSuccessData(array('order' => $MZHZc)); goto HFr8p; U0afg: BizException::throwsIf('order not found', empty($MZHZc)); goto lYHXW; gRUwI: $Xtf1K = $Ay3LM[0]; goto S1DS4; JBFa_: $Ay3LM = explode('_', $JhXYY); goto i1avh; HFr8p: } public static function handleOrderPay($OUt2n, $JhXYY, $vW34L = array()) { goto eIqGb; SIUQp: $Xtf1K = $Ay3LM[0]; goto dw2R9; HAZoG: if (count($Ay3LM) != 2 && count($Ay3LM) != 3) { return Response::generate(-1, 'outTradeNo error'); } goto SIUQp; ZdNoT: $MZHZc = null; goto N_gPt; o5Yom: if ($aIpjL) { goto KIe0h; OwBRp: $Z8J51->bizId = $MZHZc['bizId']; goto CNeS0; CNeS0: $Z8J51->order = $MZHZc; goto Dakka; O8SvU: Log::info('PayCenter.HandleOrderPay.OrderPayedEvent - ' . json_encode($Z8J51, JSON_UNESCAPED_UNICODE)); goto n9jp2; KIe0h: $Z8J51 = new OrderPayedEvent(); goto dghM4; dghM4: $Z8J51->biz = $MZHZc['biz']; goto OwBRp; Dakka: EventUtil::fire($Z8J51); goto O8SvU; n9jp2: } goto pjqha; N_gPt: Log::info('PayCenter.PayOrderNotify - ' . $OUt2n . ' - ' . $JhXYY); goto LgvWb; eIqGb: $aIpjL = false; goto ZdNoT; kTHTX: return Response::generate(0, null, array('order' => $MZHZc)); goto sOe0R; DfT3d: try { goto K8cBB; T2hzd: $MZHZc = ModelUtil::getWithLock('pay_order', array('id' => $vinkQ)); goto P3ohF; al11o: if ($MZHZc['status'] == PayOrderStatus::CREATED) { goto HL3uP; HL3uP: Log::info('PayCenter.HandleOrderPay.UpdateOrderToPayed - ' . $JhXYY); goto PFxw2; PFxw2: ModelUtil::update('pay_order', array('id' => $MZHZc['id']), array_merge(array('status' => PayOrderStatus::PAYED, 'timePay' => Carbon::now()), $vW34L)); goto p0IYJ; p0IYJ: $aIpjL = true; goto uq3Sc; uq3Sc: } else { Log::info('PayCenter.HandleOrderPay.Status - ' . $MZHZc['status']); if (!empty($vW34L)) { ModelUtil::update('pay_order', array('id' => $MZHZc['id']), $vW34L); } } goto d9xdt; K8cBB: ModelUtil::transactionBegin(); goto T2hzd; P3ohF: if (empty($MZHZc)) { ModelUtil::transactionCommit(); return Response::generate(-1, 'order not found'); } goto al11o; d9xdt: ModelUtil::transactionCommit(); goto zQMV2; zQMV2: } catch (\Exception $hSVcc) { Log::error('PayCenter.HandleOrderPay.Error - ' . $hSVcc->getMessage()); ModelUtil::transactionRollback(); } goto o5Yom; R27v9: ModelUtil::decodeRecordJson($MZHZc, 'param'); goto kTHTX; pjqha: ModelUtil::update('pay_order', $MZHZc['id'], array('eventNotified' => true)); goto R27v9; YcGJA: $vW34L = array_merge(array('payType' => $OUt2n), $vW34L); goto DfT3d; LgvWb: $Ay3LM = explode('_', $JhXYY); goto HAZoG; oG7d1: if ($Xtf1K != config('pay.payOrderOutTradeNoPrefix')) { return Response::generate(-1, 'outTradeNo prefix not match'); } goto YcGJA; dw2R9: $vinkQ = $Ay3LM[1]; goto oG7d1; sOe0R: } }