<?php
namespace Payment\Notify; use Payment\Common\PayException; use Payment\Common\WxConfig; use Payment\Config; use Payment\Utils\ArrayUtil; use Payment\Utils\DataParser; class WxNotify extends NotifyStrategy { public function __construct(array $config) { try { $this->config = new WxConfig($config); } catch (PayException $e) { throw $e; } } public function getNotifyData() { $data = @file_get_contents('php://input'); $arrData = DataParser::toArray($data); if (empty($arrData)) { return false; } $arrData = ArrayUtil::paraFilter($arrData); if(isset($arrData['req_info'])){ $decryptReqInfo = base64_decode($arrData['req_info']); $decryptReqInfo = openssl_decrypt($decryptReqInfo,'aes-256-ecb',md5($this->config->md5Key),OPENSSL_RAW_DATA); $decryptReqInfo = DataParser::toArray($decryptReqInfo); $arrData = array_merge($decryptReqInfo,$arrData); } return $arrData; } public function checkNotifyData(array $data) { if ($data['return_code'] != 'SUCCESS') { return false; }else if(isset($data['result_code']) && $data['result_code'] != 'SUCCESS'){ return false; } if(isset($data['sign'])){ return $this->verifySign($data); }else{ return true; } } protected function verifySign(array $retData) { $retSign = $retData['sign']; $values = ArrayUtil::removeKeys($retData, ['sign', 'sign_type']); $values = ArrayUtil::paraFilter($values); $values = ArrayUtil::arraySort($values); $signStr = ArrayUtil::createLinkstring($values); $signStr .= '&key=' . $this->config->md5Key; switch ($this->config->signType) { case 'MD5': $sign = md5($signStr); break; case 'HMAC-SHA256': $sign = hash_hmac('sha256', $signStr, $this->config->md5Key); break; default: $sign = ''; } return strtoupper($sign) === $retSign; } protected function getRetData(array $data) { if (isset($data['refund_id'])) { return $data; } else { if ($this->config->returnRaw) { $data['channel'] = Config::WX_CHARGE; return $data; } $totalFee = bcdiv($data['total_fee'], 100, 2); $cashFee = bcdiv($data['cash_fee'], 100, 2); $retData = [ 'bank_type' => $data['bank_type'], 'cash_fee' => $cashFee, 'device_info' => $data['device_info'], 'fee_type' => $data['fee_type'], 'is_subscribe' => $data['is_subscribe'], 'buyer_id' => $data['openid'], 'order_no' => $data['out_trade_no'], 'pay_time' => date('Y-m-d H:i:s', strtotime($data['time_end'])), 'amount' => $totalFee, 'trade_type' => $data['trade_type'], 'transaction_id' => $data['transaction_id'], 'trade_state' => strtolower($data['return_code']), 'channel' => Config::WX_CHARGE, ]; if (isset($data['attach']) && !empty($data['attach'])) { $retData['return_param'] = $data['attach']; } return $retData; } } protected function replyNotify($flag, $msg = 'OK') { $result = [ 'return_code' => 'SUCCESS', 'return_msg' => 'OK', ]; if (! $flag) { $result = [ 'return_code' => 'FAIL', 'return_msg' => $msg, ]; } return DataParser::toXml($result); } } 