<?php
namespace Payment\Notify; use Payment\Common\CmbConfig; use Payment\Common\PayException; use Payment\Config; use Payment\Utils\ArrayUtil; use Payment\Utils\RsaEncrypt; class CmbNotify extends NotifyStrategy { public function __construct(array $config) { try { $this->config = new CmbConfig($config); } catch (PayException $e) { throw $e; } } public function getNotifyData() { $data = empty($_POST) ? $_GET : $_POST; if (empty($data) || ! is_array($data)) { return false; } $retData = json_decode($data[CmbConfig::REQ_FILED_NAME], true); return $retData; } public function checkNotifyData(array $data) { $signType = strtoupper($data['signType']); $sign = $data['sign']; $values = ArrayUtil::arraySort($data['noticeData']); $preStr = ArrayUtil::createLinkstring($values); if ($signType === 'RSA') { $rsa = new RsaEncrypt($this->config->rsaPubKey); return $rsa->rsaVerify($preStr, $sign); } else { return false; } } protected function getRetData(array $data) { $noticeData = $data['noticeData']; $noticeType = $noticeData['noticeType']; if ($noticeType === CmbConfig::NOTICE_PAY) { $channel = Config::CMB_CHARGE; } elseif ($noticeType === CmbConfig::NOTICE_SIGN) { $channel = Config::CMB_BIND; } else { $channel = 'other'; } if ($this->config->returnRaw) { $data['channel'] = $channel; return $data; } elseif ($noticeType === CmbConfig::NOTICE_PAY) { $retData = [ 'amount' => $noticeData['amount'], 'channel' => $channel, 'date' => $noticeData['date'], 'order_no' => $noticeData['orderNo'], 'trade_state' => Config::TRADE_STATUS_SUCC, 'transaction_id' => $noticeData['bankSerialNo'], 'time_end' => date('Y-m-d H:i:s', strtotime($noticeData['dateTime'])), 'discount_fee' => $noticeData['discountAmount'], 'card_type' => $noticeData['cardType'], 'return_param' => $noticeData['merchantPara'], 'discount_flag' => $noticeData['discountFlag'], 'notice_no' => $noticeData['noticeSerialNo'], ]; } elseif ($noticeType === CmbConfig::NOTICE_SIGN) { $retData = [ 'user_id' => $noticeData['userID'], 'no_pwd_pay' => $noticeData['noPwdPay'], 'notice_no' => $noticeData['noticeSerialNo'], 'agr_no' => $noticeData['agrNo'], 'rsp_msg' => $noticeData['rspMsg'], 'return_param' => $noticeData['noticePara'], 'user_pid_hash' => $noticeData['userPidHash'], 'user_pid_type' => $noticeData['userPidType'], 'channel' => $channel, ]; } else { $retData = $noticeData; } return $retData; } protected function replyNotify($flag, $msg = 'OK') { if ($flag) { header('HTTP/1.1 200 OK'); return $msg; } else { header('HTTP/1.1 503 Service Unavailable'); return $msg; } } } 