@extends($_viewFrame)

@section('pageTitleMain'){{$product['title']}}@endsection
@section('pageKeywords'){{$product['title']}}@endsection
@section('pageDescription'){{$product['title']}}@endsection

@section('bodyContent')

    <div class="ub-container margin-top" style="max-width:800px;">

        <div class="tw-bg-white tw-rounded tw-p-4">
            <div class="tw-mb-4 tw-w-1/3 tw-mx-auto">
                <div class="ub-cover-1-1 tw-rounded" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($product['cover'])}})"></div>
            </div>
            <div class="tw-text-lg tw-font-bold tw-text-center">
                {{$product['title']}}
                @if($product['deliverType']==\Module\Faka\Type\ProductDeliverType::MANUAL)
                    <span class="ub-text-warning ub-text-sm">手动发货</span>
                @endif
                @if($product['deliverType']==\Module\Faka\Type\ProductDeliverType::AUTO)
                    <span class="ub-text-success ub-text-sm">自动发货</span>
                @endif
            </div>
            <form action="{{modstart_api_url('faka/product/submit')}}" method="post" data-ajax-form>
                <div class="ub-form">
                    <input type="hidden" name="productId" value="{{$product['id']}}" />
                    <input type="hidden" name="redirect" value="{{modstart_web_url('faka/query')}}" />
                    <div class="line">
                        <div class="label">价格</div>
                        <div class="field">
                            <span class="value tw-text-lg tw-text-red-400 tw-font-bold">￥{{$product['price']}}</span>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">库存</div>
                        <div class="field">
                            @if($product['stock']<=0)
                                <span class="ub-text-danger">缺货</span>
                            @else
                                {{$product['stock']}}
                            @endif
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">数量</div>
                        <div class="field">
                            <input type="number" class="form" style="width:8em;" value="1" name="amount" />
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">邮箱</div>
                        <div class="field">
                            <input type="text" class="form" style="width:20em;" placeholder="" value="" name="email" />
                            <div class="help">
                                邮箱用于接收发卡信息，同时作为订单查询重要依据
                            </div>
                        </div>
                    </div>
                    @for($i=1;$i<=5;$i++)
                        {!! \ModStart\Field\CustomField::renderForm($product['customField'.$i],'customField'.$i,null,['fileServer'=>modstart_web_url('member_data/file_manager/file')]) !!}
                    @endfor
                    <div class="line">
                        <div class="label">备注：</div>
                        <div class="field">
                            <textarea name="remark" rows="2" placeholder="输入备注留言（可选）"></textarea>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">&nbsp;</div>
                        <div class="field">
                            <button type="submit" class="btn btn-lg btn-round btn-primary">
                                <i class="iconfont icon-cart"></i>
                                立即购买
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <div class="ub-panel margin-top">
            <div class="head">
                <div class="title">
                    商品描述
                </div>
            </div>
            <div class="body ub-html lg">
                {!! $product['content'] !!}
            </div>
        </div>


    </div>

@endsection





