@extends($_viewFrame)

@section('pageTitleMain')通过邮箱查询订单@endsection
@section('pageKeywords')通过邮箱查询订单@endsection
@section('pageDescription')通过邮箱查询订单@endsection

{!! \ModStart\ModStart::js('asset/common/clipboard.js') !!}

@section('bodyAppend')
    @parent
    {{\ModStart\ModStart::js('asset/common/commonVerify.js')}}
    <script>
        window.__checkCaptcha = function (){
            $('[data-captcha-status]').hide().filter('[data-captcha-status=loading]').show()
            window.api.base.post("{{modstart_web_url('faka/query/email_captcha_verify')}}",{captcha:$('[name=captcha]').val()},function (res) {
                window.api.base.defaultFormCallback(res,{
                    success:function (res) {
                        $('[data-captcha-status]').hide().filter('[data-captcha-status=success]').show();
                    },
                    error:function (res) {
                        $('[data-captcha-status]').hide().filter('[data-captcha-status=error]').show();
                        $('[data-captcha]').click();
                    }
                })
            })
        };
        $(function () {
            new window.api.commonVerify({
                generateServer: '{{modstart_web_url('faka/query/email_verify')}}',
                selectorTarget: 'input[name=email]',
                selectorGenerate: '[data-email-verify-generate]',
                selectorCountdown: '[data-email-verify-countdown]',
                selectorRegenerate: '[data-email-verify-regenerate]',
                selectorCaptcha: 'input[name=captcha]',
                selectorCaptchaImg:'[data-none]',
                interval: 60,
            },window.api.dialog);
        });
        window.addEventListener('modstart:form.submitted',function(e){
            if(e.detail.res.code===0){
                window.api.dialog.tipSuccess('查询完成');
                $('[data-result]').html(e.detail.res.data.html)
            }else{
                $('[data-result]').html('')
            }
        });
    </script>
@endsection

@section('bodyContent')

    <div class="ub-container margin-top" style="max-width:800px;">

        <div class="ub-nav-header">
            订单查询
        </div>

        <div class="ub-nav-tab">
            <a href="{{modstart_web_url('faka/query/browser')}}">
                <i class="iconfont icon-desktop"></i>
                浏览器缓存查询
            </a>
            <a href="{{modstart_web_url('faka/query/email')}}" class="active">
                <i class="iconfont icon-email"></i>
                通过邮箱查询
            </a>
        </div>
        <div class="tw-bg-white tw-p-4 tw-rounded-b">
            <div class="ub-form">
                <form action="{{modstart_web_url('faka/query/email')}}" data-ajax-form method="post">
                    <div class="line">
                        <div class="label">说明：</div>
                        <div class="field">
                            <div class="ub-text-muted">订单查询可以查询最近30天的数据，仅能查询最近一笔订单。</div>
                            <div class="ub-text-muted">如果您下单后没有清除浏览器缓存或Cookie，可以通过浏览器缓存查询订单下发结果。</div>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">图片验证：</div>
                        <div class="field">
                            <div class="row no-gutters">
                                <div class="col-6">
                                    <input type="text" class="form" name="captcha" autocomplete="off" onblur="__checkCaptcha()" placeholder="" />
                                </div>
                                <div class="col-6">
                                    <img class="captcha" style="width:100px;" data-captcha title="刷新验证" onclick="this.src=window.__msRoot+'faka/query/email_captcha?'+Math.random()" src="{{$__msRoot}}faka/query/email_captcha?{{time()}}" />
                                </div>
                            </div>
                            <div class="help">
                                <text class="ub-text-muted" data-captcha-status="tip"><i class="iconfont icon-warning"></i> 输入图片验证码验证</text>
                                <text class="ub-text-muted" data-captcha-status="loading" style="display:none;"><i class="iconfont icon-refresh"></i> 正在验证</text>
                                <text class="ub-text-success" data-captcha-status="success" style="display:none;"><i class="iconfont icon-checked"></i> 验证通过</text>
                                <text class="ub-text-danger" data-captcha-status="error" style="display:none;"><i class="iconfont icon-close-o"></i> 验证失败</text>
                            </div>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">输入邮箱：</div>
                        <div class="field">
                            <div class="row no-gutters">
                                <div class="col-6">
                                    <input type="text" class="form" name="email" autocomplete="off" placeholder="" />
                                </div>
                                <div class="col-6">
                                    <button class="btn" style="width:100px;" type="button" data-email-verify-generate>获取验证码</button>
                                    <button class="btn" type="button" data-email-verify-countdown style="width:100px;display:none;margin:0;"></button>
                                    <button class="btn" type="button" data-email-verify-regenerate style="width:100px;display:none;margin:0;">重新获取</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">邮箱验证码：</div>
                        <div class="field">
                            <div class="row no-gutters">
                                <div class="col-6">
                                    <input type="text" class="form" name="emailVerify" autocomplete="off" placeholder="" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">&nbsp;</div>
                        <div class="field">
                            <button type="submit" class="btn btn-primary btn-round">立即查询</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div data-result>
        </div>


    </div>

@endsection





