@extends($_viewFrame)

@section('pageTitle'){{modstart_config('siteName').' | '.modstart_config('siteSlogan')}}@endsection

@section('bodyContent')

    <div class="ub-container margin-top" style="max-width:800px;">
        <div class="ub-panel">
            <div class="head">
                <div class="title">
                    <i class="iconfont icon-bell"></i>
                    系统公告
                </div>
            </div>
            <div class="body ub-html lg">
                {!! modstart_config('Faka_Notice') !!}
            </div>
        </div>

        @foreach($categories as $category)
            <div class="ub-panel">
                <div class="head">
                    <div class="title">
                        <i class="iconfont icon-category"></i>
                        {{$category['title']}}
                    </div>
                </div>
                <div class="body">
                    <table class="ub-table">
                        <thead>
                            <tr>
                                <th>商品</th>
                                <th>发货模式</th>
                                <th>单价</th>
                                <th>库存</th>
                                <th width="100">操作</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($products as $product)
                                @if($product['categoryId']==$category['id'])
                                <tr>
                                    <td>
                                        <a href="{{modstart_web_url('faka/product/'.$product['id'])}}">
                                        {{$product['title']}}
                                        </a>
                                    </td>
                                    <td>
                                        @if($product['deliverType']==\Module\Faka\Type\ProductDeliverType::MANUAL)
                                            <div class="ub-text-warning">手动发货</div>
                                        @endif
                                        @if($product['deliverType']==\Module\Faka\Type\ProductDeliverType::AUTO)
                                            <div class="ub-text-success">自动发货</div>
                                        @endif
                                    </td>
                                    <td>￥{{$product['price']}}</td>
                                    <td>
                                        @if($product['stock']<=0)
                                            <span class="ub-text-danger">缺货</span>
                                        @else
                                            {{$product['stock']}}
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{modstart_web_url('faka/product/'.$product['id'])}}" class="btn btn-primary btn-round">
                                            <i class="iconfont icon-cart"></i>
                                            购买
                                        </a>
                                    </td>
                                </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endforeach

    </div>

@endsection





