# Linux For Beginners

A Red Hat Certified System Administrator (RHCSA) is able to perform the following tasks  :simple_smile:

[Linux Beginners](https://github.com/techtutorials/Linux-For-Beginners)

* [Facebook](https://www.facebook.com/Linuxarkit/)
* [Email List](https://feedburner.google.com/fb/a/mailverify?uri=arkit)
* [Linkedin](https://in.linkedin.com/in/ravi-kumar-94530121)
* [Reddit](https://www.reddit.com/r/techtutorial/)
* [Twitter](https://twitter.com/aravikumar48)
* [Youtube](https://www.youtube.com/Techarkit?sub_confirmation=1)
* [Email Address](aravikumar48@gmail.com)

**RHCSA Objectives**

- Understand and use essential tools for handling files, directories, command-line environments, and documentation
- Operate running systems, including booting into different run levels, identifying processes, starting and stopping virtual machines, and controlling services
- Configure local storage using partitions and logical volumes
- Create and configure file systems and file system attributes, such as permissions, encryption, access control lists, and network file systems
- Deploy, configure, and maintain systems, including software installation, update, and core services
- Manage users and groups, including use of a centralized directory for authentication
- Manage security, including basic firewall and SELinux configuration

**Red Hat Enterprise Linux 8 Tutorial**

- [RHEL 8 Video PlayList](https://www.youtube.com/watch?v=AdSnscHC3YA&list=PL8cE5Nxf6M6Z0MhnxDU8o_k-6xCSM8Kmi)
- [RHEL 8 Course Curriculum](https://www.youtube.com/watch?v=AdSnscHC3YA)
- [Introduction to Linux](https://www.youtube.com/watch?v=fWHe5W5Br4Q)
- [Linux Directory Structure](https://www.youtube.com/watch?v=DPpzSZwqJnA)
- [Download RHEL 8 ISO](https://www.youtube.com/watch?v=s_xZfMfqulY)
- [How to Install Os on a remote server](https://www.youtube.com/watch?v=nzl19AlllYA)
- [Register RHEL 8 and update packages](https://www.youtube.com/watch?v=0pmeBZoVW5s)

**RHCSA**
- [RHCSA Certification Course Overview](https://www.youtube.com/watch?v=BskRmjvWG5Y)
- [Setup Linux Lab using your Desktop](https://www.youtube.com/watch?v=2DKrI3CWfbE)
- [Introduction to Linux Operating System](https://www.youtube.com/watch?v=Wv5VHr4esvs)
- [Download ISO and Centos7 Installation Guide](https://www.youtube.com/watch?v=I25FJk7Vzjc)
- [Getting Started with Linux Basic Commands](https://www.youtube.com/watch?v=34E_QacTwww)

- [Alias Command Linux | Create Shortcuts for Long Commands](https://www.youtube.com/watch?v=4HS7w3aQoaE)
- [awk Command | Powerful Text Manipulation Tool](https://www.youtube.com/watch?v=7qaBKueySg0)
- [Crontab Command - 15 Cronjob Scheduling Examples in Linux](https://www.youtube.com/watch?v=6dJlp133iYg)
- [Curl Command | Send and Receive Files From Server](https://www.youtube.com/watch?v=tjQ9beFSBmA)
- [Find Command | Search Files and Directory in Linux](https://www.youtube.com/watch?v=OmPoEDJxcmA)
- [Firewall-cmd command | Firewall Using FirewallD on CentOS 7](https://www.youtube.com/watch?v=fKFYDVWFndc)
- [Fdisk Command | Fixed Disk | Format Disk - Manage Disks & Partitions](https://www.youtube.com/watch?v=I2KsQ0rpuXE)
- [Grep Command | 15 Amazing Practical Examples](https://www.youtube.com/watch?v=kHd-HMe0OOE)
- [Hostname Command | How To Assign and Change Hostname in RHEL 7](https://www.youtube.com/watch?v=AcaETZeHM9o)
- [dig Command | Troubleshoot DNS record Issues](https://www.youtube.com/watch?v=753xPLKWklA)
- [tr Command in Linux/Unix](https://www.youtube.com/watch?v=4rfXktIV6cE)
- [chage command | Enforce Users To Change  Passwords Frequently](https://www.youtube.com/watch?v=zENZ3sPaLhI)
- [cpio command | Find and Archive the Files &amp; Directory Tree](https://www.youtube.com/watch?v=ItHisMxfv-E)
- [dd Command | Create HDD Image Backup and Restore](https://www.youtube.com/watch?v=0zcb6Ecpacw)
- [head command | tail command To check Log Files | Linux Tutorial](https://www.youtube.com/watch?v=raI1yrYwGfY)
- [File Globing in Linux | Wildcards To Fetch Data](https://www.youtube.com/watch?v=r_f8yF_epxQ)
- [chmod command | Modify Files &amp; Directory Permissions](https://www.youtube.com/watch?v=0qJW0225ASI)
- [du Command | Disk utilization analyze - ](https://www.youtube.com/watch?v=YDoto35PmUI)
- [file command to determine any file type - ](https://www.youtube.com/watch?v=RD4DahuBN2k)
- [history command | Remember Commands Like Pro](https://www.youtube.com/watch?v=uFvF17UnYZg)
- [diff Command | Compare Multiple Files Content - ](https://www.youtube.com/watch?v=Zc50h2wGUp4)
- [cut command in Linux | Trim Text As You Like](https://www.youtube.com/watch?v=Dn9t50Y2o0s)
- [free command | Check System Memory Usage to identify Performance Issues](https://www.youtube.com/watch?v=MYvr_uy6L9w)
- [chgrp command | Change Group Ownership Of Files and Directories](https://www.youtube.com/watch?v=WUrxbMSDV8Y)
- [df Command | Disk File System Usage Report](https://www.youtube.com/watch?v=O8ElkiAGsfM)
- [Linux commands: id Command | print real and effective user and group IDs](https://www.youtube.com/watch?v=4j6ufjitfZM)
- [at command Linux - ](https://www.youtube.com/watch?v=IzF0MBAGad0)
- [date Command | Convert Date &amp; Time As Per Timezone](https://www.youtube.com/watch?v=FKBNZYr8Ryw)
- [cat command |  Concatenate files and print on the standard output](https://www.youtube.com/watch?v=3V_gxZnZk80)
- [chown command | Change User-Group Ownership of Files and Directories](https://www.youtube.com/watch?v=07bKJcc47nw)
- [Linux commands:  chattr command to protect files &amp; directories from accidental deletion](https://www.youtube.com/watch?v=A2lrUpCcbHE)
- [cd command | Change the current directory to dir - ](https://www.youtube.com/watch?v=FPrtytWSBLE)
- [bc Command | An arbitrary-precision calculator language](https://www.youtube.com/watch?v=EJKtGl-6kHY)
- [expr command | Evaluate Expressions in Linux - ](https://www.youtube.com/watch?v=6LbMLSBoLGY)
- [cp Command | Copy Files &amp; Directories and Create Soft &amp; Hard Links](https://www.youtube.com/watch?v=StxMta9_q70)
- [Linux commands:  ifconfig command | To See Interface Details](https://www.youtube.com/watch?v=pGnsiAxsTug)
- [cal command | To View Calendar of Any Year](https://www.youtube.com/watch?v=xSN5tYuLiRM)
- [arp command Linux - ](https://www.youtube.com/watch?v=VG-MMju9RhQ)

- [25 Basic Linux Commands Commonly Used in Daily Tasks - RHCSA](https://www.youtube.com/watch?v=-I7WeOHj6LA)
- [Linux User Administration - RHCSA Certification Guide](https://www.youtube.com/watch?v=KejTjofmdM4)
- [Modify Linux User Properties and Set Password Age Policy](https://www.youtube.com/watch?v=8EzhyyutaN8)
- [YUM Repository Configuration RHEL 7 Step by Step Guide](https://www.youtube.com/watch?v=VXSKr4GKOgY)
- [Creating Linux Groups and Securing them with Password - RHCSA](https://www.youtube.com/watch?v=D1ZFQgTsz3U)
- [Linux File Permissions - umask Explained - RHCSA](https://www.youtube.com/watch?v=r-a1fcHHRQ8)
- [ACL - Access Control List - Linux Permissions - RHCSA](https://www.youtube.com/watch?v=0KbP-yHSvVI)
- [Special File Permissions Linux - SUID, SGID and Sticky Bit - Tech Arkit](https://www.youtube.com/watch?v=uFud2eZnXSM)
- [Sudo User Configuration Deep Dive - sudoers - visudo - Tech Arkit](https://www.youtube.com/watch?v=TygHDr_yHyw)
- [Linux Disk Partitioning Creating Standard Partitions - RHCSA - Tech Arkit](https://www.youtube.com/watch?v=yc9Gz5xLSSk)
- [How To Delete Standard Partitions in Linux - Tech Arkit](https://www.youtube.com/watch?v=LhecpXO7nug)
- [LVM  Logical Volume Manager - Creating Logical Volumes - RHCSA](https://www.youtube.com/watch?v=3mgm2Q4DIdg)
- [lvextend Extending Logical Volume Size non-disruptively - RHCSA](https://www.youtube.com/watch?v=5e5h6xYctL0)
- [lvreduce How to Reduce LVM Size without Loosing data](https://www.youtube.com/watch?v=qj34vtpyfVg)
- [How to Get Help From Linux Command Line and Man Pages - RHCSA](https://www.youtube.com/watch?v=EyILeB9Drso)
- [OpenSSH (Secure Shell) Server and Client Configuration - RHCSA](https://www.youtube.com/watch?v=4SdszyDodcU)
- [Syslog Server Analyzing and Storing Logs - RHCSA](https://www.youtube.com/watch?v=KHUG3gFl0fM)
- [Archiving and Compressing Files and Directories - tar - RHCSA](https://www.youtube.com/watch?v=XkEsIjSAwws)
- [RPM   Red Hat Package Manager  Install/Remove/Upgrade/Query Software&#39;s](https://www.youtube.com/watch?v=7h5M48FvkZA)
- [Crontab and at  Commands - Automating Regular Tasks](https://www.youtube.com/watch?v=9CZ7rHtVQr0)
- [ps - Listing and Managing Linux Process - RHCSA](https://www.youtube.com/watch?v=ni2nTgDvyxE)
- [Access Linux machine using GUI and CLI1](https://www.youtube.com/watch?v=cwz1AgVQ41k)

- [Shell Scripting Tutorial-3 Linux Directory Structure Amazing way to understand](https://www.youtube.com/watch?v=rVxpe1_lNFE)
- [Shell Scripting Tutorial-2 Linux Basics - Linux basic commands](https://www.youtube.com/watch?v=IFvMor-0eFM)
- [Shell Scripting Tutorial-4 Basic Commands touch, cat, ls, cd, date, cal and pwd](https://www.youtube.com/watch?v=yYC8aaQ3eZA)
- [Shell Scripting Tutorial-5 Copy, Remove, Move and Time Commands](https://www.youtube.com/watch?v=G7XFreQkDB8)
- [Shell Scripting Tutorial-6 diff and grep command with regular expressions](https://www.youtube.com/watch?v=RwcQ6JzTsmA)
- [Shell Scripting Tutorial-7 head, tail, sort and more commands How to check logs using these commands](https://www.youtube.com/watch?v=OgV3qrPQulU)
- [Shell Scripting Tutorial-8 tr and wc command Count file characters, lines and words](https://www.youtube.com/watch?v=d40a5zFa8yI)
- [Shell Scripting Tutorial-9 Linux Disk Utilities to get required information](https://www.youtube.com/watch?v=vx1WZepOmKg)
- [Shell Scripting Tutorial-10 Getting Help from Command Line Interface](https://www.youtube.com/watch?v=GcYu-0IIJas)
- [Shell Scripting Tutorial-11 w, who, hostname, hostnamectl and uname commands](https://www.youtube.com/watch?v=7shAr5lp_Wc)
- [Shell Scripting Tutorial-12 find and locate command to search for files and directories](https://www.youtube.com/watch?v=Rd6e-OrsHpo)
- [Shell Scripting Tutorial-13 top command analyzing system performance](https://www.youtube.com/watch?v=UQ7rr4_47YY)
- [Shell Scripting Tutorial-14 Text Editors Nano and Vi](https://www.youtube.com/watch?v=K3SUrcJ740Y)
- [shell scripting Tutorial-15 sed, awk, vmstat, netstat and mail](https://www.youtube.com/watch?v=4hJorSKg9E0)
