const webpack = require('webpack');
const ExtractTextPlugin = require("extract-text-webpack-plugin");

module.exports = {
  output: {
    publicPath: '/$/',
  },
  devtool: 'source-map',
  plugins: [
    // new webpack.ProvidePlugin({
    //   $: 'jquery',
    //   jQuery: 'jquery',
    //   'window.jQuery': 'jquery',
    // }),
    new ExtractTextPlugin("edit.css"),
  ],
  resolve: {
    extensions: ['.ts', '.tsx', '.js', '.jsx', '.wasm']
  },
  module: {
    rules: [
      {
        test: /\.scss$/,
        use: ExtractTextPlugin.extract({
          fallback: "style-loader",
          use: ['css-loader', 'sass-loader'],
        })
      },
      {
        test: /\.css$/, use: [
          { loader: "style-loader" },
          { loader: "css-loader" }
        ]
      },
      {
        test: /\.(ttf|eot|svg|woff2?)(\?[a-z0-9]+)?$/,
        use: [{ loader: 'file-loader' }],
      },
      {
        test: /\.tsx?$/,
        use: [
          {loader: 'ts-loader' }
        ],
        exclude: /node_modules/
      },
    ]
  },
};