"""
This file is part of Betterscan CE (Community Edition).

Betterscan is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Betterscan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Betterscan. If not, see <https://www.gnu.org/licenses/>.

Originally licensed under the BSD-3-Clause license with parts changed under
LGPL v2.1 with Commons Clause.
See the original LICENSE file for details.

"""
"""Initial version.

Revision ID: b7454bc8b0b2
Revises:
Create Date: 2016-10-31 12:36:36.488736

"""

# revision identifiers, used by Alembic.
revision = 'b7454bc8b0b2'
down_revision = None
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('example',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('test', sa.Text(), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('user', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['user'], ['user.pk'], name='example_user_user', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk'),
    sa.UniqueConstraint('user', name='unique_example_user')
    )
    op.create_index(op.f('ix_example_created_at'), 'example', ['created_at'], unique=False)
    op.create_index(op.f('ix_example_pk'), 'example', ['pk'], unique=False)
    op.create_index(op.f('ix_example_updated_at'), 'example', ['updated_at'], unique=False)
    op.create_index(op.f('ix_example_user'), 'example', ['user'], unique=False)
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_example_user'), table_name='example')
    op.drop_index(op.f('ix_example_updated_at'), table_name='example')
    op.drop_index(op.f('ix_example_pk'), table_name='example')
    op.drop_index(op.f('ix_example_created_at'), table_name='example')
    op.drop_table('example')
    ### end Alembic commands ###
