"""
This file is part of Betterscan CE (Community Edition).

Betterscan is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Betterscan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Betterscan. If not, see <https://www.gnu.org/licenses/>.

Originally licensed under the BSD-3-Clause license with parts changed under
LGPL v2.1 with Commons Clause.
See the original LICENSE file for details.

"""
"""Initial models.

Revision ID: a2e0f8f4b344
Revises:
Create Date: 2016-11-20 23:02:51.424015

"""

# revision identifiers, used by Alembic.
revision = 'a2e0f8f4b344'
down_revision = None
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('issuecategory',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('name', sa.String(length=50), nullable=True),
    sa.PrimaryKeyConstraint('pk'),
    sa.UniqueConstraint('name', name='unique_issuecategory_name')
    )
    op.create_index(op.f('ix_issuecategory_created_at'), 'issuecategory', ['created_at'], unique=False)
    op.create_index(op.f('ix_issuecategory_name'), 'issuecategory', ['name'], unique=False)
    op.create_index(op.f('ix_issuecategory_pk'), 'issuecategory', ['pk'], unique=False)
    op.create_index(op.f('ix_issuecategory_updated_at'), 'issuecategory', ['updated_at'], unique=False)
    op.create_table('issueclass',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('code', sa.String(length=50), nullable=True),
    sa.Column('file', sa.String(length=50), nullable=True),
    sa.Column('line', sa.String(length=50), nullable=True),
    sa.Column('hash', sa.String(length=64), nullable=True),
    sa.Column('severity', sa.Integer(), nullable=True),
    sa.Column('language', sa.String(length=50), nullable=True),
    sa.Column('title', sa.String(length=100), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('analyzer', sa.String(length=50), nullable=True),
    sa.Column('occurrence_description', sa.String(length=2000), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('pk'),
    sa.UniqueConstraint('code', 'analyzer', name='unique_together_issueclass_code_analyzer')
    )
    op.create_index(op.f('ix_issueclass_analyzer'), 'issueclass', ['analyzer'], unique=False)
    op.create_index(op.f('ix_issueclass_code'), 'issueclass', ['code'], unique=False)
    op.create_index(op.f('ix_issueclass_created_at'), 'issueclass', ['created_at'], unique=False)
    op.create_index(op.f('ix_issueclass_hash'), 'issueclass', ['hash'], unique=False)
    op.create_index(op.f('ix_issueclass_language'), 'issueclass', ['language'], unique=False)
    op.create_index(op.f('ix_issueclass_occurrence_description'), 'issueclass', ['occurrence_description'], unique=False)
    op.create_index(op.f('ix_issueclass_pk'), 'issueclass', ['pk'], unique=False)
    op.create_index(op.f('ix_issueclass_severity'), 'issueclass', ['severity'], unique=False)
    op.create_index(op.f('ix_issueclass_title'), 'issueclass', ['title'], unique=False)
    op.create_index(op.f('ix_issueclass_updated_at'), 'issueclass', ['updated_at'], unique=False)
    op.create_table('project',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('analysis_priority', sa.Integer(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('fetch_status', sa.String(), nullable=True),
    sa.Column('analysis_status', sa.String(length=50), nullable=True),
    sa.Column('analysis_requested_at', sa.DateTime(), nullable=True),
    sa.Column('fetch_error', sa.Text(), nullable=True),
    sa.Column('source', sa.String(length=100), nullable=False),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('analyze', sa.Boolean(), nullable=True),
    sa.Column('public', sa.Boolean(), nullable=True),
    sa.Column('description', sa.String(length=2000), nullable=True),
    sa.Column('deleted', sa.Boolean(), nullable=True),
    sa.Column('fetched_at', sa.DateTime(), nullable=True),
    sa.Column('configuration', sa.String(length=64), nullable=True),
    sa.Column('reset', sa.Boolean(), nullable=True),
    sa.Column('permalink', sa.String(length=100), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('analyzed_at', sa.DateTime(), nullable=True),
    sa.Column('reset_requested_at', sa.DateTime(), nullable=True),
    sa.Column('delete', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('pk'),
    sa.UniqueConstraint('permalink', name='unique_project_permalink')
    )
    op.create_index(op.f('ix_project_analysis_priority'), 'project', ['analysis_priority'], unique=False)
    op.create_index(op.f('ix_project_analysis_requested_at'), 'project', ['analysis_requested_at'], unique=False)
    op.create_index(op.f('ix_project_analysis_status'), 'project', ['analysis_status'], unique=False)
    op.create_index(op.f('ix_project_analyze'), 'project', ['analyze'], unique=False)
    op.create_index(op.f('ix_project_analyzed_at'), 'project', ['analyzed_at'], unique=False)
    op.create_index(op.f('ix_project_configuration'), 'project', ['configuration'], unique=False)
    op.create_index(op.f('ix_project_created_at'), 'project', ['created_at'], unique=False)
    op.create_index(op.f('ix_project_delete'), 'project', ['delete'], unique=False)
    op.create_index(op.f('ix_project_deleted'), 'project', ['deleted'], unique=False)
    op.create_index(op.f('ix_project_description'), 'project', ['description'], unique=False)
    op.create_index(op.f('ix_project_fetch_status'), 'project', ['fetch_status'], unique=False)
    op.create_index(op.f('ix_project_fetched_at'), 'project', ['fetched_at'], unique=False)
    op.create_index(op.f('ix_project_name'), 'project', ['name'], unique=False)
    op.create_index(op.f('ix_project_permalink'), 'project', ['permalink'], unique=False)
    op.create_index(op.f('ix_project_pk'), 'project', ['pk'], unique=False)
    op.create_index(op.f('ix_project_public'), 'project', ['public'], unique=False)
    op.create_index(op.f('ix_project_reset'), 'project', ['reset'], unique=False)
    op.create_index(op.f('ix_project_reset_requested_at'), 'project', ['reset_requested_at'], unique=False)
    op.create_index(op.f('ix_project_source'), 'project', ['source'], unique=False)
    op.create_index(op.f('ix_project_updated_at'), 'project', ['updated_at'], unique=False)
    op.create_table('tag',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('name', sa.String(length=50), nullable=True),
    sa.PrimaryKeyConstraint('pk'),
    sa.UniqueConstraint('name', name='unique_tag_name')
    )
    op.create_index(op.f('ix_tag_created_at'), 'tag', ['created_at'], unique=False)
    op.create_index(op.f('ix_tag_name'), 'tag', ['name'], unique=False)
    op.create_index(op.f('ix_tag_pk'), 'tag', ['pk'], unique=False)
    op.create_index(op.f('ix_tag_updated_at'), 'tag', ['updated_at'], unique=False)
    op.create_table('user',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('email_validated', sa.Boolean(), nullable=True),
    sa.Column('superuser', sa.Boolean(), nullable=True),
    sa.Column('new_email', sa.String(length=255), nullable=True),
    sa.Column('name', sa.String(length=50), nullable=True),
    sa.Column('email_change_requested_at', sa.DateTime(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('email', sa.String(length=255), nullable=True),
    sa.Column('terms_accepted_at', sa.DateTime(), nullable=True),
    sa.Column('terms_accepted', sa.Boolean(), nullable=True),
    sa.Column('password_reset_code', sa.String(length=64), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('email_validation_code', sa.String(length=64), nullable=True),
    sa.Column('password', sa.String(length=128), nullable=True),
    sa.Column('password_reset_requested_at', sa.DateTime(), nullable=True),
    sa.Column('delete', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('pk'),
    sa.UniqueConstraint('email', name='unique_user_email'),
    sa.UniqueConstraint('name', name='unique_user_name')
    )
    op.create_index(op.f('ix_user_created_at'), 'user', ['created_at'], unique=False)
    op.create_index(op.f('ix_user_delete'), 'user', ['delete'], unique=False)
    op.create_index(op.f('ix_user_email'), 'user', ['email'], unique=False)
    op.create_index(op.f('ix_user_email_validated'), 'user', ['email_validated'], unique=False)
    op.create_index(op.f('ix_user_email_validation_code'), 'user', ['email_validation_code'], unique=False)
    op.create_index(op.f('ix_user_name'), 'user', ['name'], unique=False)
    op.create_index(op.f('ix_user_new_email'), 'user', ['new_email'], unique=False)
    op.create_index(op.f('ix_user_password_reset_code'), 'user', ['password_reset_code'], unique=False)
    op.create_index(op.f('ix_user_pk'), 'user', ['pk'], unique=False)
    op.create_index(op.f('ix_user_updated_at'), 'user', ['updated_at'], unique=False)
    op.create_table('accesstoken',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('token', sa.String(length=64), nullable=True),
    sa.Column('user', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['user'], ['user.pk'], name='accesstoken_user_user', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk')
    )
    op.create_index(op.f('ix_accesstoken_created_at'), 'accesstoken', ['created_at'], unique=False)
    op.create_index(op.f('ix_accesstoken_pk'), 'accesstoken', ['pk'], unique=False)
    op.create_index(op.f('ix_accesstoken_token'), 'accesstoken', ['token'], unique=False)
    op.create_index(op.f('ix_accesstoken_updated_at'), 'accesstoken', ['updated_at'], unique=False)
    op.create_index(op.f('ix_accesstoken_user'), 'accesstoken', ['user'], unique=False)
    op.create_table('filerevision',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('hash', sa.String(length=64), nullable=True),
    sa.Column('language', sa.String(length=50), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('project', sa.String(length=32), nullable=True),
    sa.Column('sha', sa.String(length=64), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('path', sa.String(length=2000), nullable=True),
    sa.Column('configuration', sa.String(length=64), nullable=True),
    sa.ForeignKeyConstraint(['project'], ['project.pk'], name='filerevision_project_project', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk')
    )
    op.create_index(op.f('ix_filerevision_configuration'), 'filerevision', ['configuration'], unique=False)
    op.create_index(op.f('ix_filerevision_created_at'), 'filerevision', ['created_at'], unique=False)
    op.create_index(op.f('ix_filerevision_hash'), 'filerevision', ['hash'], unique=False)
    op.create_index(op.f('ix_filerevision_language'), 'filerevision', ['language'], unique=False)
    op.create_index(op.f('ix_filerevision_path'), 'filerevision', ['path'], unique=False)
    op.create_index(op.f('ix_filerevision_pk'), 'filerevision', ['pk'], unique=False)
    op.create_index(op.f('ix_filerevision_project'), 'filerevision', ['project'], unique=False)
    op.create_index(op.f('ix_filerevision_sha'), 'filerevision', ['sha'], unique=False)
    op.create_index(op.f('ix_filerevision_updated_at'), 'filerevision', ['updated_at'], unique=False)
    op.create_table('issue',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('code', sa.String(length=100), nullable=False),
    sa.Column('hash', sa.String(length=64), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('analyzer', sa.String(length=100), nullable=False),
    sa.Column('project', sa.String(length=32), nullable=False),
    sa.Column('fingerprint', sa.String(length=255), nullable=False),
    sa.Column('file', sa.String(length=100), nullable=False),
    sa.Column('line', sa.String(length=100), nullable=False),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('configuration', sa.String(length=64), nullable=True),
    sa.ForeignKeyConstraint(['project'], ['project.pk'], name='issue_project_project', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk'),
    sa.UniqueConstraint('project', 'fingerprint', 'analyzer', 'code', 'file', 'line', name='unique_together_issue_project_fingerprint_analyzer_code_f_l')
    )
    op.create_index(op.f('ix_issue_analyzer'), 'issue', ['analyzer'], unique=False)
    op.create_index(op.f('ix_issue_code'), 'issue', ['code'], unique=False)
    op.create_index(op.f('ix_issue_configuration'), 'issue', ['configuration'], unique=False)
    op.create_index(op.f('ix_issue_created_at'), 'issue', ['created_at'], unique=False)
    op.create_index(op.f('ix_issue_fingerprint'), 'issue', ['fingerprint'], unique=False)
    op.create_index(op.f('ix_issue_hash'), 'issue', ['hash'], unique=False)
    op.create_index(op.f('ix_issue_pk'), 'issue', ['pk'], unique=False)
    op.create_index(op.f('ix_issue_project'), 'issue', ['project'], unique=False)
    op.create_index(op.f('ix_issue_updated_at'), 'issue', ['updated_at'], unique=False)
    op.create_table('issueclass_issuecategory_categories',
    sa.Column('issuecategory', sa.String(length=32), nullable=True),
    sa.Column('issueclass', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['issuecategory'], ['issuecategory.pk'], name='issueclass_issuecategory_categories_issuecategory', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['issueclass'], ['issueclass.pk'], name='issueclass_issuecategory_categories_issueclass', ondelete='CASCADE'),
    sa.UniqueConstraint('issueclass', 'issuecategory', name='issueclass_issuecategory_categories_categories_unique')
    )
    op.create_index(op.f('ix_issueclass_issuecategory_categories_issuecategory'), 'issueclass_issuecategory_categories', ['issuecategory'], unique=False)
    op.create_index(op.f('ix_issueclass_issuecategory_categories_issueclass'), 'issueclass_issuecategory_categories', ['issueclass'], unique=False)
    op.create_table('issueclass_tag_tags',
    sa.Column('tag', sa.String(length=32), nullable=True),
    sa.Column('issueclass', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['issueclass'], ['issueclass.pk'], name='issueclass_tag_tags_issueclass', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['tag'], ['tag.pk'], name='issueclass_tag_tags_tag', ondelete='CASCADE'),
    sa.UniqueConstraint('issueclass', 'tag', name='issueclass_tag_tags_tags_unique')
    )
    op.create_index(op.f('ix_issueclass_tag_tags_issueclass'), 'issueclass_tag_tags', ['issueclass'], unique=False)
    op.create_index(op.f('ix_issueclass_tag_tags_tag'), 'issueclass_tag_tags', ['tag'], unique=False)
    op.create_table('project_tag_tags',
    sa.Column('tag', sa.String(length=32), nullable=True),
    sa.Column('project', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['project'], ['project.pk'], name='project_tag_tags_project', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['tag'], ['tag.pk'], name='project_tag_tags_tag', ondelete='CASCADE'),
    sa.UniqueConstraint('project', 'tag', name='project_tag_tags_tags_unique')
    )
    op.create_index(op.f('ix_project_tag_tags_project'), 'project_tag_tags', ['project'], unique=False)
    op.create_index(op.f('ix_project_tag_tags_tag'), 'project_tag_tags', ['tag'], unique=False)
    op.create_table('projectissueclass',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('enabled', sa.Boolean(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('project', sa.String(length=32), nullable=True),
    sa.Column('issue_class', sa.String(length=32), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.ForeignKeyConstraint(['issue_class'], ['issueclass.pk'], name='projectissueclass_issueclass_issue_class', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['project'], ['project.pk'], name='projectissueclass_project_project', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk'),
    sa.UniqueConstraint('project', 'issue_class', name='unique_together_projectissueclass_project_issue_class')
    )
    op.create_index(op.f('ix_projectissueclass_created_at'), 'projectissueclass', ['created_at'], unique=False)
    op.create_index(op.f('ix_projectissueclass_issue_class'), 'projectissueclass', ['issue_class'], unique=False)
    op.create_index(op.f('ix_projectissueclass_pk'), 'projectissueclass', ['pk'], unique=False)
    op.create_index(op.f('ix_projectissueclass_project'), 'projectissueclass', ['project'], unique=False)
    op.create_index(op.f('ix_projectissueclass_updated_at'), 'projectissueclass', ['updated_at'], unique=False)
    op.create_table('snapshot',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('hash', sa.String(length=64), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('project', sa.String(length=32), nullable=True),
    sa.Column('analyzed', sa.Boolean(), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('configuration', sa.String(length=64), nullable=True),
    sa.ForeignKeyConstraint(['project'], ['project.pk'], name='snapshot_project_project', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk')
    )
    op.create_index(op.f('ix_snapshot_analyzed'), 'snapshot', ['analyzed'], unique=False)
    op.create_index(op.f('ix_snapshot_configuration'), 'snapshot', ['configuration'], unique=False)
    op.create_index(op.f('ix_snapshot_created_at'), 'snapshot', ['created_at'], unique=False)
    op.create_index(op.f('ix_snapshot_hash'), 'snapshot', ['hash'], unique=False)
    op.create_index(op.f('ix_snapshot_pk'), 'snapshot', ['pk'], unique=False)
    op.create_index(op.f('ix_snapshot_project'), 'snapshot', ['project'], unique=False)
    op.create_index(op.f('ix_snapshot_updated_at'), 'snapshot', ['updated_at'], unique=False)
    op.create_table('task',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('status', sa.String(length=50), nullable=True),
    sa.Column('last_ping', sa.DateTime(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('project', sa.String(length=32), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('type', sa.String(length=50), nullable=True),
    sa.ForeignKeyConstraint(['project'], ['project.pk'], name='task_project_project', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk')
    )
    op.create_index(op.f('ix_task_created_at'), 'task', ['created_at'], unique=False)
    op.create_index(op.f('ix_task_last_ping'), 'task', ['last_ping'], unique=False)
    op.create_index(op.f('ix_task_pk'), 'task', ['pk'], unique=False)
    op.create_index(op.f('ix_task_project'), 'task', ['project'], unique=False)
    op.create_index(op.f('ix_task_status'), 'task', ['status'], unique=False)
    op.create_index(op.f('ix_task_type'), 'task', ['type'], unique=False)
    op.create_index(op.f('ix_task_updated_at'), 'task', ['updated_at'], unique=False)
    op.create_table('userrole',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('project', sa.String(length=32), nullable=True),
    sa.Column('role', sa.String(length=30), nullable=True),
    sa.Column('user', sa.String(length=32), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.ForeignKeyConstraint(['project'], ['project.pk'], name='userrole_project_project', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['user'], ['user.pk'], name='userrole_user_user', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk')
    )
    op.create_index(op.f('ix_userrole_created_at'), 'userrole', ['created_at'], unique=False)
    op.create_index(op.f('ix_userrole_pk'), 'userrole', ['pk'], unique=False)
    op.create_index(op.f('ix_userrole_project'), 'userrole', ['project'], unique=False)
    op.create_index(op.f('ix_userrole_role'), 'userrole', ['role'], unique=False)
    op.create_index(op.f('ix_userrole_updated_at'), 'userrole', ['updated_at'], unique=False)
    op.create_index(op.f('ix_userrole_user'), 'userrole', ['user'], unique=False)
    op.create_table('diff',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('hash', sa.String(length=64), nullable=True),
    sa.Column('snapshot_b', sa.String(length=32), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('project', sa.String(length=32), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('configuration', sa.String(length=64), nullable=True),
    sa.Column('snapshot_a', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['project'], ['project.pk'], name='diff_project_project', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['snapshot_a'], ['snapshot.pk'], name='diff_snapshot_snapshot_a', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['snapshot_b'], ['snapshot.pk'], name='diff_snapshot_snapshot_b', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk')
    )
    op.create_index(op.f('ix_diff_configuration'), 'diff', ['configuration'], unique=False)
    op.create_index(op.f('ix_diff_created_at'), 'diff', ['created_at'], unique=False)
    op.create_index(op.f('ix_diff_hash'), 'diff', ['hash'], unique=False)
    op.create_index(op.f('ix_diff_pk'), 'diff', ['pk'], unique=False)
    op.create_index(op.f('ix_diff_project'), 'diff', ['project'], unique=False)
    op.create_index(op.f('ix_diff_snapshot_a'), 'diff', ['snapshot_a'], unique=False)
    op.create_index(op.f('ix_diff_snapshot_b'), 'diff', ['snapshot_b'], unique=False)
    op.create_index(op.f('ix_diff_updated_at'), 'diff', ['updated_at'], unique=False)
    op.create_table('disksnapshot',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('snapshot', sa.String(length=32), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['snapshot'], ['snapshot.pk'], name='disksnapshot_snapshot_snapshot', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk'),
    sa.UniqueConstraint('snapshot', name='unique_disksnapshot_snapshot')
    )
    op.create_index(op.f('ix_disksnapshot_created_at'), 'disksnapshot', ['created_at'], unique=False)
    op.create_index(op.f('ix_disksnapshot_pk'), 'disksnapshot', ['pk'], unique=False)
    op.create_index(op.f('ix_disksnapshot_snapshot'), 'disksnapshot', ['snapshot'], unique=False)
    op.create_index(op.f('ix_disksnapshot_updated_at'), 'disksnapshot', ['updated_at'], unique=False)
    op.create_table('filerevision_filerevision_dependencies',
    sa.Column('filerevision_right', sa.String(length=32), nullable=True),
    sa.Column('filerevision', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['filerevision'], ['filerevision.pk'], name='filerevision_filerevision_dependencies_filerevision', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['filerevision_right'], ['filerevision.pk'], name='filerevision_filerevision_dependencies_filerevision_right', ondelete='CASCADE'),
    sa.UniqueConstraint('filerevision', 'filerevision_right', name='filerevision_filerevision_dependencies_dependencies_unique')
    )
    op.create_index(op.f('ix_filerevision_filerevision_dependencies_filerevision'), 'filerevision_filerevision_dependencies', ['filerevision'], unique=False)
    op.create_index(op.f('ix_filerevision_filerevision_dependencies_filerevision_right'), 'filerevision_filerevision_dependencies', ['filerevision_right'], unique=False)
    op.create_table('issueoccurrence',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('hash', sa.String(length=64), nullable=True),
    sa.Column('sequence', sa.Integer(), nullable=True),
    sa.Column('to_column', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('to_row', sa.Integer(), nullable=True),
    sa.Column('file_revision', sa.String(length=32), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('from_row', sa.Integer(), nullable=True),
    sa.Column('issue', sa.String(length=32), nullable=True),
    sa.Column('from_column', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['file_revision'], ['filerevision.pk'], name='issueoccurrence_filerevision_file_revision', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['issue'], ['issue.pk'], name='issueoccurrence_issue_issue', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk')
    )
    op.create_index(op.f('ix_issueoccurrence_created_at'), 'issueoccurrence', ['created_at'], unique=False)
    op.create_index(op.f('ix_issueoccurrence_file_revision'), 'issueoccurrence', ['file_revision'], unique=False)
    op.create_index(op.f('ix_issueoccurrence_hash'), 'issueoccurrence', ['hash'], unique=False)
    op.create_index(op.f('ix_issueoccurrence_issue'), 'issueoccurrence', ['issue'], unique=False)
    op.create_index(op.f('ix_issueoccurrence_pk'), 'issueoccurrence', ['pk'], unique=False)
    op.create_index(op.f('ix_issueoccurrence_updated_at'), 'issueoccurrence', ['updated_at'], unique=False)
    op.create_table('snapshot_filerevision_file_revisions',
    sa.Column('filerevision', sa.String(length=32), nullable=True),
    sa.Column('snapshot', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['filerevision'], ['filerevision.pk'], name='snapshot_filerevision_file_revisions_filerevision', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['snapshot'], ['snapshot.pk'], name='snapshot_filerevision_file_revisions_snapshot', ondelete='CASCADE'),
    sa.UniqueConstraint('snapshot', 'filerevision', name='snapshot_filerevision_file_revisions_file_revisions_unique')
    )
    op.create_index(op.f('ix_snapshot_filerevision_file_revisions_filerevision'), 'snapshot_filerevision_file_revisions', ['filerevision'], unique=False)
    op.create_index(op.f('ix_snapshot_filerevision_file_revisions_snapshot'), 'snapshot_filerevision_file_revisions', ['snapshot'], unique=False)
    op.create_table('difffilerevision',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('hash', sa.String(length=64), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('file_revision', sa.String(length=32), nullable=True),
    sa.Column('key', sa.Enum('added', 'deleted', 'modified', name='difffilerevision_key', native_enum=False), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('diff', sa.String(length=32), nullable=True),
    sa.Column('configuration', sa.String(length=64), nullable=True),
    sa.ForeignKeyConstraint(['diff'], ['diff.pk'], name='difffilerevision_diff_diff', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['file_revision'], ['filerevision.pk'], name='difffilerevision_filerevision_file_revision', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk')
    )
    op.create_index(op.f('ix_difffilerevision_configuration'), 'difffilerevision', ['configuration'], unique=False)
    op.create_index(op.f('ix_difffilerevision_created_at'), 'difffilerevision', ['created_at'], unique=False)
    op.create_index(op.f('ix_difffilerevision_diff'), 'difffilerevision', ['diff'], unique=False)
    op.create_index(op.f('ix_difffilerevision_file_revision'), 'difffilerevision', ['file_revision'], unique=False)
    op.create_index(op.f('ix_difffilerevision_hash'), 'difffilerevision', ['hash'], unique=False)
    op.create_index(op.f('ix_difffilerevision_pk'), 'difffilerevision', ['pk'], unique=False)
    op.create_index(op.f('ix_difffilerevision_updated_at'), 'difffilerevision', ['updated_at'], unique=False)
    op.create_table('diffissueoccurrence',
    sa.Column('data', sa.LargeBinary(), nullable=True),
    sa.Column('configuration', sa.String(length=64), nullable=True),
    sa.Column('hash', sa.String(length=64), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('key', sa.Enum('added', 'fixed', name='diffissueoccurrence_key', native_enum=False), nullable=True),
    sa.Column('pk', sa.String(length=32), nullable=False),
    sa.Column('diff', sa.String(length=32), nullable=True),
    sa.Column('issue_occurrence', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['diff'], ['diff.pk'], name='diffissueoccurrence_diff_diff', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['issue_occurrence'], ['issueoccurrence.pk'], name='diffissueoccurrence_issueoccurrence_issue_occurrence', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk')
    )
    op.create_index(op.f('ix_diffissueoccurrence_configuration'), 'diffissueoccurrence', ['configuration'], unique=False)
    op.create_index(op.f('ix_diffissueoccurrence_created_at'), 'diffissueoccurrence', ['created_at'], unique=False)
    op.create_index(op.f('ix_diffissueoccurrence_diff'), 'diffissueoccurrence', ['diff'], unique=False)
    op.create_index(op.f('ix_diffissueoccurrence_hash'), 'diffissueoccurrence', ['hash'], unique=False)
    op.create_index(op.f('ix_diffissueoccurrence_issue_occurrence'), 'diffissueoccurrence', ['issue_occurrence'], unique=False)
    op.create_index(op.f('ix_diffissueoccurrence_pk'), 'diffissueoccurrence', ['pk'], unique=False)
    op.create_index(op.f('ix_diffissueoccurrence_updated_at'), 'diffissueoccurrence', ['updated_at'], unique=False)
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_diffissueoccurrence_updated_at'), table_name='diffissueoccurrence')
    op.drop_index(op.f('ix_diffissueoccurrence_pk'), table_name='diffissueoccurrence')
    op.drop_index(op.f('ix_diffissueoccurrence_issue_occurrence'), table_name='diffissueoccurrence')
    op.drop_index(op.f('ix_diffissueoccurrence_hash'), table_name='diffissueoccurrence')
    op.drop_index(op.f('ix_diffissueoccurrence_diff'), table_name='diffissueoccurrence')
    op.drop_index(op.f('ix_diffissueoccurrence_created_at'), table_name='diffissueoccurrence')
    op.drop_index(op.f('ix_diffissueoccurrence_configuration'), table_name='diffissueoccurrence')
    op.drop_table('diffissueoccurrence')
    op.drop_index(op.f('ix_difffilerevision_updated_at'), table_name='difffilerevision')
    op.drop_index(op.f('ix_difffilerevision_pk'), table_name='difffilerevision')
    op.drop_index(op.f('ix_difffilerevision_hash'), table_name='difffilerevision')
    op.drop_index(op.f('ix_difffilerevision_file_revision'), table_name='difffilerevision')
    op.drop_index(op.f('ix_difffilerevision_diff'), table_name='difffilerevision')
    op.drop_index(op.f('ix_difffilerevision_created_at'), table_name='difffilerevision')
    op.drop_index(op.f('ix_difffilerevision_configuration'), table_name='difffilerevision')
    op.drop_table('difffilerevision')
    op.drop_index(op.f('ix_snapshot_filerevision_file_revisions_snapshot'), table_name='snapshot_filerevision_file_revisions')
    op.drop_index(op.f('ix_snapshot_filerevision_file_revisions_filerevision'), table_name='snapshot_filerevision_file_revisions')
    op.drop_table('snapshot_filerevision_file_revisions')
    op.drop_index(op.f('ix_issueoccurrence_updated_at'), table_name='issueoccurrence')
    op.drop_index(op.f('ix_issueoccurrence_pk'), table_name='issueoccurrence')
    op.drop_index(op.f('ix_issueoccurrence_issue'), table_name='issueoccurrence')
    op.drop_index(op.f('ix_issueoccurrence_hash'), table_name='issueoccurrence')
    op.drop_index(op.f('ix_issueoccurrence_file_revision'), table_name='issueoccurrence')
    op.drop_index(op.f('ix_issueoccurrence_created_at'), table_name='issueoccurrence')
    op.drop_table('issueoccurrence')
    op.drop_index(op.f('ix_filerevision_filerevision_dependencies_filerevision_right'), table_name='filerevision_filerevision_dependencies')
    op.drop_index(op.f('ix_filerevision_filerevision_dependencies_filerevision'), table_name='filerevision_filerevision_dependencies')
    op.drop_table('filerevision_filerevision_dependencies')
    op.drop_index(op.f('ix_disksnapshot_updated_at'), table_name='disksnapshot')
    op.drop_index(op.f('ix_disksnapshot_snapshot'), table_name='disksnapshot')
    op.drop_index(op.f('ix_disksnapshot_pk'), table_name='disksnapshot')
    op.drop_index(op.f('ix_disksnapshot_created_at'), table_name='disksnapshot')
    op.drop_table('disksnapshot')
    op.drop_index(op.f('ix_diff_updated_at'), table_name='diff')
    op.drop_index(op.f('ix_diff_snapshot_b'), table_name='diff')
    op.drop_index(op.f('ix_diff_snapshot_a'), table_name='diff')
    op.drop_index(op.f('ix_diff_project'), table_name='diff')
    op.drop_index(op.f('ix_diff_pk'), table_name='diff')
    op.drop_index(op.f('ix_diff_hash'), table_name='diff')
    op.drop_index(op.f('ix_diff_created_at'), table_name='diff')
    op.drop_index(op.f('ix_diff_configuration'), table_name='diff')
    op.drop_table('diff')
    op.drop_index(op.f('ix_userrole_user'), table_name='userrole')
    op.drop_index(op.f('ix_userrole_updated_at'), table_name='userrole')
    op.drop_index(op.f('ix_userrole_role'), table_name='userrole')
    op.drop_index(op.f('ix_userrole_project'), table_name='userrole')
    op.drop_index(op.f('ix_userrole_pk'), table_name='userrole')
    op.drop_index(op.f('ix_userrole_created_at'), table_name='userrole')
    op.drop_table('userrole')
    op.drop_index(op.f('ix_task_updated_at'), table_name='task')
    op.drop_index(op.f('ix_task_type'), table_name='task')
    op.drop_index(op.f('ix_task_status'), table_name='task')
    op.drop_index(op.f('ix_task_project'), table_name='task')
    op.drop_index(op.f('ix_task_pk'), table_name='task')
    op.drop_index(op.f('ix_task_last_ping'), table_name='task')
    op.drop_index(op.f('ix_task_created_at'), table_name='task')
    op.drop_table('task')
    op.drop_index(op.f('ix_snapshot_updated_at'), table_name='snapshot')
    op.drop_index(op.f('ix_snapshot_project'), table_name='snapshot')
    op.drop_index(op.f('ix_snapshot_pk'), table_name='snapshot')
    op.drop_index(op.f('ix_snapshot_hash'), table_name='snapshot')
    op.drop_index(op.f('ix_snapshot_created_at'), table_name='snapshot')
    op.drop_index(op.f('ix_snapshot_configuration'), table_name='snapshot')
    op.drop_index(op.f('ix_snapshot_analyzed'), table_name='snapshot')
    op.drop_table('snapshot')
    op.drop_index(op.f('ix_projectissueclass_updated_at'), table_name='projectissueclass')
    op.drop_index(op.f('ix_projectissueclass_project'), table_name='projectissueclass')
    op.drop_index(op.f('ix_projectissueclass_pk'), table_name='projectissueclass')
    op.drop_index(op.f('ix_projectissueclass_issue_class'), table_name='projectissueclass')
    op.drop_index(op.f('ix_projectissueclass_created_at'), table_name='projectissueclass')
    op.drop_table('projectissueclass')
    op.drop_index(op.f('ix_project_tag_tags_tag'), table_name='project_tag_tags')
    op.drop_index(op.f('ix_project_tag_tags_project'), table_name='project_tag_tags')
    op.drop_table('project_tag_tags')
    op.drop_index(op.f('ix_issueclass_tag_tags_tag'), table_name='issueclass_tag_tags')
    op.drop_index(op.f('ix_issueclass_tag_tags_issueclass'), table_name='issueclass_tag_tags')
    op.drop_table('issueclass_tag_tags')
    op.drop_index(op.f('ix_issueclass_issuecategory_categories_issueclass'), table_name='issueclass_issuecategory_categories')
    op.drop_index(op.f('ix_issueclass_issuecategory_categories_issuecategory'), table_name='issueclass_issuecategory_categories')
    op.drop_table('issueclass_issuecategory_categories')
    op.drop_index(op.f('ix_issue_updated_at'), table_name='issue')
    op.drop_index(op.f('ix_issue_project'), table_name='issue')
    op.drop_index(op.f('ix_issue_pk'), table_name='issue')
    op.drop_index(op.f('ix_issue_hash'), table_name='issue')
    op.drop_index(op.f('ix_issue_fingerprint'), table_name='issue')
    op.drop_index(op.f('ix_issue_created_at'), table_name='issue')
    op.drop_index(op.f('ix_issue_configuration'), table_name='issue')
    op.drop_index(op.f('ix_issue_code'), table_name='issue')
    op.drop_index(op.f('ix_issue_analyzer'), table_name='issue')
    op.drop_table('issue')
    op.drop_index(op.f('ix_filerevision_updated_at'), table_name='filerevision')
    op.drop_index(op.f('ix_filerevision_sha'), table_name='filerevision')
    op.drop_index(op.f('ix_filerevision_project'), table_name='filerevision')
    op.drop_index(op.f('ix_filerevision_pk'), table_name='filerevision')
    op.drop_index(op.f('ix_filerevision_path'), table_name='filerevision')
    op.drop_index(op.f('ix_filerevision_language'), table_name='filerevision')
    op.drop_index(op.f('ix_filerevision_hash'), table_name='filerevision')
    op.drop_index(op.f('ix_filerevision_created_at'), table_name='filerevision')
    op.drop_index(op.f('ix_filerevision_configuration'), table_name='filerevision')
    op.drop_table('filerevision')
    op.drop_index(op.f('ix_accesstoken_user'), table_name='accesstoken')
    op.drop_index(op.f('ix_accesstoken_updated_at'), table_name='accesstoken')
    op.drop_index(op.f('ix_accesstoken_token'), table_name='accesstoken')
    op.drop_index(op.f('ix_accesstoken_pk'), table_name='accesstoken')
    op.drop_index(op.f('ix_accesstoken_created_at'), table_name='accesstoken')
    op.drop_table('accesstoken')
    op.drop_index(op.f('ix_user_updated_at'), table_name='user')
    op.drop_index(op.f('ix_user_pk'), table_name='user')
    op.drop_index(op.f('ix_user_password_reset_code'), table_name='user')
    op.drop_index(op.f('ix_user_new_email'), table_name='user')
    op.drop_index(op.f('ix_user_name'), table_name='user')
    op.drop_index(op.f('ix_user_email_validation_code'), table_name='user')
    op.drop_index(op.f('ix_user_email_validated'), table_name='user')
    op.drop_index(op.f('ix_user_email'), table_name='user')
    op.drop_index(op.f('ix_user_delete'), table_name='user')
    op.drop_index(op.f('ix_user_created_at'), table_name='user')
    op.drop_table('user')
    op.drop_index(op.f('ix_tag_updated_at'), table_name='tag')
    op.drop_index(op.f('ix_tag_pk'), table_name='tag')
    op.drop_index(op.f('ix_tag_name'), table_name='tag')
    op.drop_index(op.f('ix_tag_created_at'), table_name='tag')
    op.drop_table('tag')
    op.drop_index(op.f('ix_project_updated_at'), table_name='project')
    op.drop_index(op.f('ix_project_source'), table_name='project')
    op.drop_index(op.f('ix_project_reset_requested_at'), table_name='project')
    op.drop_index(op.f('ix_project_reset'), table_name='project')
    op.drop_index(op.f('ix_project_public'), table_name='project')
    op.drop_index(op.f('ix_project_pk'), table_name='project')
    op.drop_index(op.f('ix_project_permalink'), table_name='project')
    op.drop_index(op.f('ix_project_name'), table_name='project')
    op.drop_index(op.f('ix_project_fetched_at'), table_name='project')
    op.drop_index(op.f('ix_project_fetch_status'), table_name='project')
    op.drop_index(op.f('ix_project_description'), table_name='project')
    op.drop_index(op.f('ix_project_deleted'), table_name='project')
    op.drop_index(op.f('ix_project_delete'), table_name='project')
    op.drop_index(op.f('ix_project_created_at'), table_name='project')
    op.drop_index(op.f('ix_project_configuration'), table_name='project')
    op.drop_index(op.f('ix_project_analyzed_at'), table_name='project')
    op.drop_index(op.f('ix_project_analyze'), table_name='project')
    op.drop_index(op.f('ix_project_analysis_status'), table_name='project')
    op.drop_index(op.f('ix_project_analysis_requested_at'), table_name='project')
    op.drop_index(op.f('ix_project_analysis_priority'), table_name='project')
    op.drop_table('project')
    op.drop_index(op.f('ix_issueclass_updated_at'), table_name='issueclass')
    op.drop_index(op.f('ix_issueclass_title'), table_name='issueclass')
    op.drop_index(op.f('ix_issueclass_severity'), table_name='issueclass')
    op.drop_index(op.f('ix_issueclass_pk'), table_name='issueclass')
    op.drop_index(op.f('ix_issueclass_occurrence_description'), table_name='issueclass')
    op.drop_index(op.f('ix_issueclass_language'), table_name='issueclass')
    op.drop_index(op.f('ix_issueclass_hash'), table_name='issueclass')
    op.drop_index(op.f('ix_issueclass_created_at'), table_name='issueclass')
    op.drop_index(op.f('ix_issueclass_code'), table_name='issueclass')
    op.drop_index(op.f('ix_issueclass_analyzer'), table_name='issueclass')
    op.drop_table('issueclass')
    op.drop_index(op.f('ix_issuecategory_updated_at'), table_name='issuecategory')
    op.drop_index(op.f('ix_issuecategory_pk'), table_name='issuecategory')
    op.drop_index(op.f('ix_issuecategory_name'), table_name='issuecategory')
    op.drop_index(op.f('ix_issuecategory_created_at'), table_name='issuecategory')
    op.drop_table('issuecategory')
    ### end Alembic commands ###

