﻿CREATE TABLE [dbo].[Table2]
(
	[Id] INT NOT NULL IDENTITY , 
	[Tbl1Id] UNIQUEIDENTIFIER NOT NULL, 
	[Tbl1Id2] INT NOT NULL,
	[Address1] CHAR(1000) NOT NULL, 
	[City] VARCHAR(MAX) COLLATE Latin1_General_BIN NOT NULL DEFAULT '' COLLATE Latin1_General_CS_AI_KS_WS, 
	[State] CHAR(1) NOT NULL, 
	[Zip] CHAR(9) NOT NULL DEFAULT 8675309, 
	[Amount] REAL NOT NULL, 
	[EnteredDate] DATETIME2 NULL DEFAULT SYSDATETIME(), 
    CONSTRAINT [FK_Table2_ToTable1] FOREIGN KEY ([Tbl1Id], [Tbl1Id2]) REFERENCES [Table1]([Table1Id], [Table1Id2]), 
	CONSTRAINT [PK_Table2] PRIMARY KEY ([Id])
)

GO

CREATE NONCLUSTERED INDEX [IX01_Table2] ON [dbo].[Table2] ([City])
GO

CREATE NONCLUSTERED INDEX [IX02_Table2] ON [dbo].[Table2] ([State])
GO

--CREATE NONCLUSTERED INDEX [IX03_Table2] ON [dbo].[Table2] ([Tbl1Id], [Tbl1Id2])
--GO
