﻿//------------------------------------------------------------------------------
//<copyright company="Microsoft">
//
//    The MIT License (MIT)
//    
//    Copyright (c) 2015 Microsoft
//    
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//    
//    The above copyright notice and this permission notice shall be included in all
//    copies or substantial portions of the Software.
//    
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//</copyright>
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;

namespace SqlServer.Rules.Tests.Utils
{
    /// <summary>
    /// Utility class for tracking and disposing of objects that implement IDisposable.
    /// 
    /// Original Source: https://github.com/microsoft/DACExtensions/blob/master/Samples/DisposableList.cs
    /// </summary>
    public sealed class DisposableList : List<IDisposable>, IDisposable
    {
        /// <summary>
        /// Disposes of all elements of list.
        /// </summary>
        public void Dispose()
        {
            Dispose(true);
        }

        /// <summary>
        /// Internal implementation of Dispose logic.
        /// </summary>
        private void Dispose(bool isDisposing)
        {
            foreach (IDisposable disposable in this)
            {
                disposable.Dispose();
            }
        }

        /// <summary>
        /// Add an item to the list.
        /// </summary>
        public T Add<T>(T item) where T : IDisposable
        {
            base.Add(item);

            return item;
        }
    }
}