# What is SuperNova Framework

SuperNova is an Application Development Framework designed for PHP developers who want to build web applications efficiently and quickly. It combines the best of both worlds, merging the simplicity of CodeIgniter and the functionality of Laravel frameworks, offering a powerful toolkit to make your development process more streamlined.

## Key Features

1. Easy-to-use: SuperNova is built with simplicity in mind, making it easy for developers to start using it right away without a steep learning curve.
2. Powerful libraries: SuperNova provides a wide range of built-in libraries for common tasks, such as database access, form validation, session management, and more.
3. Modular structure: The framework is designed with a modular structure, allowing developers to easily integrate and manage various components within their projects.
4. Extensible: Developers can easily extend the core functionality of SuperNova by creating custom libraries, plugins, and modules.
5. Secure: SuperNova follows industry best practices to ensure that the applications built with it are secure and reliable.
6. Performance: The framework is optimized for high performance, ensuring that applications built with it are fast and responsive.

## Server Requirements

To run a web application built with the SuperNova Framework, you need to have the following server requirements:

1. PHP version 7.1 or newer is recommended. Although it may work with PHP 5.6, it is highly advised against using such an outdated version due to security, performance, and feature limitations.
2. A web server like Apache or Nginx to serve your application.
3. A database server like MySQL, MariaDB, PostgreSQL, or SQLite, depending on your application's requirements.

## Installation

Download or Clone Repo to your Server

```bash
git clone https://github.com/tansheetalitaj/supernova-framework.git
cd supernova-framework
```

Download the latest version of the SuperNova Framework from the official repository.
Extract the downloaded archive to your web server's document root or a specific subdirectory.
Ensure that the necessary file and directory permissions are set, allowing the framework to write and manage files as needed.
Configure your web server to point to the public directory of the SuperNova installation as the document root.
Create a new database and configure the database connection settings in the appropriate configuration file within the SuperNova installation.

## Contributing
Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.

Please make sure to update tests as appropriate.

## License
[MIT](https://choosealicense.com/licenses/mit/)

## Conclusion
With the server requirements met and the framework installed, you can now start building your web application using the SuperNova Framework. Remember to follow the documentation and best practices to ensure that your application is secure, performant, and scalable.
