# Days 77-80 Twitter and Slack Bots

In the coming 4 days we're going to learn to write two exciting bots: 
1. a Twitter Bot that auto-posts your 100 Days course progress tweets as tracked on our platform;
2. a Slack Bot (_Slash Command_) that recommends a random new book to read next.

Both projects are not that difficult but require some setup due to authentication. No worries, I will guide you through it in my video lessons. Here is what we are going to do:

## Day 1. Watch the Twitter API videos

See me create a Twitter bot from scratch that takes care of my 100 Days of Code challenge tweets automatically.

## Day 2. Your own Twitter Bot

If you like the idea of automating your 100 Days tweeting, feel free to use my code, re-adjust it to your liking and deploy it to a server (see Heroku deployment in a previous lesson for example).
- If you keep your 100 Days log on Github, our original article used that approach: [How we Automated our 100DaysOfCode Daily Tweet](https://pybit.es/100days-autotweet.html)

The other option is to take what you learned and build a Twitter bot of your own. Additional PyBites resources:
- [Automate Tweeting: how to build a Twitterbot](https://pybit.es/automate-twitter.html): here we built a bot to auto-post new articles from various Python feeds.
- [How to Write a Simple Slack Bot to Monitor Your Brand on Twitter](https://pybit.es/twitter-monitor-slack-notify.html): this parsed tweets in realtime, posting to Slack when our domain gets mentioned. 

But maybe you want to tweet about movies, books or whatever hobby you have ([my first bot](https://bobbelderbos.com/2016/06/twitter-bot/) tweeted out design quotes). Be creative, build something useful to yourself or others.

By the way, I don't want to lock you into a service, so if you want to use Facebook, Telegram, or any other service, feel free to do so.

You can Pull Request your code here (not required): [PyBites Code Challenge #43 - Build a Chatbot Using Python](https://codechalleng.es/challenges/43/).

Example of a submission we got for this code challenge: [DisAtBot - How I Built a Chatbot With Telegram And Python](https://pybit.es/guest-telegram-python-chatbot.html).

## Day 3: Watch the Slack API videos

See me create a simple Slack _Slash Command_ that posts a random book to the channel or DM it's invoked in. The [live version](https://github.com/pybites/pbreadinglist/blob/master/slack/views.py) is a bit more involved, but I want to keep it simple here so you can get the concepts down.

## Day 4: Your own Slack Bot

As said in _Day 2_ try to create a bot for any service. If you are still working on Day 2's bot and want to do some more work today, that's fine too. It is all about getting deliberate practice. 

I do have to say though that with PyBites on Slack, as well as many companies adopting it as their primary collaboration tool (and the current chatbot trend), learning how to build Slack tools is a wise investment!

If you go with Slack here are some additional PyBites resources:
- Feel free to deploy this bot and/or add more functionality (again [live version](https://github.com/pybites/pbreadinglist/blob/master/slack/views.py)), you can use [ngrok](https://ngrok.com/) for local testing.
- PyBites Slack runs _karmabot_ that gives people karma and supports commands. Maybe [the code repo](https://github.com/pybites/karmabot) inspires you and/or gives you useful snippets for your project.
- Mentioned before: [How to Write a Simple Slack Bot to Monitor Your Brand on Twitter](https://pybit.es/twitter-monitor-slack-notify.html) - this combines Twitter and Slack.
- Another article on how you can build a Slack bot that handles commands: [How to Build a Simple Slack Bot](https://pybit.es/simple-chatbot.html)
- And another _Slash Command_: [Simple API Part 2 - Building a Deep Work Logger with Flask, Slack and Google Docs](https://pybit.es/flask-api-part2.html)

Good luck and remember: _the learning is in the practice_.

### Time to share what you've accomplished!

Be sure to share your last couple of days work on Twitter or Facebook. Use the hashtag **#100DaysOfWeb**. 

Here are [some examples](https://twitter.com/search?q=%23100DaysOfCode) to inspire you. Consider including [@talkpython](https://twitter.com/talkpython) and [@pybites](https://twitter.com/pybites) in your tweets.

*See a mistake in these instructions? Please [submit a new issue](https://github.com/talkpython/100daysofweb-with-python-course/issues) or fix it and [submit a PR](https://github.com/talkpython/100daysofweb-with-python-course/pulls).*
