# Days 69-72 Django Rest Framework

In the coming 4 days we're going to build a simple [Web API](https://en.wikipedia.org/wiki/Web_API) for the Quotes app we built in [Django intro](https://github.com/talkpython/100daysofweb-with-python-course/tree/master/days/045-048-django-intro) and [Django registration & login](https://github.com/talkpython/100daysofweb-with-python-course/tree/master/days/053-056-django-registration) lessons.

After setting up our environment, and loading in some quotes via a customized [django-admin command](https://docs.djangoproject.com/en/2.1/howto/custom-management-commands/), we will build a simple API with the [Django Rest Framework](https://www.django-rest-framework.org/). 

We will support full CRUD (create-read-update-delete) methods and look at permissions adding authentication and authorization.

Finally we will use the [django-rest-swagger](https://github.com/marcgibbons/django-rest-swagger) package, a _Swagger Documentation Generator for Django REST Framework_.

Here is the plan for the coming 4 days:

## Day 1. + 2. - Watch the videos 

Watch the videos for this lesson, make notes, and to get the most out of it try to follow along with [the demo code](demo).

## Day 3. + 4. - Practice yourself

You probably guessed it, starting day 3 you will use Django Rest Framework yourself to build an API. Use an existing project or generate some data of interest, for example via [Mockeroo](https://www.mockaroo.com/).

You can also try [PyBites Code Challenge 34 - Build a Simple API With Django REST Framework](https://codechalleng.es/challenges/34/) where we provided some ideas.

Have fun and share your work with us so we can try out your awesome API :) - good luck and remember: _the learning is in the practice_.

### Time to share what you've accomplished!

Be sure to share your last couple of days work on Twitter or Facebook. Use the hashtag **#100DaysOfWeb**.

Here are [some examples](https://twitter.com/search?q=%23100DaysOfCode) to inspire you. Consider including [@talkpython](https://twitter.com/talkpython) and [@pybites](https://twitter.com/pybites) in your tweets.

*See a mistake in these instructions? Please [submit a new issue](https://github.com/talkpython/100daysofweb-with-python-course/issues) or fix it and [submit a PR](https://github.com/talkpython/100daysofweb-with-python-course/pulls).*
