# Days 45-48 Build a Simple Django App

In the coming 4 days we're going to introduce you to the powerful [Django](https://www.djangoproject.com) web framework, building a simple quote app. First I will introduce you to Django as a framework and explain how it differs from a micro-framework like Flask.

Then we install Django and create a project and app. We will go over typical configuration options, URL routing, working with a database / Django's ORM and CRUD (Create, Read, Update, Delete) operations with function and class based views. This also touches upon Django's templating engine. Finally we make it look nice using the MUI CSS framework.

## Day 1. Watch the first half of the Django videos

This provides all the info to get started with Django. As Django might have a steep learning curve, I think it is best to teach you in two sessions. So after consuming half of the materials ...

## Day 2. Practice yourself

After taking in the materials of yesterday's videos set up the quote project/ app yourself. Or feel free to start your own app. Maybe you have an idea for an app, a burning desire to build something. Usually scratching your own itch you can get very far. I learned a lot of Django myself building [our coding platform](https://codechalleng.es). Refer back to the videos and get Django working, then set up your first model(s) and play with the objects in the Django Shell. 

If you already know Django, go straight into one of our Django code challenges:

1. [Code Challenge 29 - Create a Simple Django App](https://codechalleng.es/challenges/29/): create a Django app and PR your work.
2. Lacking ideas? [Code Challenge 33 - Build a Django Tracker, Weather or Review App](https://codechalleng.es/challenges/33/) gives you some ideas. Same here: build it, PR it, (if you want) share it!

Have fun and learn a lot!

## Day 3. Django videos - part II

Watch the second half of my videos where we build out the app to support adding, updating and deleting quotes. We look at forms, the admin back-end, function vs. class based views, templating, and handling static files to add some nice CSS. We want to make it look nice too right?

## Day 4. More Django practice

Now with some more Django lessons in, try get my example app up and running. You can type along, or use the demo code in this day's directory directly. All playing helps to solidify your learning. 

Of course if you started an interesting app during Day 2., you probably should pick up on that and build it out. Either way, all the time you spend actually _practicing with Django_ you learn a lot more than if you would have only watched the videos.

Good luck and again: _the learning is in the practice_.

### Time to share what you've accomplished!

Be sure to share your last couple of days work on Twitter or Facebook. Use the hashtag **#100DaysOfWeb**.

Here are [some examples](https://twitter.com/search?q=%23100DaysOfCode) to inspire you. Consider including [@talkpython](https://twitter.com/talkpython) and [@pybites](https://twitter.com/pybites) in your tweets.

*See a mistake in these instructions? Please [submit a new issue](https://github.com/talkpython/100daysofweb-with-python-course/issues) or fix it and [submit a PR](https://github.com/talkpython/100daysofweb-with-python-course/pulls).*
