# Day 41 – React: JavaScript user interfaces

In the coming 4 days you are going to write some React code, exciting! I prepared two interesting projects to hit the ground running: 

1. a front-end for our PyBites Tips API, and
2. a simple Hangman game.

## Day 1

Watch the first 9 videos of this chapter. After a short React intro, and a refresher on some ES6 (Ecmascript) / modern JS features, we dive straight into bootstrapping our first app with [create-react-app](https://github.com/facebook/create-react-app).

We will build a front-end for [our tips API](https://github.com/pybites/python_tips) using the [axios](https://github.com/axios/axios) plugin and of course React for rendering components. 

You can check out the demo code [here](demo/tips).

## Day 2

Accompanying video 10: now it's time to practice yourself. 

Try to build your own front-end for an API of your choice. At this point it should be easy to re-use my `axios` code so maybe you can focus on building one or more React components for rendering the data your API returns ...

Remember to use [create-react-app](https://github.com/facebook/create-react-app) to easily bootstrap your app. Good luck and have fun!

## Day 3

Continuing with videos 11-17 we are going to learn more about state in React apps and the ideal way to demo this is by building a game ([the React tutorial](https://reactjs.org/tutorial/tutorial.html) also teaches by building a game!). 

When I was learning Java I made a hangman variant called [Free Monkey](https://play.google.com/store/apps/details?id=com.bobbelderbos.freemonkey&hl=pa) and today I will demo a simplified version using React. 

You can check out the demo code [here](demo/freemonkey).

## Day 4

Accompanying video 18: it's time again to put into practice what you've learned yesterday. Can you build a simple game using React? 

If this still feels intimidating at this point I encourage you to just go through [the code of this lesson](demo/freemonkey) and/or the tic-tac-toe game of the [Intro to React tutorial](https://reactjs.org/tutorial/tutorial.html). 

Again, games are a great way to learn to program because they include many concepts like classes/ state, conditions, design, etc. 

To get the most out of this lesson really try to build something using React these days. 

--

Remember, the web runs on JS and React is a solid choice as a UI component library. Getting at least the basics down will go a long way, specially when you are or want to become a web developer!

### Time to share what you've accomplished!

Be sure to share your last couple of days work on Twitter or Facebook. Use the hashtag **#100DaysOfWeb**.

Here are [some examples](https://twitter.com/search?q=%23100DaysOfCode) to inspire you. Consider including [@talkpython](https://twitter.com/talkpython) and [@pybites](https://twitter.com/pybites) in your tweets.

*See a mistake in these instructions? Please [submit a new issue](https://github.com/talkpython/100daysofweb-with-python-course/issues) or fix it and [submit a PR](https://github.com/talkpython/100daysofweb-with-python-course/pulls).*
