# Days 33-36 Data access with SQLAlchemy

Now you have seen the videos from this chapter, you're ready to build a data-driven application using a database ORM - SQLAlchemy.

## Day 1-2: Watch the video lessons

The first half of this 4-day block is to watch the videos and study SQLAlchemy. Consider downloading and trying out the code samples developed during the course.

## Day 3: Start your database project

For this day, you will pick a database project from the following list of ideas. 

**[top-18-database-projects-ideas](https://web.archive.org/web/20200922100027/https://www.lovelycoding.org/2013/11/top-18-database-projects-ideas-for.engineering-bca-mca-btech-bsc.html)** (recently taken offline so here's the archive.org version)

This web page lists 18 different data modeling and database projects. Rather than us asking you do to one particular topic, you get to choose the one that resonates with you most. 

Each topic on that site has a short description of the data to be modeled.

**On this day 3**, you will model the data and create the basic project structure. This includes:

* The classes that build the database model (SQLAlchemy entities)
* Setup the connection to the DB (sqlite)
* Put the unit of work pieces in place (session_factory, etc)

Please refer to the demo code as an example for any of these steps:

**[github.com/talkpython/100daysofweb-with-python-course](https://github.com/talkpython/100daysofweb-with-python-course/tree/master/days/033-036-sqlalchemy-orm/demo/hovershare_app_final)**

## Day 4: Use the data model

Now that you have the data model built and database connection setup, it's time to read and write some data.

Finish your program by adding the ability to insert data (gotten from the user via `input()` perhaps or from importing other data relevant you found on the internet). Let the user ask questions about the data and answer them with queries (structured ones, not wide-open questions).

### Time to share what you've accomplished!

Be sure to share your last couple of days work on Twitter or Facebook. Use the hashtag **#100DaysOfWeb**. 

Here are [some examples](https://twitter.com/search?q=%23100DaysOfCode) to inspire you. Consider including [@talkpython](https://twitter.com/talkpython) and [@pybites](https://twitter.com/pybites) in your tweets.

*See a mistake in these instructions? Please [submit a new issue](https://github.com/talkpython/100daysofweb-with-python-course/issues) or fix it and [submit a PR](https://github.com/talkpython/100daysofweb-with-python-course/pulls).*


