# Day 25 – JavaScript Introduction

In the coming 4 days you are going to write some 'Vanilla' (pure / no frameworks) Javascript.

## Day 1

Watch the first 9 videos about the history of JS, how to run it and some fundamental building blocks of the language.

## Day 2

Check out video 10 and practice what you've learned doing 1-4 optional exercises using _control flow_, _functions_, _looping_ and _objects_. 

Check them out [here](demo/language/): use the _topic.html_ files to start, and look at the _topic-solution.html_ files if you get stuck.

Of course you are free to skip ahead but I recommend you at least try to code in JS a bit at this point to have the materials sink in quicker.

## Day 3

Watch videos 11-15 about working with the DOM (Document Object Model) - demo code [here](demo/dom) -, debugging, JS gotchas and more resources.

## Day 4

Check out video 16: I got two project apps you can work on today. Depending your expertise and time available, pick one or two:

1. [A simple calculator](demo/calculator) -> [starter template](demo/calculator/index-template.html)

2. [A calorie counter](demo/calories) -> [starter template](demo/calories/js/script-template.js)

You can look at my solutions [here](demo/calculator/index.html) and [here](demo/calories/js/script.js) respectively if you get stuck.

Of course these two projects are *optional*, convenient if you don't have use cases for JS yet.

However if you have some front-end stuff you can work on for your own projects, feel free to do that instead.

The most important is to try to put some of the JS you've learned so far into practice!

---

If you take this course it's likely you do some kind of web development. From full-stack developer to administrating a site, JS is an important skill to have! 

So learn as much as you can these 4 days, it's effort well invested! Good luck and remember: _the learning is in the practice_.

In future lessons you will build upon these skills building apps with 2 popular JS frameworks: Vue.js and React, exciting ...

### Time to share what you've accomplished!

Be sure to share your last couple of days work on Twitter or Facebook. Use the hashtag **#100DaysOfWeb**.

Here are [some examples](https://twitter.com/search?q=%23100DaysOfCode) to inspire you. Consider including [@talkpython](https://twitter.com/talkpython) and [@pybites](https://twitter.com/pybites) in your tweets.

*See a mistake in these instructions? Please [submit a new issue](https://github.com/talkpython/100daysofweb-with-python-course/issues) or fix it and [submit a PR](https://github.com/talkpython/100daysofweb-with-python-course/pulls).*
