# Days 017-020 Calling APIs in Flask 

Welcome to Calling APIs in Flask!
Over the next few days we'll be playing with two APIs based around Chuck Norris Jokes and Pokemon!

## Day 1: 

On Day 1 you'll be watching videos 3 - 6 where you'll set up your environment and learn about sending objects/variables to your Flask web page (template). All this using the [Chuck Norris API](https://api.chucknorris.io/) (you're welcome!).

If you have time to follow along as you watch the videos, please do so!


## Day 2: 

You have a couple of options for Day 2.

- If you didn't manage to follow along with the videos on Day 1, now's the time to do so.
- Add a Chuck Menu Bar button to your base Flask template.
- Time permitting, check out this [awesome list of APIs](https://medium.com/@vicbergquist/18-fun-apis-for-your-next-project-8008841c7be9) you can play with. Choose an API (other than Chuck Norris and Pokemon!), practice pulling static data and printing it on your web page.


## Day 3: 

For Day 3, watch the remaining videos: 7-12. These will use the [Pokemon API](https://pokeapi.co/) to cover the basics of Flask forms, POSTing data back to your Flask app, parsing the JSON return from the API and more.
It's a big one so if it spills into Day 4 don't worry!


## Day 4:

For the final day:

- Continue building the app if you didn't complete it on Day 3.
- Add in some error handling on the user input. Eg: Right now, entering a number or an invalid colour (not in the API) will break the app - account for these scenarios.
- Check out the rest of the [Pokemon API endpoints](https://pokeapi.co/docs/v2.html) and test printing other types of Pokemon data.
- If you're feeling *really* brave: on our existing app (printing the names of a Pokemon of a specific colour), have the app return more than just the Pokemon name. Eg: the "Nature", the "Form", the "Habitat"..


### Time to share what you've accomplished!

Be sure to share your last couple of days work on Twitter or Facebook. Use the hashtag **#100DaysOfWeb**. 

Here are [some examples](https://twitter.com/search?q=%23100DaysOfCode) to inspire you. Consider including [@talkpython](https://twitter.com/talkpython) and [@pybites](https://twitter.com/pybites) in your tweets.

*See a mistake in these instructions? Please [submit a new issue](https://github.com/talkpython/100daysofweb-with-python-course/issues) or fix it and [submit a PR](https://github.com/talkpython/100daysofweb-with-python-course/pulls).*
