# Days 13 - 16: CSS Basics

Now you have seen the videos from this chapter, you're ready to start exploring the world of CSS.

## Day 1: Watch the video lessons

The watch the videos and keep track of where you might want to grab some examples. Remember you have everything you saw typed in the demos folder adjacent to this one if you need them.

## Days 2: Play with the selectors

Today you get to play with CSS selectors. These are incredibly important because the way you target elements in CSS files are by specifying the selectors.

Open the selector section of our demo app (from the videos). It's located adjacent to this folder:

`013-016-css-basics/demos/selectorville/selectors.html`

Remember that you can just open that file directly from your hard drive.

Use the "What can I use" dialog to find some interesting things to query and highlight. Look at the source code of the HTML file to find other interesting CSS selectors to run as well.

## Day 3: Build a nav out of a UL

In the Layout demo part of the you saw that we can convert a HTML list into a navigational element by changing the display and other CSS properties.

On this day, use a similar technique to convert a list of hyperlinks into the Talk Python To Me podcast's site navigation:

![](talk-python-nav.png)

Don't worry about the big image below or the Linode ad banner. Just recreate the nav over at [https://talkpython.fm/](https://talkpython.fm/) from something like:

- TalkPython['Podcast']
- Episodes
- Python Courses
- Friends of the show
- Patreon
- Contact

Bonus points if you can recreate the search graphic using [font-awesome](https://fontawesome.com/icons) (as it was originally created).

## Day 4: Research Bootstrap themes

While we did not have time to cover [Bootstrap](https://getbootstrap.com/) and the rich theme ecosystem, it is very helpful when building web applications and speeding up the design process.

So, this day is to dream a little. Imagine some cool business or product you'd like to create some day or maybe your company is working on but has a poor design. 

Then visit Wrap Bootstrap, a commercial theme site:

[https://wrapbootstrap.com/](https://wrapbootstrap.com/)

Yes, you would have to buy these themes, but they are often just $20 once for a whole web design. Your goal is to search around here and find 3 potential themes as the starting point for your new website for your product or service.

You don't have to build anything. We just want you to get a little exposure to the idea of themes and Bootstrap.

### Time to share what you've accomplished!

Be sure to share your last couple of days work on Twitter or Facebook. Use the hashtag **#100DaysOfWeb**. 

Here are [some examples](https://twitter.com/search?q=%23100DaysOfCode) to inspire you. Consider including [@talkpython](https://twitter.com/talkpython) and [@pybites](https://twitter.com/pybites) in your tweets.

*See a mistake in these instructions? Please [submit a new issue](https://github.com/talkpython/100daysofweb-with-python-course/issues) or fix it and [submit a PR](https://github.com/talkpython/100daysofweb-with-python-course/pulls).*


